/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.math;

import com.kreative.openxion.math.MathProcessor;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigMath
extends MathProcessor {
    public static final BigMath instance = new BigMath();
    private static final BigDecimal TWO = BigDecimal.valueOf(2.0);
    private static final BigDecimal THREE = BigDecimal.valueOf(3.0);
    private static final BigDecimal FOUR = BigDecimal.valueOf(4.0);
    private static final int G = 7;
    private static final double[] P = new double[]{0.9999999999998099, 676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};

    public BigDecimal cbrt(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.cbrt(bigDecimal.doubleValue());
        if (Double.isNaN(d)) {
            return null;
        }
        if (d == 0.0) {
            return BigDecimal.ZERO;
        }
        if (Double.isInfinite(d)) {
            d = Double.MAX_VALUE;
        }
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, mathContext).divide(bigDecimal2, mathContext).add(bigDecimal2, mathContext).add(bigDecimal2, mathContext).divide(THREE, mathContext);
        while (bigDecimal2.compareTo(bigDecimal3) != 0) {
            bigDecimal2 = bigDecimal3;
            bigDecimal3 = bigDecimal.divide(bigDecimal2, mathContext).divide(bigDecimal2, mathContext).add(bigDecimal2, mathContext).add(bigDecimal2, mathContext).divide(THREE, mathContext);
        }
        return bigDecimal3;
    }

    public BigDecimal cos(BigDecimal bigDecimal, MathContext mathContext) {
        bigDecimal = bigDecimal.abs();
        BigDecimal bigDecimal2 = this.pi(mathContext);
        BigDecimal bigDecimal3 = TWO.multiply(bigDecimal2, mathContext);
        BigDecimal bigDecimal4 = bigDecimal2.divide(TWO, mathContext);
        BigDecimal bigDecimal5 = bigDecimal2.add(bigDecimal4, mathContext);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0 || bigDecimal.compareTo(bigDecimal3) == 0) {
            return BigDecimal.ONE;
        }
        if (bigDecimal.compareTo(bigDecimal4) == 0 || bigDecimal.compareTo(bigDecimal5) == 0) {
            return BigDecimal.ZERO;
        }
        if (bigDecimal.compareTo(bigDecimal2) == 0) {
            return BigDecimal.ONE.negate();
        }
        if (bigDecimal.compareTo(bigDecimal3) > 0) {
            BigDecimal bigDecimal6 = bigDecimal.divideToIntegralValue(bigDecimal3);
            return this.cos(bigDecimal.subtract(bigDecimal3.multiply(bigDecimal6, mathContext), mathContext), mathContext);
        }
        BigDecimal bigDecimal7 = BigDecimal.ZERO;
        BigDecimal bigDecimal8 = BigDecimal.ONE;
        BigDecimal bigDecimal9 = BigDecimal.ONE;
        BigDecimal bigDecimal10 = BigDecimal.ZERO;
        BigDecimal bigDecimal11 = BigDecimal.ONE;
        while (bigDecimal10.compareTo(bigDecimal11) != 0) {
            bigDecimal7 = bigDecimal7.add(BigDecimal.ONE);
            bigDecimal8 = bigDecimal8.divide(bigDecimal7, mathContext);
            bigDecimal7 = bigDecimal7.add(BigDecimal.ONE);
            bigDecimal8 = bigDecimal8.negate().divide(bigDecimal7, mathContext);
            bigDecimal9 = bigDecimal9.multiply(bigDecimal, mathContext).multiply(bigDecimal, mathContext);
            bigDecimal10 = bigDecimal11;
            bigDecimal11 = bigDecimal11.add(bigDecimal9.multiply(bigDecimal8, mathContext), mathContext);
        }
        return bigDecimal11;
    }

    public BigDecimal cosh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this.exp(TWO.multiply(bigDecimal, mathContext), mathContext);
        BigDecimal bigDecimal3 = TWO.multiply(this.exp(bigDecimal, mathContext), mathContext);
        return bigDecimal2.add(BigDecimal.ONE, mathContext).divide(bigDecimal3, mathContext);
    }

    public BigDecimal e(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        BigDecimal bigDecimal3 = BigDecimal.ONE;
        BigDecimal bigDecimal4 = BigDecimal.ONE;
        while (bigDecimal.compareTo(bigDecimal2) != 0) {
            bigDecimal = bigDecimal2;
            bigDecimal2 = bigDecimal2.add(bigDecimal4, mathContext);
            bigDecimal3 = bigDecimal3.add(BigDecimal.ONE);
            bigDecimal4 = bigDecimal4.divide(bigDecimal3, mathContext);
        }
        return bigDecimal2;
    }

    public BigDecimal exp(BigDecimal bigDecimal, MathContext mathContext) {
        int n = bigDecimal.compareTo(BigDecimal.ZERO);
        if (n == 0) {
            return BigDecimal.ONE;
        }
        if (n < 0) {
            return BigDecimal.ONE.divide(this.exp(bigDecimal.negate(), mathContext), mathContext);
        }
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal bigDecimal3 = BigDecimal.ONE;
        BigDecimal bigDecimal4 = BigDecimal.ONE;
        BigDecimal bigDecimal5 = BigDecimal.ONE;
        BigDecimal bigDecimal6 = bigDecimal;
        while (bigDecimal2.compareTo(bigDecimal3) != 0) {
            bigDecimal2 = bigDecimal3;
            bigDecimal3 = bigDecimal3.add(bigDecimal6.multiply(bigDecimal5, mathContext), mathContext);
            bigDecimal4 = bigDecimal4.add(BigDecimal.ONE);
            bigDecimal5 = bigDecimal5.divide(bigDecimal4, mathContext);
            bigDecimal6 = bigDecimal6.multiply(bigDecimal, mathContext);
        }
        return bigDecimal3;
    }

    public BigDecimal expm1(BigDecimal bigDecimal, MathContext mathContext) {
        return this.exp(bigDecimal, mathContext).subtract(BigDecimal.ONE);
    }

    public BigDecimal hypot(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        return this.sqrt(bigDecimal.multiply(bigDecimal, mathContext).add(bigDecimal2.multiply(bigDecimal2, mathContext), mathContext), mathContext);
    }

    public BigDecimal log(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log(bigDecimal.doubleValue());
        if (Double.isNaN(d)) {
            return null;
        }
        if (Double.isInfinite(d) && d < 0.0) {
            return null;
        }
        if (Double.isInfinite(d) && d > 0.0) {
            d = Double.MAX_VALUE;
        }
        MathContext mathContext2 = new MathContext(mathContext.getPrecision() + (int)Math.log(mathContext.getPrecision()), mathContext.getRoundingMode());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d);
        BigDecimal bigDecimal3 = bigDecimal2.subtract(BigDecimal.ONE, mathContext2).add(bigDecimal.divide(this.exp(bigDecimal2, mathContext2), mathContext2));
        while (bigDecimal2.subtract(bigDecimal3, mathContext).compareTo(BigDecimal.ZERO) != 0) {
            bigDecimal2 = bigDecimal3;
            bigDecimal3 = bigDecimal2.subtract(BigDecimal.ONE, mathContext2).add(bigDecimal.divide(this.exp(bigDecimal2, mathContext2), mathContext2));
        }
        return bigDecimal3.round(mathContext);
    }

    public BigDecimal log1p(BigDecimal bigDecimal, MathContext mathContext) {
        return this.log(bigDecimal.add(BigDecimal.ONE), mathContext);
    }

    public BigDecimal pi(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.ONE;
        BigDecimal bigDecimal2 = bigDecimal.divide(this.sqrt(TWO, mathContext), mathContext);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(0.25);
        BigDecimal bigDecimal4 = BigDecimal.ONE;
        while (bigDecimal.compareTo(bigDecimal2) != 0) {
            BigDecimal bigDecimal5 = bigDecimal;
            bigDecimal = bigDecimal.add(bigDecimal2, mathContext).divide(TWO, mathContext);
            bigDecimal2 = this.sqrt(bigDecimal2.multiply(bigDecimal5, mathContext), mathContext);
            bigDecimal3 = bigDecimal3.subtract(bigDecimal4.multiply(bigDecimal5.subtract(bigDecimal, mathContext).multiply(bigDecimal5.subtract(bigDecimal, mathContext), mathContext), mathContext), mathContext);
            bigDecimal4 = bigDecimal4.multiply(TWO, mathContext);
        }
        return bigDecimal.add(bigDecimal2, mathContext).multiply(bigDecimal.add(bigDecimal2, mathContext), mathContext).divide(bigDecimal3.multiply(FOUR, mathContext), mathContext);
    }

    public BigDecimal sin(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigDecimal bigDecimal3 = this.pi(mathContext);
        BigDecimal bigDecimal4 = TWO.multiply(bigDecimal3, mathContext);
        BigDecimal bigDecimal5 = bigDecimal3.divide(TWO, mathContext);
        BigDecimal bigDecimal6 = bigDecimal3.add(bigDecimal5, mathContext);
        if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0 || bigDecimal2.compareTo(bigDecimal3) == 0 || bigDecimal2.compareTo(bigDecimal4) == 0) {
            return BigDecimal.ZERO;
        }
        if (bigDecimal.compareTo(bigDecimal5) == 0 || bigDecimal.compareTo(bigDecimal6.negate()) == 0) {
            return BigDecimal.ONE;
        }
        if (bigDecimal.compareTo(bigDecimal5.negate()) == 0 || bigDecimal.compareTo(bigDecimal6) == 0) {
            return BigDecimal.ONE.negate();
        }
        if (bigDecimal.abs().compareTo(bigDecimal4) > 0) {
            BigDecimal bigDecimal7 = bigDecimal.divideToIntegralValue(bigDecimal4);
            return this.sin(bigDecimal.subtract(bigDecimal4.multiply(bigDecimal7, mathContext), mathContext), mathContext);
        }
        BigDecimal bigDecimal8 = BigDecimal.ONE;
        BigDecimal bigDecimal9 = BigDecimal.ONE;
        BigDecimal bigDecimal10 = bigDecimal;
        BigDecimal bigDecimal11 = BigDecimal.ZERO;
        BigDecimal bigDecimal12 = bigDecimal;
        while (bigDecimal11.compareTo(bigDecimal12) != 0) {
            bigDecimal8 = bigDecimal8.add(BigDecimal.ONE);
            bigDecimal9 = bigDecimal9.divide(bigDecimal8, mathContext);
            bigDecimal8 = bigDecimal8.add(BigDecimal.ONE);
            bigDecimal9 = bigDecimal9.negate().divide(bigDecimal8, mathContext);
            bigDecimal10 = bigDecimal10.multiply(bigDecimal, mathContext).multiply(bigDecimal, mathContext);
            bigDecimal11 = bigDecimal12;
            bigDecimal12 = bigDecimal12.add(bigDecimal10.multiply(bigDecimal9, mathContext), mathContext);
        }
        return bigDecimal12;
    }

    public BigDecimal sinh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this.exp(TWO.multiply(bigDecimal, mathContext), mathContext);
        BigDecimal bigDecimal3 = TWO.multiply(this.exp(bigDecimal, mathContext), mathContext);
        return bigDecimal2.subtract(BigDecimal.ONE, mathContext).divide(bigDecimal3, mathContext);
    }

    public BigDecimal sqrt(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.sqrt(bigDecimal.doubleValue());
        if (Double.isNaN(d)) {
            return null;
        }
        if (d == 0.0) {
            return BigDecimal.ZERO;
        }
        if (Double.isInfinite(d)) {
            d = Double.MAX_VALUE;
        }
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, mathContext).add(bigDecimal2, mathContext).divide(TWO, mathContext);
        while (bigDecimal2.compareTo(bigDecimal3) != 0) {
            bigDecimal2 = bigDecimal3;
            bigDecimal3 = bigDecimal.divide(bigDecimal2, mathContext).add(bigDecimal2, mathContext).divide(TWO, mathContext);
        }
        return bigDecimal3;
    }

    public BigDecimal tan(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigDecimal bigDecimal3 = this.pi(mathContext);
        BigDecimal bigDecimal4 = TWO.multiply(bigDecimal3, mathContext);
        BigDecimal bigDecimal5 = bigDecimal3.divide(TWO, mathContext);
        BigDecimal bigDecimal6 = bigDecimal3.add(bigDecimal5, mathContext);
        if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0 || bigDecimal2.compareTo(bigDecimal3) == 0 || bigDecimal2.compareTo(bigDecimal4) == 0) {
            return BigDecimal.ZERO;
        }
        if (bigDecimal2.compareTo(bigDecimal5) == 0 || bigDecimal2.compareTo(bigDecimal6) == 0) {
            return null;
        }
        BigDecimal bigDecimal7 = this.sin(bigDecimal, mathContext);
        BigDecimal bigDecimal8 = this.cos(bigDecimal, mathContext);
        if (bigDecimal7.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return bigDecimal7.divide(bigDecimal8, mathContext);
    }

    public BigDecimal tanh(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = this.exp(TWO.multiply(bigDecimal, mathContext), mathContext);
        return bigDecimal2.subtract(BigDecimal.ONE, mathContext).divide(bigDecimal2.add(BigDecimal.ONE, mathContext), mathContext);
    }

    public BigDecimal acos(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.acos(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal asin(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.asin(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal atan(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.atan(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal atan2(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        double d = Math.atan2(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal log10(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log10(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal log2(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log(bigDecimal.doubleValue()) / Math.log(2.0);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal pow(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        double d = Math.pow(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    private static double gamma(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NaN;
        }
        if (d < 0.0 && (double)Math.round(d) == d) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 1.0 || d == 2.0) {
            return 1.0;
        }
        if (d < 0.5) {
            return Math.PI / (Math.sin(Math.PI * d) * BigMath.gamma(1.0 - d));
        }
        d -= 1.0;
        double d2 = P[0];
        for (int i = 1; i < 9; ++i) {
            d2 += P[i] / (d + (double)i);
        }
        double d3 = d + 7.0 + 0.5;
        return Math.sqrt(Math.PI * 2) * Math.pow(d3, d + 0.5) * Math.exp(-d3) * d2;
    }

    public BigDecimal gamma(BigDecimal bigDecimal, MathContext mathContext) {
        double d = BigMath.gamma(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal loggamma(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log(BigMath.gamma(bigDecimal.doubleValue()));
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }
}

