/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.math;

import com.kreative.openxion.math.MathProcessor;
import java.math.BigDecimal;
import java.math.MathContext;

public class FastMath
extends MathProcessor {
    public static final FastMath instance = new FastMath();
    private static final int G = 7;
    private static final double[] P = new double[]{0.9999999999998099, 676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};

    public BigDecimal acos(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.acos(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal asin(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.asin(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal atan(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.atan(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal atan2(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        double d = Math.atan2(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal cbrt(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.cbrt(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal cos(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.cos(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal cosh(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.cosh(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal e(MathContext mathContext) {
        return BigDecimal.valueOf(Math.E);
    }

    public BigDecimal exp(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.exp(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal expm1(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.expm1(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal hypot(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        double d = Math.hypot(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal log(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal log10(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log10(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal log1p(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log1p(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal log2(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log(bigDecimal.doubleValue()) / Math.log(2.0);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal pi(MathContext mathContext) {
        return BigDecimal.valueOf(Math.PI);
    }

    public BigDecimal pow(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext) {
        double d = Math.pow(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal sin(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.sin(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal sinh(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.sinh(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal sqrt(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.sqrt(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal tan(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.tan(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal tanh(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.tanh(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    private static double gamma(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NaN;
        }
        if (d < 0.0 && (double)Math.round(d) == d) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 1.0 || d == 2.0) {
            return 1.0;
        }
        if (d < 0.5) {
            return Math.PI / (Math.sin(Math.PI * d) * FastMath.gamma(1.0 - d));
        }
        d -= 1.0;
        double d2 = P[0];
        for (int i = 1; i < 9; ++i) {
            d2 += P[i] / (d + (double)i);
        }
        double d3 = d + 7.0 + 0.5;
        return Math.sqrt(Math.PI * 2) * Math.pow(d3, d + 0.5) * Math.exp(-d3) * d2;
    }

    public BigDecimal gamma(BigDecimal bigDecimal, MathContext mathContext) {
        double d = FastMath.gamma(bigDecimal.doubleValue());
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    public BigDecimal loggamma(BigDecimal bigDecimal, MathContext mathContext) {
        double d = Math.log(FastMath.gamma(bigDecimal.doubleValue()));
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }
}

