/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.math;

import com.kreative.openxion.math.MathProcessor;
import com.kreative.openxion.xom.inst.XOMComplex;
import java.math.BigDecimal;
import java.math.MathContext;

public class XOMComplexMath {
    private static final int G = 7;
    private static final XOMComplex[] P = new XOMComplex[]{new XOMComplex(0.9999999999998099, 0.0), new XOMComplex(676.5203681218851, 0.0), new XOMComplex(-1259.1392167224028, 0.0), new XOMComplex(771.3234287776531, 0.0), new XOMComplex(-176.6150291621406, 0.0), new XOMComplex(12.507343278686905, 0.0), new XOMComplex(-0.13857109526572012, 0.0), new XOMComplex(9.984369578019572E-6, 0.0), new XOMComplex(1.5056327351493116E-7, 0.0)};

    private XOMComplexMath() {
    }

    public static XOMComplex add(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isNaN() || xOMComplex2.isNaN()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite() && xOMComplex2.isInfinite()) {
            if (xOMComplex.getQuadrant() == xOMComplex2.getQuadrant()) {
                return xOMComplex;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite()) {
            return xOMComplex;
        }
        if (xOMComplex2.isInfinite()) {
            return xOMComplex2;
        }
        BigDecimal bigDecimal = xOMComplex.realPart().add(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal2 = xOMComplex.imaginaryPart().add(xOMComplex2.imaginaryPart(), mathContext);
        return new XOMComplex(bigDecimal, bigDecimal2);
    }

    public static XOMComplex subtract(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isNaN() || xOMComplex2.isNaN()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite() && xOMComplex2.isInfinite()) {
            if (xOMComplex.getQuadrant() == xOMComplex2.getOppositeQuadrant()) {
                return xOMComplex;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite()) {
            return xOMComplex;
        }
        if (xOMComplex2.isInfinite()) {
            return xOMComplex2.negate();
        }
        BigDecimal bigDecimal = xOMComplex.realPart().subtract(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal2 = xOMComplex.imaginaryPart().subtract(xOMComplex2.imaginaryPart(), mathContext);
        return new XOMComplex(bigDecimal, bigDecimal2);
    }

    public static XOMComplex multiply(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isNaN() || xOMComplex2.isNaN()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite() || xOMComplex2.isInfinite()) {
            if (xOMComplex.isZero() || xOMComplex2.isZero()) {
                return XOMComplex.NaN;
            }
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            int n3 = xOMComplex2.realPart().compareTo(BigDecimal.ZERO);
            int n4 = xOMComplex2.imaginaryPart().compareTo(BigDecimal.ZERO);
            int n5 = n * n3 - n2 * n4;
            int n6 = n * n4 + n2 * n3;
            if (n5 == 0 || n6 == 0) {
                return XOMComplex.NaN;
            }
            return XOMComplex.makeInfinity(n5, n6);
        }
        BigDecimal bigDecimal = xOMComplex.realPart().multiply(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal2 = xOMComplex.imaginaryPart().multiply(xOMComplex2.imaginaryPart(), mathContext);
        BigDecimal bigDecimal3 = xOMComplex.imaginaryPart().multiply(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal4 = xOMComplex.realPart().multiply(xOMComplex2.imaginaryPart(), mathContext);
        BigDecimal bigDecimal5 = bigDecimal.subtract(bigDecimal2, mathContext);
        BigDecimal bigDecimal6 = bigDecimal3.add(bigDecimal4, mathContext);
        return new XOMComplex(bigDecimal5, bigDecimal6);
    }

    public static XOMComplex divide(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isNaN() || xOMComplex2.isNaN()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite() && xOMComplex2.isInfinite() || xOMComplex.isZero() && xOMComplex2.isZero()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex2.isZero()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 || n2 == 0) {
                return XOMComplex.NaN;
            }
            return XOMComplex.makeInfinity(n, n2);
        }
        if (xOMComplex.isInfinite()) {
            if (xOMComplex2.isZero()) {
                return xOMComplex;
            }
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n3 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            int n4 = xOMComplex2.realPart().compareTo(BigDecimal.ZERO);
            int n5 = xOMComplex2.imaginaryPart().compareTo(BigDecimal.ZERO);
            int n6 = n * n4 - n3 * n5;
            int n7 = n * n5 + n3 * n4;
            if (n6 == 0 || n7 == 0) {
                return XOMComplex.NaN;
            }
            return XOMComplex.makeInfinity(n6, n7);
        }
        if (xOMComplex2.isInfinite() || xOMComplex.isZero()) {
            return XOMComplex.ZERO;
        }
        BigDecimal bigDecimal = xOMComplex.realPart().multiply(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal2 = xOMComplex.imaginaryPart().multiply(xOMComplex2.imaginaryPart(), mathContext);
        BigDecimal bigDecimal3 = xOMComplex.imaginaryPart().multiply(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal4 = xOMComplex.realPart().multiply(xOMComplex2.imaginaryPart(), mathContext);
        BigDecimal bigDecimal5 = xOMComplex2.realPart().multiply(xOMComplex2.realPart(), mathContext);
        BigDecimal bigDecimal6 = xOMComplex2.imaginaryPart().multiply(xOMComplex2.imaginaryPart(), mathContext);
        BigDecimal bigDecimal7 = bigDecimal.add(bigDecimal2, mathContext);
        BigDecimal bigDecimal8 = bigDecimal3.subtract(bigDecimal4, mathContext);
        BigDecimal bigDecimal9 = bigDecimal5.add(bigDecimal6, mathContext);
        BigDecimal bigDecimal10 = bigDecimal7.divide(bigDecimal9, mathContext);
        BigDecimal bigDecimal11 = bigDecimal8.divide(bigDecimal9, mathContext);
        return new XOMComplex(bigDecimal10, bigDecimal11);
    }

    public static XOMComplex pow(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isNaN() || xOMComplex2.isNaN()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            if (xOMComplex2.getQuadrant() == 1) {
                return XOMComplex.ZERO;
            }
            if (xOMComplex2.getQuadrant() == 2) {
                return XOMComplex.POSITIVE_INFINITY;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite() || xOMComplex2.isInfinite()) {
            if (xOMComplex.getQuadrant() == 1) {
                if (xOMComplex2.getQuadrant() == 1) {
                    return XOMComplex.POSITIVE_INFINITY;
                }
                if (xOMComplex2.getQuadrant() == 2) {
                    return XOMComplex.ZERO;
                }
                return XOMComplex.NaN;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex2.isZero()) {
            return XOMComplex.ONE;
        }
        BigDecimal bigDecimal = xOMComplex.realPart();
        BigDecimal bigDecimal2 = xOMComplex.imaginaryPart();
        BigDecimal bigDecimal3 = xOMComplex2.realPart();
        BigDecimal bigDecimal4 = xOMComplex2.imaginaryPart();
        BigDecimal bigDecimal5 = mathProcessor.hypot(bigDecimal, bigDecimal2, mathContext);
        BigDecimal bigDecimal6 = mathProcessor.atan2(bigDecimal2, bigDecimal, mathContext);
        BigDecimal bigDecimal7 = mathProcessor.pow(bigDecimal5, bigDecimal3, mathContext).multiply(mathProcessor.exp(bigDecimal6.negate().multiply(bigDecimal4, mathContext), mathContext), mathContext);
        BigDecimal bigDecimal8 = bigDecimal4.multiply(mathProcessor.log(bigDecimal5, mathContext), mathContext).add(bigDecimal3.multiply(bigDecimal6, mathContext), mathContext);
        BigDecimal bigDecimal9 = bigDecimal7.multiply(mathProcessor.cos(bigDecimal8, mathContext), mathContext);
        BigDecimal bigDecimal10 = bigDecimal7.multiply(mathProcessor.sin(bigDecimal8, mathContext), mathContext);
        return new XOMComplex(bigDecimal9, bigDecimal10);
    }

    public static XOMComplex abs(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return XOMComplex.NaN;
            }
            return new XOMComplex(n != 0 ? Double.POSITIVE_INFINITY : 0.0, n2 != 0 ? Double.POSITIVE_INFINITY : 0.0);
        }
        BigDecimal bigDecimal = mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext);
        if (bigDecimal == null) {
            return XOMComplex.NaN;
        }
        return new XOMComplex(bigDecimal, BigDecimal.ZERO);
    }

    public static XOMComplex arg(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0 || n != 0 && n2 != 0) {
                return XOMComplex.NaN;
            }
            BigDecimal bigDecimal = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext);
            if (bigDecimal == null) {
                return XOMComplex.NaN;
            }
            return new XOMComplex(bigDecimal, BigDecimal.ZERO);
        }
        BigDecimal bigDecimal = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext);
        if (bigDecimal == null) {
            return XOMComplex.NaN;
        }
        return new XOMComplex(bigDecimal, BigDecimal.ZERO);
    }

    public static XOMComplex signum(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0 || n != 0 && n2 != 0) {
                return XOMComplex.NaN;
            }
            if (n == 0 && n2 != 0) {
                return n2 < 0 ? new XOMComplex(BigDecimal.ZERO, BigDecimal.ONE.negate()) : new XOMComplex(BigDecimal.ZERO, BigDecimal.ONE);
            }
            if (n2 == 0 && n != 0) {
                return n < 0 ? new XOMComplex(BigDecimal.ONE.negate(), BigDecimal.ZERO) : new XOMComplex(BigDecimal.ONE, BigDecimal.ZERO);
            }
            return XOMComplex.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext);
        if (bigDecimal == null) {
            return XOMComplex.NaN;
        }
        return new XOMComplex(xOMComplex.realPart().divide(bigDecimal, mathContext), xOMComplex.imaginaryPart().divide(bigDecimal, mathContext));
    }

    public static XOMComplex annuity(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isZero() || xOMComplex2.isZero()) {
            return xOMComplex2;
        }
        return XOMComplexMath.divide(XOMComplexMath.subtract(XOMComplex.ONE, XOMComplexMath.pow(XOMComplexMath.add(XOMComplex.ONE, xOMComplex, mathContext, mathProcessor), xOMComplex2.negate(), mathContext, mathProcessor), mathContext, mathProcessor), xOMComplex, mathContext, mathProcessor);
    }

    public static XOMComplex compound(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isZero() || xOMComplex2.isZero()) {
            return XOMComplex.ONE;
        }
        return XOMComplexMath.pow(XOMComplexMath.add(XOMComplex.ONE, xOMComplex, mathContext, mathProcessor), xOMComplex2, mathContext, mathProcessor);
    }

    public static XOMComplex sqrt(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n <= 0 || n2 != 0) {
                return XOMComplex.NaN;
            }
            return XOMComplex.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext);
        BigDecimal bigDecimal2 = bigDecimal.add(xOMComplex.realPart(), mathContext).divide(BigDecimal.valueOf(2.0), mathContext);
        BigDecimal bigDecimal3 = bigDecimal.subtract(xOMComplex.realPart(), mathContext).divide(BigDecimal.valueOf(2.0), mathContext);
        BigDecimal bigDecimal4 = mathProcessor.sqrt(bigDecimal2, mathContext);
        BigDecimal bigDecimal5 = mathProcessor.sqrt(bigDecimal3, mathContext);
        if (xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO) < 0) {
            bigDecimal5 = bigDecimal5.negate();
        }
        return new XOMComplex(bigDecimal4, bigDecimal5);
    }

    public static XOMComplex cbrt(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n <= 0 || n2 != 0) {
                return XOMComplex.NaN;
            }
            return XOMComplex.POSITIVE_INFINITY;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.ZERO;
        }
        BigDecimal bigDecimal = mathProcessor.log(mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext), mathContext).divide(BigDecimal.valueOf(3.0), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext).divide(BigDecimal.valueOf(3.0), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.exp(bigDecimal, mathContext);
        BigDecimal bigDecimal4 = mathProcessor.cos(bigDecimal2, mathContext);
        BigDecimal bigDecimal5 = mathProcessor.sin(bigDecimal2, mathContext);
        return new XOMComplex(bigDecimal3.multiply(bigDecimal4, mathContext), bigDecimal3.multiply(bigDecimal5, mathContext));
    }

    public static XOMComplex agm(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        XOMComplex xOMComplex3 = new XOMComplex(2, 0);
        while (!xOMComplex.isNaN() && !xOMComplex2.isNaN()) {
            XOMComplex xOMComplex4;
            XOMComplex xOMComplex5 = XOMComplexMath.divide(XOMComplexMath.add(xOMComplex, xOMComplex2, mathContext, mathProcessor), xOMComplex3, mathContext, mathProcessor);
            if (xOMComplex5.equals(xOMComplex4 = XOMComplexMath.sqrt(XOMComplexMath.multiply(xOMComplex, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor))) {
                return xOMComplex5;
            }
            xOMComplex = xOMComplex5;
            xOMComplex2 = xOMComplex4;
        }
        return XOMComplex.NaN;
    }

    public static XOMComplex exp(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 || n2 != 0) {
                return XOMComplex.NaN;
            }
            if (n < 0) {
                return XOMComplex.ZERO;
            }
            return XOMComplex.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.exp(xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.cos(xOMComplex.imaginaryPart(), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.sin(xOMComplex.imaginaryPart(), mathContext);
        return new XOMComplex(bigDecimal.multiply(bigDecimal2, mathContext), bigDecimal.multiply(bigDecimal3, mathContext));
    }

    public static XOMComplex expm1(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 || n2 != 0) {
                return XOMComplex.NaN;
            }
            if (n < 0) {
                return XOMComplex.ZERO;
            }
            return XOMComplex.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.exp(xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.cos(xOMComplex.imaginaryPart(), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.sin(xOMComplex.imaginaryPart(), mathContext);
        return new XOMComplex(bigDecimal.multiply(bigDecimal2, mathContext).subtract(BigDecimal.ONE), bigDecimal.multiply(bigDecimal3, mathContext));
    }

    public static XOMComplex exp2(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 || n2 != 0) {
                return XOMComplex.NaN;
            }
            if (n < 0) {
                return XOMComplex.ZERO;
            }
            return XOMComplex.POSITIVE_INFINITY;
        }
        return XOMComplexMath.pow(new XOMComplex(2.0, 0.0), xOMComplex, mathContext, mathProcessor);
    }

    public static XOMComplex exp10(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n == 0 || n2 != 0) {
                return XOMComplex.NaN;
            }
            if (n < 0) {
                return XOMComplex.ZERO;
            }
            return XOMComplex.POSITIVE_INFINITY;
        }
        return XOMComplexMath.pow(new XOMComplex(10.0, 0.0), xOMComplex, mathContext, mathProcessor);
    }

    public static XOMComplex log(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n > 0 && n2 == 0) {
                return XOMComplex.POSITIVE_INFINITY;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.log(mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext);
        return new XOMComplex(bigDecimal, bigDecimal2);
    }

    public static XOMComplex log1p(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n > 0 && n2 == 0) {
                return XOMComplex.POSITIVE_INFINITY;
            }
            return XOMComplex.NaN;
        }
        if ((xOMComplex = new XOMComplex(xOMComplex.realPart().add(BigDecimal.ONE), xOMComplex.imaginaryPart())).isZero()) {
            return XOMComplex.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.log(mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext);
        return new XOMComplex(bigDecimal, bigDecimal2);
    }

    public static XOMComplex log2(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n > 0 && n2 == 0) {
                return XOMComplex.POSITIVE_INFINITY;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.log2(mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.log(BigDecimal.valueOf(2L), mathContext);
        return new XOMComplex(bigDecimal, bigDecimal2.divide(bigDecimal3, mathContext));
    }

    public static XOMComplex log10(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.realPart() == null || xOMComplex.imaginaryPart() == null) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isUndefined()) {
            int n = xOMComplex.realPart().compareTo(BigDecimal.ZERO);
            int n2 = xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO);
            if (n > 0 && n2 == 0) {
                return XOMComplex.POSITIVE_INFINITY;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.log10(mathProcessor.hypot(xOMComplex.realPart(), xOMComplex.imaginaryPart(), mathContext), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.atan2(xOMComplex.imaginaryPart(), xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.log(BigDecimal.valueOf(10L), mathContext);
        return new XOMComplex(bigDecimal, bigDecimal2.divide(bigDecimal3, mathContext));
    }

    public static XOMComplex sin(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.sin(xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.cosh(xOMComplex.imaginaryPart(), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.cos(xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal4 = mathProcessor.sinh(xOMComplex.imaginaryPart(), mathContext);
        return new XOMComplex(bigDecimal.multiply(bigDecimal2, mathContext), bigDecimal3.multiply(bigDecimal4, mathContext));
    }

    public static XOMComplex cos(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.cos(xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal2 = mathProcessor.cosh(xOMComplex.imaginaryPart(), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.sin(xOMComplex.realPart(), mathContext);
        BigDecimal bigDecimal4 = mathProcessor.sinh(xOMComplex.imaginaryPart(), mathContext);
        return new XOMComplex(bigDecimal.multiply(bigDecimal2, mathContext), bigDecimal3.multiply(bigDecimal4, mathContext).negate());
    }

    public static XOMComplex tan(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        return XOMComplexMath.divide(XOMComplexMath.sin(xOMComplex, mathContext, mathProcessor), XOMComplexMath.cos(xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex cot(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        return XOMComplexMath.divide(XOMComplexMath.cos(xOMComplex, mathContext, mathProcessor), XOMComplexMath.sin(xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex csc(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        return XOMComplexMath.divide(XOMComplex.ONE, XOMComplexMath.sin(xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex sec(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        return XOMComplexMath.divide(XOMComplex.ONE, XOMComplexMath.cos(xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex sinh(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = new XOMComplex(xOMComplex.imaginaryPart().negate(), xOMComplex.realPart());
        XOMComplex xOMComplex3 = XOMComplexMath.sin(xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = new XOMComplex(xOMComplex3.imaginaryPart(), xOMComplex3.realPart().negate());
        return xOMComplex4;
    }

    public static XOMComplex cosh(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = new XOMComplex(xOMComplex.imaginaryPart().negate(), xOMComplex.realPart());
        XOMComplex xOMComplex3 = XOMComplexMath.cos(xOMComplex2, mathContext, mathProcessor);
        return xOMComplex3;
    }

    public static XOMComplex tanh(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = new XOMComplex(xOMComplex.imaginaryPart().negate(), xOMComplex.realPart());
        XOMComplex xOMComplex3 = XOMComplexMath.tan(xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = new XOMComplex(xOMComplex3.imaginaryPart(), xOMComplex3.realPart().negate());
        return xOMComplex4;
    }

    public static XOMComplex coth(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.POSITIVE_INFINITY;
        }
        XOMComplex xOMComplex2 = new XOMComplex(xOMComplex.imaginaryPart().negate(), xOMComplex.realPart());
        XOMComplex xOMComplex3 = XOMComplexMath.cot(xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = new XOMComplex(xOMComplex3.imaginaryPart().negate(), xOMComplex3.realPart());
        return xOMComplex4;
    }

    public static XOMComplex csch(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = new XOMComplex(xOMComplex.imaginaryPart().negate(), xOMComplex.realPart());
        XOMComplex xOMComplex3 = XOMComplexMath.csc(xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = new XOMComplex(xOMComplex3.imaginaryPart().negate(), xOMComplex3.realPart());
        return xOMComplex4;
    }

    public static XOMComplex sech(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.POSITIVE_INFINITY;
        }
        XOMComplex xOMComplex2 = new XOMComplex(xOMComplex.imaginaryPart().negate(), xOMComplex.realPart());
        XOMComplex xOMComplex3 = XOMComplexMath.sec(xOMComplex2, mathContext, mathProcessor);
        return xOMComplex3;
    }

    public static XOMComplex asin(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = XOMComplexMath.sqrt(XOMComplexMath.subtract(XOMComplex.ONE, XOMComplexMath.multiply(xOMComplex, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex3 = XOMComplexMath.add(XOMComplexMath.multiply(XOMComplex.I, xOMComplex, mathContext, mathProcessor), xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.log(xOMComplex3, mathContext, mathProcessor);
        return XOMComplexMath.multiply(XOMComplex.I.negate(), xOMComplex4, mathContext, mathProcessor);
    }

    public static XOMComplex acos(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = XOMComplexMath.sqrt(XOMComplexMath.subtract(XOMComplex.ONE, XOMComplexMath.multiply(xOMComplex, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex3 = XOMComplexMath.add(xOMComplex, XOMComplexMath.multiply(XOMComplex.I, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.log(xOMComplex3, mathContext, mathProcessor);
        return XOMComplexMath.multiply(XOMComplex.I.negate(), xOMComplex4, mathContext, mathProcessor);
    }

    public static XOMComplex atan(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = XOMComplexMath.multiply(XOMComplex.I, xOMComplex, mathContext, mathProcessor);
        XOMComplex xOMComplex3 = XOMComplexMath.log(XOMComplexMath.subtract(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.log(XOMComplexMath.add(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex5 = XOMComplexMath.subtract(xOMComplex3, xOMComplex4, mathContext, mathProcessor);
        return XOMComplexMath.divide(XOMComplexMath.multiply(XOMComplex.I, xOMComplex5, mathContext, mathProcessor), new XOMComplex(2, 0), mathContext, mathProcessor);
    }

    public static XOMComplex acot(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = XOMComplexMath.divide(XOMComplex.I, xOMComplex, mathContext, mathProcessor);
        XOMComplex xOMComplex3 = XOMComplexMath.log(XOMComplexMath.subtract(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.log(XOMComplexMath.add(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex5 = XOMComplexMath.subtract(xOMComplex3, xOMComplex4, mathContext, mathProcessor);
        return XOMComplexMath.divide(XOMComplexMath.multiply(XOMComplex.I, xOMComplex5, mathContext, mathProcessor), new XOMComplex(2, 0), mathContext, mathProcessor);
    }

    public static XOMComplex acsc(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = XOMComplexMath.sqrt(XOMComplexMath.subtract(XOMComplex.ONE, XOMComplexMath.divide(XOMComplex.ONE, XOMComplexMath.multiply(xOMComplex, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex3 = XOMComplexMath.add(xOMComplex2, XOMComplexMath.divide(XOMComplex.I, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.log(xOMComplex3, mathContext, mathProcessor);
        return XOMComplexMath.multiply(XOMComplex.I.negate(), xOMComplex4, mathContext, mathProcessor);
    }

    public static XOMComplex asec(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = XOMComplexMath.sqrt(XOMComplexMath.subtract(XOMComplex.ONE, XOMComplexMath.divide(XOMComplex.ONE, XOMComplexMath.multiply(xOMComplex, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex3 = XOMComplexMath.add(XOMComplexMath.multiply(XOMComplex.I, xOMComplex2, mathContext, mathProcessor), XOMComplexMath.divide(XOMComplex.ONE, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.log(xOMComplex3, mathContext, mathProcessor);
        return XOMComplexMath.multiply(XOMComplex.I.negate(), xOMComplex4, mathContext, mathProcessor);
    }

    public static XOMComplex asinh(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return xOMComplex;
        }
        XOMComplex xOMComplex2 = xOMComplex;
        XOMComplex xOMComplex3 = XOMComplexMath.sqrt(XOMComplexMath.add(XOMComplexMath.multiply(xOMComplex2, xOMComplex2, mathContext, mathProcessor), XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
        return XOMComplexMath.log(XOMComplexMath.add(xOMComplex2, xOMComplex3, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex acosh(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            if (xOMComplex.getQuadrant() == 1) {
                return XOMComplex.POSITIVE_INFINITY;
            }
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = xOMComplex;
        XOMComplex xOMComplex3 = XOMComplexMath.sqrt(XOMComplexMath.subtract(xOMComplex2, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.sqrt(XOMComplexMath.add(xOMComplex2, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex5 = XOMComplexMath.multiply(xOMComplex3, xOMComplex4, mathContext, mathProcessor);
        return XOMComplexMath.log(XOMComplexMath.add(xOMComplex2, xOMComplex5, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex atanh(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO) == 0 && xOMComplex.realPart().abs().compareTo(BigDecimal.ONE) == 0) {
            return xOMComplex.realPart().signum() < 0 ? XOMComplex.NEGATIVE_INFINITY : XOMComplex.POSITIVE_INFINITY;
        }
        XOMComplex xOMComplex2 = xOMComplex;
        XOMComplex xOMComplex3 = XOMComplexMath.subtract(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.sqrt(XOMComplexMath.subtract(XOMComplex.ONE, XOMComplexMath.multiply(xOMComplex2, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        return XOMComplexMath.log(XOMComplexMath.divide(xOMComplex4, xOMComplex3, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex acoth(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            if (xOMComplex.isInfinite()) {
                return XOMComplex.ZERO;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO) == 0 && xOMComplex.realPart().abs().compareTo(BigDecimal.ONE) == 0) {
            return xOMComplex.realPart().signum() < 0 ? XOMComplex.NEGATIVE_INFINITY : XOMComplex.POSITIVE_INFINITY;
        }
        XOMComplex xOMComplex2 = xOMComplex;
        XOMComplex xOMComplex3 = XOMComplexMath.divide(XOMComplexMath.add(xOMComplex2, XOMComplex.ONE, mathContext, mathProcessor), XOMComplexMath.subtract(xOMComplex2, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
        return XOMComplexMath.divide(XOMComplexMath.log(xOMComplex3, mathContext, mathProcessor), new XOMComplex(2, 0), mathContext, mathProcessor);
    }

    public static XOMComplex acsch(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            if (xOMComplex.isInfinite()) {
                return XOMComplex.ZERO;
            }
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.NaN;
        }
        XOMComplex xOMComplex2 = xOMComplex;
        XOMComplex xOMComplex3 = XOMComplexMath.divide(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.divide(XOMComplex.ONE, XOMComplexMath.multiply(xOMComplex2, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex5 = XOMComplexMath.sqrt(XOMComplexMath.add(XOMComplex.ONE, xOMComplex4, mathContext, mathProcessor), mathContext, mathProcessor);
        return XOMComplexMath.log(XOMComplexMath.add(xOMComplex5, xOMComplex3, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex asech(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isUndefined()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.POSITIVE_INFINITY;
        }
        XOMComplex xOMComplex2 = xOMComplex;
        XOMComplex xOMComplex3 = XOMComplexMath.divide(XOMComplex.ONE, xOMComplex2, mathContext, mathProcessor);
        XOMComplex xOMComplex4 = XOMComplexMath.sqrt(XOMComplexMath.subtract(xOMComplex3, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex5 = XOMComplexMath.sqrt(XOMComplexMath.add(xOMComplex3, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
        XOMComplex xOMComplex6 = XOMComplexMath.multiply(xOMComplex4, xOMComplex5, mathContext, mathProcessor);
        return XOMComplexMath.log(XOMComplexMath.add(xOMComplex6, xOMComplex3, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex gamma(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMComplex.isNaN()) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isInfinite()) {
            return xOMComplex.getQuadrant() == 1 ? XOMComplex.POSITIVE_INFINITY : XOMComplex.NaN;
        }
        if (xOMComplex.realPart().compareTo(BigDecimal.ZERO) < 0 && xOMComplex.imaginaryPart().compareTo(BigDecimal.ZERO) == 0 && xOMComplex.realPart().setScale(0, 6).compareTo(xOMComplex.realPart()) == 0) {
            return XOMComplex.NaN;
        }
        if (xOMComplex.isZero()) {
            return XOMComplex.POSITIVE_INFINITY;
        }
        if (xOMComplex.realPart().compareTo(BigDecimal.valueOf(0.5)) < 0) {
            return XOMComplexMath.divide(XOMComplex.PI, XOMComplexMath.multiply(XOMComplexMath.sin(XOMComplexMath.multiply(XOMComplex.PI, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.gamma(XOMComplexMath.subtract(XOMComplex.ONE, xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        }
        xOMComplex = XOMComplexMath.subtract(xOMComplex, XOMComplex.ONE, mathContext, mathProcessor);
        XOMComplex xOMComplex2 = P[0];
        for (int i = 1; i < 9; ++i) {
            xOMComplex2 = XOMComplexMath.add(xOMComplex2, XOMComplexMath.divide(P[i], XOMComplexMath.add(xOMComplex, new XOMComplex(i, 0), mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
        }
        XOMComplex xOMComplex3 = XOMComplexMath.add(xOMComplex, new XOMComplex(7.5, 0.0), mathContext, mathProcessor);
        return XOMComplexMath.multiply(XOMComplexMath.multiply(XOMComplexMath.multiply(XOMComplexMath.sqrt(XOMComplexMath.multiply(new XOMComplex(2, 0), XOMComplex.PI, mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.pow(xOMComplex3, XOMComplexMath.add(xOMComplex, new XOMComplex(0.5, 0.0), mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.exp(xOMComplex3.negate(), mathContext, mathProcessor), mathContext, mathProcessor), xOMComplex2, mathContext, mathProcessor);
    }

    public static XOMComplex loggamma(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.log(XOMComplexMath.gamma(xOMComplex, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex fact(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.gamma(XOMComplexMath.add(xOMComplex, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex logfact(XOMComplex xOMComplex, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.loggamma(XOMComplexMath.add(xOMComplex, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex beta(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.divide(XOMComplexMath.multiply(XOMComplexMath.gamma(xOMComplex, mathContext, mathProcessor), XOMComplexMath.gamma(xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.gamma(XOMComplexMath.add(xOMComplex, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex logbeta(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.subtract(XOMComplexMath.add(XOMComplexMath.loggamma(xOMComplex, mathContext, mathProcessor), XOMComplexMath.loggamma(xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.loggamma(XOMComplexMath.add(xOMComplex, xOMComplex2, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex nPr(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.divide(XOMComplexMath.gamma(XOMComplexMath.add(xOMComplex, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.gamma(XOMComplexMath.add(XOMComplexMath.subtract(xOMComplex, xOMComplex2, mathContext, mathProcessor), XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMComplex nCr(XOMComplex xOMComplex, XOMComplex xOMComplex2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMComplexMath.divide(XOMComplexMath.divide(XOMComplexMath.gamma(XOMComplexMath.add(xOMComplex, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.gamma(XOMComplexMath.add(xOMComplex2, XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor), XOMComplexMath.gamma(XOMComplexMath.add(XOMComplexMath.subtract(xOMComplex, xOMComplex2, mathContext, mathProcessor), XOMComplex.ONE, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }
}

