/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.math;

import com.kreative.openxion.xom.inst.XOMInteger;
import java.util.Comparator;

public class XOMIntegerMath {
    public static final Comparator<XOMInteger> comparator = new Comparator<XOMInteger>(){

        @Override
        public int compare(XOMInteger xOMInteger, XOMInteger xOMInteger2) {
            return XOMIntegerMath.compare(xOMInteger, xOMInteger2);
        }
    };

    private XOMIntegerMath() {
    }

    public static int compare(XOMInteger xOMInteger, XOMInteger xOMInteger2) {
        if (xOMInteger.isUndefined() || xOMInteger2.isUndefined()) {
            int n;
            int n2;
            if (xOMInteger.isNaN()) {
                n2 = 3;
            } else if (xOMInteger.isInfinite()) {
                switch (xOMInteger.getSign()) {
                    case -2147483648: {
                        n2 = 3;
                        break;
                    }
                    case -1: {
                        n2 = -2;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 0: {
                        n2 = 3;
                        break;
                    }
                    default: {
                        n2 = 3;
                        break;
                    }
                }
            } else if (xOMInteger.isUndefined()) {
                n2 = 3;
            } else if (xOMInteger.isZero()) {
                n2 = 0;
            } else {
                switch (xOMInteger.getSign()) {
                    case -2147483648: {
                        n2 = 3;
                        break;
                    }
                    case -1: {
                        n2 = -1;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = 3;
                    }
                }
            }
            if (xOMInteger2.isNaN()) {
                n = 3;
            } else if (xOMInteger2.isInfinite()) {
                switch (xOMInteger2.getSign()) {
                    case -2147483648: {
                        n = 3;
                        break;
                    }
                    case -1: {
                        n = -2;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 0: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 3;
                        break;
                    }
                }
            } else if (xOMInteger2.isUndefined()) {
                n = 3;
            } else if (xOMInteger2.isZero()) {
                n = 0;
            } else {
                switch (xOMInteger2.getSign()) {
                    case -2147483648: {
                        n = 3;
                        break;
                    }
                    case -1: {
                        n = -1;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 0: {
                        n = 0;
                        break;
                    }
                    default: {
                        n = 3;
                    }
                }
            }
            return n2 - n;
        }
        return xOMInteger.toBigInteger().compareTo(xOMInteger2.toBigInteger());
    }

    public static XOMInteger add(XOMInteger xOMInteger, XOMInteger xOMInteger2) {
        if (xOMInteger.isNaN() || xOMInteger2.isNaN()) {
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite() && xOMInteger2.isInfinite()) {
            if (xOMInteger.getSign() == xOMInteger2.getSign()) {
                return xOMInteger;
            }
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite()) {
            return xOMInteger;
        }
        if (xOMInteger2.isInfinite()) {
            return xOMInteger2;
        }
        return new XOMInteger(xOMInteger.toBigInteger().add(xOMInteger2.toBigInteger()));
    }

    public static XOMInteger subtract(XOMInteger xOMInteger, XOMInteger xOMInteger2) {
        if (xOMInteger.isNaN() || xOMInteger2.isNaN()) {
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite() && xOMInteger2.isInfinite()) {
            if (xOMInteger.getSign() == xOMInteger2.getOppositeSign()) {
                return xOMInteger;
            }
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite()) {
            return xOMInteger;
        }
        if (xOMInteger2.isInfinite()) {
            return xOMInteger2.negate();
        }
        return new XOMInteger(xOMInteger.toBigInteger().subtract(xOMInteger2.toBigInteger()));
    }

    public static XOMInteger multiply(XOMInteger xOMInteger, XOMInteger xOMInteger2) {
        if (xOMInteger.isNaN() || xOMInteger2.isNaN()) {
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite() || xOMInteger2.isInfinite()) {
            if (xOMInteger.isZero() || xOMInteger2.isZero()) {
                return XOMInteger.NaN;
            }
            if (xOMInteger.getSign() == xOMInteger2.getSign()) {
                return XOMInteger.POSITIVE_INFINITY;
            }
            return XOMInteger.NEGATIVE_INFINITY;
        }
        return new XOMInteger(xOMInteger.toBigInteger().multiply(xOMInteger2.toBigInteger()));
    }

    public static XOMInteger divide(XOMInteger xOMInteger, XOMInteger xOMInteger2) {
        if (xOMInteger.isNaN() || xOMInteger2.isNaN()) {
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite() && xOMInteger2.isInfinite() || xOMInteger.isZero() && xOMInteger2.isZero()) {
            return XOMInteger.NaN;
        }
        if (xOMInteger2.isZero()) {
            switch (xOMInteger.getSign()) {
                case 1: {
                    return XOMInteger.POSITIVE_INFINITY;
                }
                case -1: {
                    return XOMInteger.NEGATIVE_INFINITY;
                }
            }
            return XOMInteger.NaN;
        }
        if (xOMInteger.isInfinite()) {
            if (xOMInteger2.isZero()) {
                return xOMInteger;
            }
            if (xOMInteger.getSign() == xOMInteger2.getSign()) {
                return XOMInteger.POSITIVE_INFINITY;
            }
            return XOMInteger.NEGATIVE_INFINITY;
        }
        if (xOMInteger2.isInfinite() || xOMInteger.isZero()) {
            return XOMInteger.ZERO;
        }
        return new XOMInteger(xOMInteger.toBigInteger().divide(xOMInteger2.toBigInteger()));
    }
}

