/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.math;

import com.kreative.openxion.math.MathProcessor;
import com.kreative.openxion.xom.inst.XOMNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Comparator;

public class XOMNumberMath {
    public static final Comparator<XOMNumber> comparator = new Comparator<XOMNumber>(){

        @Override
        public int compare(XOMNumber xOMNumber, XOMNumber xOMNumber2) {
            return XOMNumberMath.compare(xOMNumber, xOMNumber2);
        }
    };

    private XOMNumberMath() {
    }

    public static int compare(XOMNumber xOMNumber, XOMNumber xOMNumber2) {
        if (xOMNumber.isUndefined() || xOMNumber2.isUndefined()) {
            int n;
            int n2;
            if (xOMNumber.isNaN()) {
                n2 = 3;
            } else if (xOMNumber.isInfinite()) {
                switch (xOMNumber.getSign()) {
                    case -2147483648: {
                        n2 = 3;
                        break;
                    }
                    case -1: {
                        n2 = -2;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 0: {
                        n2 = 3;
                        break;
                    }
                    default: {
                        n2 = 3;
                        break;
                    }
                }
            } else if (xOMNumber.isUndefined()) {
                n2 = 3;
            } else if (xOMNumber.isZero()) {
                n2 = 0;
            } else {
                switch (xOMNumber.getSign()) {
                    case -2147483648: {
                        n2 = 3;
                        break;
                    }
                    case -1: {
                        n2 = -1;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = 3;
                    }
                }
            }
            if (xOMNumber2.isNaN()) {
                n = 3;
            } else if (xOMNumber2.isInfinite()) {
                switch (xOMNumber2.getSign()) {
                    case -2147483648: {
                        n = 3;
                        break;
                    }
                    case -1: {
                        n = -2;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 0: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 3;
                        break;
                    }
                }
            } else if (xOMNumber2.isUndefined()) {
                n = 3;
            } else if (xOMNumber2.isZero()) {
                n = 0;
            } else {
                switch (xOMNumber2.getSign()) {
                    case -2147483648: {
                        n = 3;
                        break;
                    }
                    case -1: {
                        n = -1;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 0: {
                        n = 0;
                        break;
                    }
                    default: {
                        n = 3;
                    }
                }
            }
            return n2 - n;
        }
        return xOMNumber.toBigDecimal().compareTo(xOMNumber2.toBigDecimal());
    }

    public static XOMNumber add(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite() && xOMNumber2.isInfinite()) {
            if (xOMNumber.getSign() == xOMNumber2.getSign()) {
                return xOMNumber;
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite()) {
            return xOMNumber;
        }
        if (xOMNumber2.isInfinite()) {
            return xOMNumber2;
        }
        return new XOMNumber(xOMNumber.toBigDecimal().add(xOMNumber2.toBigDecimal(), mathContext));
    }

    public static XOMNumber subtract(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite() && xOMNumber2.isInfinite()) {
            if (xOMNumber.getSign() == xOMNumber2.getOppositeSign()) {
                return xOMNumber;
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite()) {
            return xOMNumber;
        }
        if (xOMNumber2.isInfinite()) {
            return xOMNumber2.negate();
        }
        return new XOMNumber(xOMNumber.toBigDecimal().subtract(xOMNumber2.toBigDecimal(), mathContext));
    }

    public static XOMNumber multiply(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite() || xOMNumber2.isInfinite()) {
            if (xOMNumber.isZero() || xOMNumber2.isZero()) {
                return XOMNumber.NaN;
            }
            if (xOMNumber.getSign() == xOMNumber2.getSign()) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NEGATIVE_INFINITY;
        }
        return new XOMNumber(xOMNumber.toBigDecimal().multiply(xOMNumber2.toBigDecimal(), mathContext));
    }

    public static XOMNumber divide(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite() && xOMNumber2.isInfinite() || xOMNumber.isZero() && xOMNumber2.isZero()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber2.isZero()) {
            switch (xOMNumber.getSign()) {
                case 1: {
                    return XOMNumber.POSITIVE_INFINITY;
                }
                case -1: {
                    return XOMNumber.NEGATIVE_INFINITY;
                }
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite()) {
            if (xOMNumber2.isZero()) {
                return xOMNumber;
            }
            if (xOMNumber.getSign() == xOMNumber2.getSign()) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NEGATIVE_INFINITY;
        }
        if (xOMNumber2.isInfinite() || xOMNumber.isZero()) {
            return XOMNumber.ZERO;
        }
        return new XOMNumber(xOMNumber.toBigDecimal().divide(xOMNumber2.toBigDecimal(), mathContext));
    }

    public static XOMNumber pow(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isZero()) {
            switch (xOMNumber2.getSign()) {
                case -1: {
                    return XOMNumber.POSITIVE_INFINITY;
                }
                case 0: {
                    return XOMNumber.NaN;
                }
                case 1: {
                    return XOMNumber.ZERO;
                }
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite()) {
            if (xOMNumber.getSign() == 1) {
                switch (xOMNumber2.getSign()) {
                    case -1: {
                        return XOMNumber.ZERO;
                    }
                    case 0: {
                        return XOMNumber.NaN;
                    }
                    case 1: {
                        return XOMNumber.POSITIVE_INFINITY;
                    }
                }
                return XOMNumber.NaN;
            }
            if (xOMNumber2.isZero() || xOMNumber2.isInfinite()) {
                return XOMNumber.NaN;
            }
            try {
                BigInteger bigInteger = xOMNumber2.toBigDecimal().toBigIntegerExact();
                if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                    return XOMNumber.ZERO;
                }
                if (bigInteger.testBit(0)) {
                    return XOMNumber.NEGATIVE_INFINITY;
                }
                return XOMNumber.POSITIVE_INFINITY;
            }
            catch (Exception exception) {
                return XOMNumber.NaN;
            }
        }
        if (xOMNumber2.isZero()) {
            return XOMNumber.ONE;
        }
        if (xOMNumber2.isInfinite()) {
            BigDecimal bigDecimal = xOMNumber.toBigDecimal();
            if (xOMNumber2.getSign() == 1) {
                if (bigDecimal.compareTo(BigDecimal.ONE.negate()) <= 0) {
                    return XOMNumber.NaN;
                }
                if (bigDecimal.compareTo(BigDecimal.ONE) < 0) {
                    return XOMNumber.ZERO;
                }
                if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
                    return XOMNumber.NaN;
                }
                return XOMNumber.POSITIVE_INFINITY;
            }
            if (bigDecimal.compareTo(BigDecimal.ONE.negate()) <= 0) {
                return XOMNumber.NaN;
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) < 0) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
                return XOMNumber.NaN;
            }
            return XOMNumber.ZERO;
        }
        return new XOMNumber(mathProcessor.pow(xOMNumber.toBigDecimal(), xOMNumber2.toBigDecimal(), mathContext));
    }

    public static XOMNumber toDeg(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return xOMNumber;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(180L), mathContext).divide(mathProcessor.pi(mathContext), mathContext);
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber toRad(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return xOMNumber;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        bigDecimal = bigDecimal.multiply(mathProcessor.pi(mathContext), mathContext).divide(BigDecimal.valueOf(180L), mathContext);
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber annuity(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isZero() || xOMNumber2.isZero()) {
            return xOMNumber2;
        }
        return XOMNumberMath.divide(XOMNumberMath.subtract(XOMNumber.ONE, XOMNumberMath.pow(XOMNumberMath.add(XOMNumber.ONE, xOMNumber, mathContext, mathProcessor), xOMNumber2.negate(), mathContext, mathProcessor), mathContext, mathProcessor), xOMNumber, mathContext, mathProcessor);
    }

    public static XOMNumber compound(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isZero() || xOMNumber2.isZero()) {
            return XOMNumber.ONE;
        }
        return XOMNumberMath.pow(XOMNumberMath.add(XOMNumber.ONE, xOMNumber, mathContext, mathProcessor), xOMNumber2, mathContext, mathProcessor);
    }

    public static XOMNumber sqrt(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.sqrt(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber cbrt(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.NEGATIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.cbrt(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber agm(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        XOMNumber xOMNumber3 = new XOMNumber(2);
        while (!xOMNumber.isNaN() && !xOMNumber2.isNaN()) {
            XOMNumber xOMNumber4;
            XOMNumber xOMNumber5 = XOMNumberMath.divide(XOMNumberMath.add(xOMNumber, xOMNumber2, mathContext, mathProcessor), xOMNumber3, mathContext, mathProcessor);
            if (xOMNumber5.equals(xOMNumber4 = XOMNumberMath.sqrt(XOMNumberMath.multiply(xOMNumber, xOMNumber2, mathContext, mathProcessor), mathContext, mathProcessor))) {
                return xOMNumber5;
            }
            xOMNumber = xOMNumber5;
            xOMNumber2 = xOMNumber4;
        }
        return XOMNumber.NaN;
    }

    public static XOMNumber exp(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.ZERO;
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.exp(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber expm1(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.ONE.negate();
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.expm1(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber exp2(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.ZERO;
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.pow(BigDecimal.valueOf(2L), xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber exp10(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.ZERO;
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.pow(BigDecimal.valueOf(10L), xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber log(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        int n = bigDecimal.compareTo(BigDecimal.ZERO);
        if (n < 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return XOMNumber.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal2 = mathProcessor.log(bigDecimal, mathContext);
        if (bigDecimal2 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal2);
    }

    public static XOMNumber log1p(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        int n = bigDecimal.compareTo(BigDecimal.ONE.negate());
        if (n < 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return XOMNumber.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal2 = mathProcessor.log1p(bigDecimal, mathContext);
        if (bigDecimal2 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal2);
    }

    public static XOMNumber log2(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        int n = bigDecimal.compareTo(BigDecimal.ZERO);
        if (n < 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return XOMNumber.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal2 = mathProcessor.log2(bigDecimal, mathContext);
        if (bigDecimal2 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal2);
    }

    public static XOMNumber log10(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        int n = bigDecimal.compareTo(BigDecimal.ZERO);
        if (n < 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return XOMNumber.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal2 = mathProcessor.log10(bigDecimal, mathContext);
        if (bigDecimal2 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal2);
    }

    public static XOMNumber sin(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.sin(xOMNumber.toBigDecimal(), mathContext));
    }

    public static XOMNumber cos(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.cos(xOMNumber.toBigDecimal(), mathContext));
    }

    public static XOMNumber tan(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal2 = mathProcessor.sin(bigDecimal, mathContext);
        BigDecimal bigDecimal3 = mathProcessor.cos(bigDecimal, mathContext);
        int n = bigDecimal2.compareTo(BigDecimal.ZERO);
        int n2 = bigDecimal3.compareTo(BigDecimal.ZERO);
        if (n == 0) {
            return XOMNumber.ZERO;
        }
        if (n2 == 0) {
            return n < 0 ? XOMNumber.NEGATIVE_INFINITY : XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(bigDecimal2.divide(bigDecimal3, mathContext));
    }

    public static XOMNumber cot(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal2 = mathProcessor.cos(bigDecimal, mathContext);
        BigDecimal bigDecimal3 = mathProcessor.sin(bigDecimal, mathContext);
        int n = bigDecimal2.compareTo(BigDecimal.ZERO);
        int n2 = bigDecimal3.compareTo(BigDecimal.ZERO);
        if (n == 0) {
            return XOMNumber.ZERO;
        }
        if (n2 == 0) {
            return n < 0 ? XOMNumber.NEGATIVE_INFINITY : XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(bigDecimal2.divide(bigDecimal3, mathContext));
    }

    public static XOMNumber csc(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.sin(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(BigDecimal.ONE.divide(bigDecimal, mathContext));
    }

    public static XOMNumber sec(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.cos(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(BigDecimal.ONE.divide(bigDecimal, mathContext));
    }

    public static XOMNumber sinh(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.NEGATIVE_INFINITY;
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.sinh(xOMNumber.toBigDecimal(), mathContext));
    }

    public static XOMNumber cosh(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.cosh(xOMNumber.toBigDecimal(), mathContext));
    }

    public static XOMNumber tanh(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.ONE.negate();
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.ONE;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.tanh(xOMNumber.toBigDecimal(), mathContext));
    }

    public static XOMNumber coth(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return XOMNumber.ONE.negate();
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.ONE;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.tanh(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(BigDecimal.ONE.divide(bigDecimal, mathContext));
    }

    public static XOMNumber csch(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return XOMNumber.ZERO;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.sinh(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(BigDecimal.ONE.divide(bigDecimal, mathContext));
    }

    public static XOMNumber sech(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return XOMNumber.ZERO;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = mathProcessor.cosh(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        return new XOMNumber(BigDecimal.ONE.divide(bigDecimal, mathContext));
    }

    public static XOMNumber asin(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        if (bigDecimal.abs().compareTo(BigDecimal.ONE) > 0) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.asin(bigDecimal, mathContext));
    }

    public static XOMNumber acos(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        if (bigDecimal.abs().compareTo(BigDecimal.ONE) > 0) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.acos(bigDecimal, mathContext));
    }

    public static XOMNumber atan(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return new XOMNumber(mathProcessor.pi(mathContext).divide(BigDecimal.valueOf(2.0)).negate());
            }
            if (xOMNumber.getSign() == 1) {
                return new XOMNumber(mathProcessor.pi(mathContext).divide(BigDecimal.valueOf(2.0)));
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.atan(xOMNumber.toBigDecimal(), mathContext));
    }

    public static XOMNumber atan2(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isInfinite() || xOMNumber2.isInfinite()) {
            if (xOMNumber.isZero() && xOMNumber2.isInfinite()) {
                switch (xOMNumber2.getSign()) {
                    case 1: {
                        return XOMNumber.ZERO;
                    }
                    case -1: {
                        return new XOMNumber(mathProcessor.pi(mathContext));
                    }
                }
                return XOMNumber.NaN;
            }
            if (xOMNumber.isInfinite() && xOMNumber2.isZero()) {
                switch (xOMNumber.getSign()) {
                    case 1: {
                        return new XOMNumber(mathProcessor.pi(mathContext).divide(BigDecimal.valueOf(2L), mathContext));
                    }
                    case -1: {
                        return new XOMNumber(mathProcessor.pi(mathContext).divide(BigDecimal.valueOf(2L), mathContext).negate());
                    }
                }
                return XOMNumber.NaN;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.atan2(xOMNumber.toBigDecimal(), xOMNumber2.toBigDecimal(), mathContext));
    }

    public static XOMNumber acot(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == -1) {
                return new XOMNumber(mathProcessor.pi(mathContext));
            }
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.ZERO;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.pi(mathContext).divide(BigDecimal.valueOf(2L), mathContext).subtract(mathProcessor.atan(xOMNumber.toBigDecimal(), mathContext), mathContext));
    }

    public static XOMNumber acsc(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return XOMNumber.ZERO;
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        if (bigDecimal.abs().compareTo(BigDecimal.ONE) < 0) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.asin(BigDecimal.ONE.divide(bigDecimal, mathContext), mathContext));
    }

    public static XOMNumber asec(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return new XOMNumber(mathProcessor.pi(mathContext).divide(BigDecimal.valueOf(2L), mathContext));
            }
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        if (bigDecimal.abs().compareTo(BigDecimal.ONE) < 0) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(mathProcessor.acos(BigDecimal.ONE.divide(bigDecimal, mathContext), mathContext));
    }

    public static XOMNumber asinh(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        BigDecimal bigDecimal;
        if (xOMNumber.isUndefined()) {
            return xOMNumber;
        }
        BigDecimal bigDecimal2 = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal3 = mathProcessor.log(bigDecimal2.add(bigDecimal = mathProcessor.sqrt(bigDecimal2.multiply(bigDecimal2, mathContext).add(BigDecimal.ONE, mathContext), mathContext), mathContext), mathContext);
        if (bigDecimal3 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal3);
    }

    public static XOMNumber acosh(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return xOMNumber;
            }
            return XOMNumber.NaN;
        }
        int n = xOMNumber.toBigDecimal().compareTo(BigDecimal.ONE);
        if (n < 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return XOMNumber.ZERO;
        }
        BigDecimal bigDecimal4 = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal5 = mathProcessor.log(bigDecimal4.add(bigDecimal3 = (bigDecimal2 = mathProcessor.sqrt(bigDecimal4.subtract(BigDecimal.ONE, mathContext), mathContext)).multiply(bigDecimal = mathProcessor.sqrt(bigDecimal4.add(BigDecimal.ONE, mathContext), mathContext), mathContext), mathContext), mathContext);
        if (bigDecimal5 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal5);
    }

    public static XOMNumber atanh(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        int n = xOMNumber.toBigDecimal().abs().compareTo(BigDecimal.ONE);
        if (n > 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return xOMNumber.toBigDecimal().signum() < 0 ? XOMNumber.NEGATIVE_INFINITY : XOMNumber.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal2 = BigDecimal.ONE.subtract(bigDecimal, mathContext);
        BigDecimal bigDecimal3 = mathProcessor.sqrt(BigDecimal.ONE.subtract(bigDecimal.multiply(bigDecimal, mathContext), mathContext), mathContext);
        BigDecimal bigDecimal4 = mathProcessor.log(bigDecimal3.divide(bigDecimal2, mathContext), mathContext);
        if (bigDecimal4 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal4);
    }

    public static XOMNumber acoth(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return XOMNumber.ZERO;
            }
            return XOMNumber.NaN;
        }
        int n = xOMNumber.toBigDecimal().abs().compareTo(BigDecimal.ONE);
        if (n < 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return xOMNumber.toBigDecimal().signum() < 0 ? XOMNumber.NEGATIVE_INFINITY : XOMNumber.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal2 = bigDecimal.add(BigDecimal.ONE, mathContext).divide(bigDecimal.subtract(BigDecimal.ONE, mathContext), mathContext);
        BigDecimal bigDecimal3 = mathProcessor.log(bigDecimal2, mathContext).divide(BigDecimal.valueOf(2L));
        if (bigDecimal3 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal3);
    }

    public static XOMNumber acsch(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.isInfinite()) {
                return XOMNumber.ZERO;
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isZero()) {
            return XOMNumber.NaN;
        }
        BigDecimal bigDecimal = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal2 = BigDecimal.ONE.divide(bigDecimal, mathContext);
        BigDecimal bigDecimal3 = BigDecimal.ONE.divide(bigDecimal.multiply(bigDecimal, mathContext), mathContext);
        BigDecimal bigDecimal4 = mathProcessor.sqrt(BigDecimal.ONE.add(bigDecimal3, mathContext), mathContext);
        BigDecimal bigDecimal5 = mathProcessor.log(bigDecimal4.add(bigDecimal2, mathContext), mathContext);
        if (bigDecimal5 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal5);
    }

    public static XOMNumber asech(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        BigDecimal bigDecimal;
        if (xOMNumber.isUndefined()) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.getSign() == -1) {
            return XOMNumber.NaN;
        }
        if (xOMNumber.isZero()) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        int n = xOMNumber.toBigDecimal().abs().compareTo(BigDecimal.ONE);
        if (n > 0) {
            return XOMNumber.NaN;
        }
        if (n == 0) {
            return XOMNumber.ZERO;
        }
        BigDecimal bigDecimal2 = xOMNumber.toBigDecimal();
        BigDecimal bigDecimal3 = BigDecimal.ONE.divide(bigDecimal2, mathContext);
        BigDecimal bigDecimal4 = mathProcessor.sqrt(bigDecimal3.subtract(BigDecimal.ONE, mathContext), mathContext);
        BigDecimal bigDecimal5 = bigDecimal4.multiply(bigDecimal = mathProcessor.sqrt(bigDecimal3.add(BigDecimal.ONE, mathContext), mathContext), mathContext);
        BigDecimal bigDecimal6 = mathProcessor.log(bigDecimal5.add(bigDecimal3, mathContext), mathContext);
        if (bigDecimal6 == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal6);
    }

    public static XOMNumber gamma(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isZero()) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.gamma(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber loggamma(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        if (xOMNumber.isUndefined()) {
            if (xOMNumber.getSign() == 1) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        if (xOMNumber.isZero()) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = mathProcessor.loggamma(xOMNumber.toBigDecimal(), mathContext);
        if (bigDecimal == null) {
            return XOMNumber.NaN;
        }
        return new XOMNumber(bigDecimal);
    }

    public static XOMNumber fact(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMNumberMath.gamma(XOMNumberMath.add(xOMNumber, XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMNumber logfact(XOMNumber xOMNumber, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMNumberMath.loggamma(XOMNumberMath.add(xOMNumber, XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMNumber beta(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMNumberMath.divide(XOMNumberMath.multiply(XOMNumberMath.gamma(xOMNumber, mathContext, mathProcessor), XOMNumberMath.gamma(xOMNumber2, mathContext, mathProcessor), mathContext, mathProcessor), XOMNumberMath.gamma(XOMNumberMath.add(xOMNumber, xOMNumber2, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMNumber logbeta(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMNumberMath.subtract(XOMNumberMath.add(XOMNumberMath.loggamma(xOMNumber, mathContext, mathProcessor), XOMNumberMath.loggamma(xOMNumber2, mathContext, mathProcessor), mathContext, mathProcessor), XOMNumberMath.loggamma(XOMNumberMath.add(xOMNumber, xOMNumber2, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMNumber nPr(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMNumberMath.divide(XOMNumberMath.gamma(XOMNumberMath.add(xOMNumber, XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor), XOMNumberMath.gamma(XOMNumberMath.add(XOMNumberMath.subtract(xOMNumber, xOMNumber2, mathContext, mathProcessor), XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }

    public static XOMNumber nCr(XOMNumber xOMNumber, XOMNumber xOMNumber2, MathContext mathContext, MathProcessor mathProcessor) {
        return XOMNumberMath.divide(XOMNumberMath.divide(XOMNumberMath.gamma(XOMNumberMath.add(xOMNumber, XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor), XOMNumberMath.gamma(XOMNumberMath.add(xOMNumber2, XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor), XOMNumberMath.gamma(XOMNumberMath.add(XOMNumberMath.subtract(xOMNumber, xOMNumber2, mathContext, mathProcessor), XOMNumber.ONE, mathContext, mathProcessor), mathContext, mathProcessor), mathContext, mathProcessor);
    }
}

