/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EndlessInputStream
extends FilterInputStream {
    private boolean eof = false;

    public EndlessInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        if (this.eof) {
            return 0;
        }
        int n = this.in.read();
        if (n < 0) {
            this.eof = true;
            return 0;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.eof) {
            return byArray.length;
        }
        int n = this.in.read(byArray);
        if (n < 0) {
            this.eof = true;
            return 0;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return n2;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 < 0) {
            this.eof = true;
            return 0;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.eof) {
            return l;
        }
        long l2 = this.in.skip(l);
        if (l2 < 0L) {
            this.eof = true;
            return 0L;
        }
        return l2;
    }
}

