/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

import com.kreative.openxion.util.StringChunkType;
import java.text.StringCharacterIterator;

public class StringChunkEx {
    private StringChunkEx() {
    }

    public static int count(String string, StringChunkType stringChunkType, char c, char c2, char c3) {
        switch (stringChunkType) {
            case CHARACTER: {
                return string.length();
            }
            case LINE: {
                return StringChunkEx.countl(string);
            }
            case ITEM: {
                return StringChunkEx.countd(string, c);
            }
            case COLUMN: {
                return StringChunkEx.countd(string, c2);
            }
            case ROW: {
                return StringChunkEx.countd(string, c3);
            }
            case WORD: {
                return StringChunkEx.countw(string);
            }
            case SENTENCE: {
                return StringChunkEx.counts(string);
            }
            case PARAGRAPH: {
                return StringChunkEx.countp(string);
            }
        }
        return 0;
    }

    public static int start(String string, StringChunkType stringChunkType, int n, char c, char c2, char c3) {
        switch (stringChunkType) {
            case CHARACTER: {
                return Math.max(0, Math.min(string.length(), n - 1));
            }
            case LINE: {
                return StringChunkEx.startl(string, n);
            }
            case ITEM: {
                return StringChunkEx.startd(string, n, c);
            }
            case COLUMN: {
                return StringChunkEx.startd(string, n, c2);
            }
            case ROW: {
                return StringChunkEx.startd(string, n, c3);
            }
            case WORD: {
                return StringChunkEx.startw(string, n);
            }
            case SENTENCE: {
                return StringChunkEx.starts(string, n);
            }
            case PARAGRAPH: {
                return StringChunkEx.startp(string, n);
            }
        }
        return 0;
    }

    public static int end(String string, StringChunkType stringChunkType, int n, char c, char c2, char c3) {
        switch (stringChunkType) {
            case CHARACTER: {
                return Math.max(0, Math.min(string.length(), n));
            }
            case LINE: {
                return StringChunkEx.endl(string, n);
            }
            case ITEM: {
                return StringChunkEx.endd(string, n, c);
            }
            case COLUMN: {
                return StringChunkEx.endd(string, n, c2);
            }
            case ROW: {
                return StringChunkEx.endd(string, n, c3);
            }
            case WORD: {
                return StringChunkEx.endw(string, n);
            }
            case SENTENCE: {
                return StringChunkEx.ends(string, n);
            }
            case PARAGRAPH: {
                return StringChunkEx.endp(string, n);
            }
        }
        return 0;
    }

    private static int countd(String string, char c) {
        if (string.length() <= 0) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (c2 == c) {
                ++n;
                bl = true;
            } else {
                bl = false;
            }
            c2 = stringCharacterIterator.next();
        }
        if (bl) {
            --n;
        }
        return n + 1;
    }

    private static int startd(String string, int n, char c) {
        if (n < 1) {
            return 0;
        }
        int n2 = 1;
        int n3 = 0;
        do {
            if (n2 >= n) {
                return n3;
            }
            ++n2;
        } while ((n3 = string.indexOf(c, n3) + 1) >= 1);
        return string.length();
    }

    private static int endd(String string, int n, char c) {
        if (n < 1) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            ++n2;
            if ((n3 = string.indexOf(c, n3)) < 0) {
                return string.length();
            }
            if (n2 >= n) {
                return n3;
            }
            ++n3;
        }
    }

    private static int countl(String string) {
        if (string.length() <= 0) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\u2028' || c == '\u2029') {
                ++n;
                bl = false;
                bl2 = true;
            } else if (c == '\r') {
                ++n;
                bl = true;
                bl2 = true;
            } else if (c == '\n') {
                if (!bl) {
                    ++n;
                }
                bl = false;
                bl2 = true;
            } else {
                bl = false;
                bl2 = false;
            }
            c = stringCharacterIterator.next();
        }
        if (bl2) {
            --n;
        }
        return n + 1;
    }

    private static int startl(String string, int n) {
        if (n < 1) {
            return 0;
        }
        int n2 = 1;
        int n3 = 0;
        while (true) {
            if (n2 >= n) {
                return n3;
            }
            ++n2;
            int n4 = string.indexOf(10, n3);
            int n5 = string.indexOf(13, n3);
            int n6 = string.indexOf(8232, n3);
            int n7 = string.indexOf(8233, n3);
            if (!(n5 < 0 || n4 != n5 + 1 || n6 >= 0 && n6 <= n5 || n7 >= 0 && n7 <= n5)) {
                n3 = n5 + 2;
                continue;
            }
            if (!(n4 < 0 || n5 >= 0 && n5 <= n4 || n6 >= 0 && n6 <= n4 || n7 >= 0 && n7 <= n4)) {
                n3 = n4 + 1;
                continue;
            }
            if (!(n5 < 0 || n4 >= 0 && n4 <= n5 || n6 >= 0 && n6 <= n5 || n7 >= 0 && n7 <= n5)) {
                n3 = n5 + 1;
                continue;
            }
            if (!(n6 < 0 || n4 >= 0 && n4 <= n6 || n5 >= 0 && n5 <= n6 || n7 >= 0 && n7 <= n6)) {
                n3 = n6 + 1;
                continue;
            }
            if (n7 < 0 || n4 >= 0 && n4 <= n7 || n5 >= 0 && n5 <= n7 || n6 >= 0 && n6 <= n7) break;
            n3 = n7 + 1;
        }
        return string.length();
    }

    private static int endl(String string, int n) {
        if (n < 1) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            ++n2;
            int n4 = string.indexOf(10, n3);
            int n5 = string.indexOf(13, n3);
            int n6 = string.indexOf(8232, n3);
            int n7 = string.indexOf(8233, n3);
            if (!(n5 < 0 || n4 != n5 + 1 || n6 >= 0 && n6 <= n5 || n7 >= 0 && n7 <= n5)) {
                if (n2 >= n) {
                    return n5;
                }
                n3 = n5 + 2;
                continue;
            }
            if (!(n4 < 0 || n5 >= 0 && n5 <= n4 || n6 >= 0 && n6 <= n4 || n7 >= 0 && n7 <= n4)) {
                if (n2 >= n) {
                    return n4;
                }
                n3 = n4 + 1;
                continue;
            }
            if (!(n5 < 0 || n4 >= 0 && n4 <= n5 || n6 >= 0 && n6 <= n5 || n7 >= 0 && n7 <= n5)) {
                if (n2 >= n) {
                    return n5;
                }
                n3 = n5 + 1;
                continue;
            }
            if (!(n6 < 0 || n4 >= 0 && n4 <= n6 || n5 >= 0 && n5 <= n6 || n7 >= 0 && n7 <= n6)) {
                if (n2 >= n) {
                    return n6;
                }
                n3 = n6 + 1;
                continue;
            }
            if (n7 < 0 || n4 >= 0 && n4 <= n7 || n5 >= 0 && n5 <= n7 || n6 >= 0 && n6 <= n7) break;
            if (n2 >= n) {
                return n7;
            }
            n3 = n7 + 1;
        }
        return string.length();
    }

    private static boolean isBreak(char c) {
        return c < '\u0000' || c == '\n' || c == '\r' || c == '\u2028' || c == '\u2029';
    }

    private static int countp(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && StringChunkEx.isBreak(string.charAt(n)); ++n) {
        }
        while (n < string.length()) {
            ++n2;
            while (n < string.length() && !StringChunkEx.isBreak(string.charAt(n))) {
                ++n;
            }
            while (n < string.length() && StringChunkEx.isBreak(string.charAt(n))) {
                ++n;
            }
        }
        return n2;
    }

    private static int startp(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && StringChunkEx.isBreak(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length()) {
            if (++n3 == n) {
                return n2;
            }
            while (n2 < string.length() && !StringChunkEx.isBreak(string.charAt(n2))) {
                ++n2;
            }
            while (n2 < string.length() && StringChunkEx.isBreak(string.charAt(n2))) {
                ++n2;
            }
        }
        return n <= 0 ? 0 : string.length();
    }

    private static int endp(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && StringChunkEx.isBreak(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length()) {
            ++n3;
            while (n2 < string.length() && !StringChunkEx.isBreak(string.charAt(n2))) {
                ++n2;
            }
            if (n3 == n) {
                return n2;
            }
            while (n2 < string.length() && StringChunkEx.isBreak(string.charAt(n2))) {
                ++n2;
            }
        }
        return n <= 0 ? 0 : string.length();
    }

    private static boolean isWhite(char c) {
        return c <= ' ' || c >= '\u007f' && c <= '\u00a0' || Character.isSpaceChar(c);
    }

    private static boolean isSenEnd(char c) {
        return c == '.' || c == '!' || c == '?';
    }

    private static int counts(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && StringChunkEx.isWhite(string.charAt(n)); ++n) {
        }
        while (n < string.length()) {
            ++n2;
            while (n < string.length() && !StringChunkEx.isSenEnd(string.charAt(n))) {
                ++n;
            }
            while (n < string.length() && !StringChunkEx.isWhite(string.charAt(n))) {
                ++n;
            }
            while (n < string.length() && StringChunkEx.isWhite(string.charAt(n))) {
                ++n;
            }
        }
        return n2;
    }

    private static int starts(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length()) {
            if (++n3 == n) {
                return n2;
            }
            while (n2 < string.length() && !StringChunkEx.isSenEnd(string.charAt(n2))) {
                ++n2;
            }
            while (n2 < string.length() && !StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
            while (n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
        }
        return n <= 0 ? 0 : string.length();
    }

    private static int ends(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length()) {
            ++n3;
            while (n2 < string.length() && !StringChunkEx.isSenEnd(string.charAt(n2))) {
                ++n2;
            }
            while (n2 < string.length() && !StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
            if (n3 == n) {
                return n2;
            }
            while (n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
        }
        return n <= 0 ? 0 : string.length();
    }

    private static int countw(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && StringChunkEx.isWhite(string.charAt(n)); ++n) {
        }
        while (n < string.length()) {
            ++n2;
            while (n < string.length() && !StringChunkEx.isWhite(string.charAt(n))) {
                ++n;
            }
            while (n < string.length() && StringChunkEx.isWhite(string.charAt(n))) {
                ++n;
            }
        }
        return n2;
    }

    private static int startw(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length()) {
            if (++n3 == n) {
                return n2;
            }
            while (n2 < string.length() && !StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
            while (n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
        }
        return n <= 0 ? 0 : string.length();
    }

    private static int endw(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2)); ++n2) {
        }
        while (n2 < string.length()) {
            ++n3;
            while (n2 < string.length() && !StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
            if (n3 == n) {
                return n2;
            }
            while (n2 < string.length() && StringChunkEx.isWhite(string.charAt(n2))) {
                ++n2;
            }
        }
        return n <= 0 ? 0 : string.length();
    }
}

