/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

import com.kreative.openxion.util.DateItemsDateFormat;
import com.kreative.openxion.util.SecondsDateFormat;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XNDateFormat {
    SECONDS,
    DATEITEMS,
    SHORT_TIME,
    ABBREV_TIME,
    LONG_TIME,
    ENGLISH_TIME,
    SHORT_DATE,
    ABBREV_DATE,
    LONG_DATE,
    ENGLISH_DATE;


    public static XNDateFormat forName(String string) {
        if ((string = string.toLowerCase().trim().replace(" ", "")).equals("englishdate")) {
            return ENGLISH_DATE;
        }
        if (string.equals("longdate")) {
            return LONG_DATE;
        }
        if (string.equals("mediumdate")) {
            return ABBREV_DATE;
        }
        if (string.equals("meddate")) {
            return ABBREV_DATE;
        }
        if (string.equals("abbreviateddate")) {
            return ABBREV_DATE;
        }
        if (string.equals("abbrevdate")) {
            return ABBREV_DATE;
        }
        if (string.equals("abbrdate")) {
            return ABBREV_DATE;
        }
        if (string.equals("shortdate")) {
            return SHORT_DATE;
        }
        if (string.equals("englishtime")) {
            return ENGLISH_TIME;
        }
        if (string.equals("longtime")) {
            return LONG_TIME;
        }
        if (string.equals("mediumtime")) {
            return ABBREV_TIME;
        }
        if (string.equals("medtime")) {
            return ABBREV_TIME;
        }
        if (string.equals("abbreviatedtime")) {
            return ABBREV_TIME;
        }
        if (string.equals("abbrevtime")) {
            return ABBREV_TIME;
        }
        if (string.equals("abbrtime")) {
            return ABBREV_TIME;
        }
        if (string.equals("shorttime")) {
            return SHORT_TIME;
        }
        if (string.equals("dateitems")) {
            return DATEITEMS;
        }
        if (string.equals("seconds")) {
            return SECONDS;
        }
        return null;
    }

    public static List<XNDateFormat> allForName(String string) {
        Vector<XNDateFormat> vector = new Vector<XNDateFormat>();
        if ((string = string.toLowerCase().trim().replace(" ", "")).equals("englishdate") || string.equals("date") || string.equals("datetime") || string.equals("any")) {
            vector.add(ENGLISH_DATE);
        }
        if (string.equals("longdate") || string.equals("date") || string.equals("datetime") || string.equals("any")) {
            vector.add(LONG_DATE);
        }
        if (string.equals("mediumdate") || string.equals("meddate") || string.equals("abbreviateddate") || string.equals("abbrevdate") || string.equals("abbrdate") || string.equals("date") || string.equals("datetime") || string.equals("any")) {
            vector.add(ABBREV_DATE);
        }
        if (string.equals("shortdate") || string.equals("date") || string.equals("datetime") || string.equals("any")) {
            vector.add(SHORT_DATE);
        }
        if (string.equals("englishtime") || string.equals("time") || string.equals("datetime") || string.equals("any")) {
            vector.add(ENGLISH_TIME);
        }
        if (string.equals("longtime") || string.equals("time") || string.equals("datetime") || string.equals("any")) {
            vector.add(LONG_TIME);
        }
        if (string.equals("mediumtime") || string.equals("medtime") || string.equals("abbreviatedtime") || string.equals("abbrevtime") || string.equals("abbrtime") || string.equals("time") || string.equals("datetime") || string.equals("any")) {
            vector.add(ABBREV_TIME);
        }
        if (string.equals("shorttime") || string.equals("time") || string.equals("datetime") || string.equals("any")) {
            vector.add(SHORT_TIME);
        }
        if (string.equals("dateitems") || string.equals("any")) {
            vector.add(DATEITEMS);
        }
        if (string.equals("seconds") || string.equals("any")) {
            vector.add(SECONDS);
        }
        return vector;
    }

    public DateFormat toJavaDateFormat() {
        switch (this) {
            case SECONDS: {
                return SecondsDateFormat.instance;
            }
            case DATEITEMS: {
                return DateItemsDateFormat.instance;
            }
            case SHORT_TIME: {
                return DateFormat.getTimeInstance(3);
            }
            case ABBREV_TIME: {
                return DateFormat.getTimeInstance(2);
            }
            case LONG_TIME: {
                return DateFormat.getTimeInstance(1);
            }
            case ENGLISH_TIME: {
                return DateFormat.getTimeInstance(1, Locale.US);
            }
            case SHORT_DATE: {
                return DateFormat.getDateInstance(3);
            }
            case ABBREV_DATE: {
                return DateFormat.getDateInstance(2);
            }
            case LONG_DATE: {
                return DateFormat.getDateInstance(1);
            }
            case ENGLISH_DATE: {
                return DateFormat.getDateInstance(1, Locale.US);
            }
        }
        return SecondsDateFormat.instance;
    }

    public XNDateFormat dateEquivalent() {
        switch (this) {
            case SHORT_TIME: 
            case SHORT_DATE: {
                return SHORT_DATE;
            }
            case ABBREV_TIME: 
            case ABBREV_DATE: {
                return ABBREV_DATE;
            }
            case LONG_TIME: 
            case LONG_DATE: {
                return LONG_DATE;
            }
            case ENGLISH_TIME: 
            case ENGLISH_DATE: {
                return ENGLISH_DATE;
            }
        }
        return LONG_DATE;
    }

    public XNDateFormat timeEquivalent() {
        switch (this) {
            case SHORT_TIME: 
            case SHORT_DATE: {
                return SHORT_TIME;
            }
            case ABBREV_TIME: 
            case ABBREV_DATE: {
                return ABBREV_TIME;
            }
            case LONG_TIME: 
            case LONG_DATE: {
                return LONG_TIME;
            }
            case ENGLISH_TIME: 
            case ENGLISH_DATE: {
                return ENGLISH_TIME;
            }
        }
        return LONG_TIME;
    }
}

