/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.util.BinaryNumericChunkType;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMBinaryContainer;
import com.kreative.openxion.xom.XOMContainer;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.type.XOMBinaryType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMNumberType;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMBinaryNumericChunk
extends XOMContainer {
    private static final long serialVersionUID = 1L;
    private XOMVariant parent;
    private BinaryNumericChunkType chunkType;
    private int index;

    public XOMBinaryNumericChunk(XOMVariant xOMVariant, BinaryNumericChunkType binaryNumericChunkType, int n) {
        this.parent = xOMVariant;
        this.chunkType = binaryNumericChunkType;
        this.index = n;
    }

    @Override
    public boolean canGetParent(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getParent(XNContext xNContext) {
        return this.parent;
    }

    private BinaryChunkInfo getChunkInfo(XNContext xNContext, boolean bl, boolean bl2, boolean bl3) {
        byte[] byArray;
        int n;
        byte[] byArray2;
        if (bl || bl2) {
            this.parent = this.parent.asContainer(xNContext, false);
            byArray2 = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, this.parent.getContents(xNContext))).toByteArray();
        } else {
            byArray2 = this.parent.canGetContents(xNContext) ? ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, this.parent.getContents(xNContext))).toByteArray() : ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, this.parent)).toByteArray();
        }
        int[] nArray = XIONUtil.index(0, byArray2.length - this.chunkType.length(), this.index, this.index);
        int n2 = nArray[0];
        int n3 = nArray[0] + this.chunkType.length() - 1;
        if (bl && n2 > byArray2.length - 1 || bl2 && n3 > byArray2.length - 1) {
            n = (bl && bl2 ? Math.max(n2, n3) : (bl ? n2 - 1 : (bl2 ? n3 : byArray2.length - 1))) - (byArray2.length - 1);
            byArray = new byte[n];
            byArray2 = XIONUtil.binaryConcat(byArray2, byArray);
            this.parent.putAfterContents(xNContext, new XOMBinary(byArray));
        }
        if (bl3 && (n2 > byArray2.length - 1 || n3 > byArray2.length - 1)) {
            n = Math.max(n2, n3) - (byArray2.length - 1);
            byArray = new byte[n];
            byArray2 = XIONUtil.binaryConcat(byArray2, byArray);
        }
        if (bl && n2 < 0 || bl2 && n3 < 0) {
            n = Math.abs(bl && bl2 ? Math.min(n2, n3) : (bl ? n2 : (bl2 ? n3 + 1 : 0)));
            byArray = new byte[n];
            n2 += n;
            n3 += n;
            byArray2 = XIONUtil.binaryConcat(byArray, byArray2);
            this.parent.putBeforeContents(xNContext, new XOMBinary(byArray));
        }
        if (bl3 && (n2 < 0 || n3 < 0)) {
            n = Math.abs(Math.min(n2, n3));
            byArray = new byte[n];
            n2 += n;
            n3 += n;
            byArray2 = XIONUtil.binaryConcat(byArray, byArray2);
        }
        BinaryChunkInfo binaryChunkInfo = new BinaryChunkInfo();
        binaryChunkInfo.parentContent = byArray2;
        binaryChunkInfo.byteCount = byArray2.length;
        binaryChunkInfo.startByteIndex = n2;
        binaryChunkInfo.endByteIndex = n3 + 1;
        if (binaryChunkInfo.startByteIndex < 0) {
            binaryChunkInfo.startByteIndex = 0;
        } else if (binaryChunkInfo.startByteIndex > byArray2.length) {
            binaryChunkInfo.startByteIndex = byArray2.length;
        }
        if (binaryChunkInfo.endByteIndex < 0) {
            binaryChunkInfo.endByteIndex = 0;
        } else if (binaryChunkInfo.endByteIndex > byArray2.length) {
            binaryChunkInfo.endByteIndex = byArray2.length;
        }
        if (binaryChunkInfo.startByteIndex > binaryChunkInfo.endByteIndex) {
            binaryChunkInfo.endByteIndex = binaryChunkInfo.startByteIndex;
        }
        return binaryChunkInfo;
    }

    @Override
    public boolean canDelete(XNContext xNContext) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canDeleteBinary(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void delete(XNContext xNContext) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canDeleteBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, false, false);
            xOMBinaryContainer.deleteBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, false, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.startByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.endByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, byArray2)));
        } else {
            super.delete(xNContext);
        }
    }

    @Override
    public boolean canGetContents(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getContents(XNContext xNContext) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canGetBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, false, true);
            XOMVariant xOMVariant = xOMBinaryContainer.getBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex);
            if (this.chunkType.isFloat()) {
                return new XOMNumber(this.chunkType.bigDecimalValueOf(((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), xNContext.getUnsigned(), xNContext.getLittleEndian()));
            }
            return new XOMInteger(this.chunkType.bigIntegerValueOf(((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), xNContext.getUnsigned(), xNContext.getLittleEndian()));
        }
        BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, false, true);
        byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex);
        if (this.chunkType.isFloat()) {
            return new XOMNumber(this.chunkType.bigDecimalValueOf(byArray, xNContext.getUnsigned(), xNContext.getLittleEndian()));
        }
        return new XOMInteger(this.chunkType.bigIntegerValueOf(byArray, xNContext.getUnsigned(), xNContext.getLittleEndian()));
    }

    @Override
    public boolean canPutContents(XNContext xNContext) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.chunkType.isFloat()) {
            if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble();
                xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(d, xNContext.getLittleEndian()));
            }
        } else if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
            long l = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong();
            xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(l, xNContext.getLittleEndian()));
        }
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, true, false);
            xOMBinaryContainer.putIntoBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, true, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.startByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.endByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), byArray2)));
        } else {
            super.putIntoContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.chunkType.isFloat()) {
            if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble();
                xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(d, xNContext.getLittleEndian()));
            }
        } else if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
            long l = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong();
            xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(l, xNContext.getLittleEndian()));
        }
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, false, false);
            xOMBinaryContainer.putBeforeBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, false, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.startByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.startByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), byArray2)));
        } else {
            super.putBeforeContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.chunkType.isFloat()) {
            if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble();
                xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(d, xNContext.getLittleEndian()));
            }
        } else if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
            long l = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong();
            xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(l, xNContext.getLittleEndian()));
        }
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, true, false);
            xOMBinaryContainer.putAfterBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, true, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.endByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.endByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), byArray2)));
        } else {
            super.putBeforeContents(xNContext, xOMVariant);
        }
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.chunkType.isFloat()) {
            if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble();
                xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(d, xNContext.getLittleEndian()));
            }
        } else if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
            long l = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong();
            xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(l, xNContext.getLittleEndian()));
        }
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, true, false);
            xOMBinaryContainer.putIntoBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, true, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.startByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.endByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), byArray2)), string, xOMVariant2);
        } else {
            super.putIntoContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.chunkType.isFloat()) {
            if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble();
                xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(d, xNContext.getLittleEndian()));
            }
        } else if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
            long l = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong();
            xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(l, xNContext.getLittleEndian()));
        }
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, false, false);
            xOMBinaryContainer.putBeforeBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, true, false, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.startByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.startByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), byArray2)), string, xOMVariant2);
        } else {
            super.putBeforeContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        if (this.chunkType.isFloat()) {
            if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble();
                xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(d, xNContext.getLittleEndian()));
            }
        } else if (XOMIntegerType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true)) {
            long l = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong();
            xOMVariant = new XOMBinary(this.chunkType.byteArrayValueOf(l, xNContext.getLittleEndian()));
        }
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canPutBinary(xNContext)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, true, false);
            xOMBinaryContainer.putAfterBinary(xNContext, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant, string, xOMVariant2);
        } else if (this.parent.canPutContents(xNContext)) {
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, true, false);
            byte[] byArray = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, 0, binaryChunkInfo.endByteIndex);
            byte[] byArray2 = XIONUtil.binarySubstring(binaryChunkInfo.parentContent, binaryChunkInfo.endByteIndex, binaryChunkInfo.byteCount);
            this.parent.putIntoContents(xNContext, new XOMBinary(XIONUtil.binaryConcat(byArray, ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray(), byArray2)), string, xOMVariant2);
        } else {
            super.putBeforeContents(xNContext, xOMVariant, string, xOMVariant2);
        }
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canGetBinaryProperty(xNContext, string)) {
            return true;
        }
        return this.parent.canGetProperty(xNContext, string);
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canGetBinaryProperty(xNContext, string)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, false, false);
            return xOMBinaryContainer.getBinaryProperty(xNContext, xNModifier, string, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex);
        }
        if (this.parent.canGetProperty(xNContext, string)) {
            return this.parent.getProperty(xNContext, xNModifier, string);
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canSetProperty(XNContext xNContext, String string) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canSetBinaryProperty(xNContext, string)) {
            return true;
        }
        return this.parent.canSetProperty(xNContext, string);
    }

    @Override
    public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canSetBinaryProperty(xNContext, string)) {
            XOMBinaryContainer xOMBinaryContainer = (XOMBinaryContainer)((Object)this.parent);
            BinaryChunkInfo binaryChunkInfo = this.getChunkInfo(xNContext, false, false, false);
            xOMBinaryContainer.setBinaryProperty(xNContext, string, binaryChunkInfo.startByteIndex, binaryChunkInfo.endByteIndex, xOMVariant);
        } else if (this.parent.canSetProperty(xNContext, string)) {
            this.parent.setProperty(xNContext, string, xOMVariant);
        } else {
            super.setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public String toLanguageString() {
        return this.chunkType.toString() + " " + this.index + " of " + this.parent.toLanguageString();
    }

    @Override
    public String toTextString(XNContext xNContext) {
        return this.getContents(xNContext).toTextString(xNContext);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this.getContents(xNContext));
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode() ^ this.chunkType.hashCode() ^ this.index;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMBinaryNumericChunk) {
            XOMBinaryNumericChunk xOMBinaryNumericChunk = (XOMBinaryNumericChunk)object;
            return this.parent.equals(xOMBinaryNumericChunk.parent) && this.chunkType == xOMBinaryNumericChunk.chunkType && this.index == xOMBinaryNumericChunk.index;
        }
        return false;
    }

    private static class BinaryChunkInfo {
        public byte[] parentContent;
        public int byteCount;
        public int startByteIndex;
        public int endByteIndex;

        private BinaryChunkInfo() {
        }
    }
}

