/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMColor
extends XOMValue {
    private static final long serialVersionUID = 1L;
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private float[] hsb;

    public XOMColor(int n, int n2, int n3) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
        this.alpha = 65535;
        this.hsb = null;
    }

    public XOMColor(int n, int n2, int n3, int n4) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
        this.alpha = n4;
        this.hsb = null;
    }

    public XOMColor(float[] fArray) {
        this.red = (int)(fArray[0] * 65535.0f);
        this.green = (int)(fArray[1] * 65535.0f);
        this.blue = (int)(fArray[2] * 65535.0f);
        this.alpha = fArray.length > 3 ? (int)(fArray[3] * 65535.0f) : 65535;
        this.hsb = null;
    }

    public XOMColor(Color color) {
        this.red = color.getRed() * 257;
        this.green = color.getGreen() * 257;
        this.blue = color.getBlue() * 257;
        this.alpha = color.getAlpha() * 257;
        this.hsb = null;
    }

    public float[] toRGBAFloatArray() {
        return new float[]{(float)this.red / 65535.0f, (float)this.green / 65535.0f, (float)this.blue / 65535.0f, (float)this.alpha / 65535.0f};
    }

    public Color toColor() {
        return new Color((float)this.red / 65535.0f, (float)this.green / 65535.0f, (float)this.blue / 65535.0f, (float)this.alpha / 65535.0f);
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        return string.equalsIgnoreCase("red") || string.equalsIgnoreCase("green") || string.equalsIgnoreCase("blue") || string.equalsIgnoreCase("alpha") || string.equalsIgnoreCase("hue") || string.equalsIgnoreCase("saturation") || string.equalsIgnoreCase("brightness");
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (string.equalsIgnoreCase("red")) {
            return new XOMInteger(this.red);
        }
        if (string.equalsIgnoreCase("green")) {
            return new XOMInteger(this.green);
        }
        if (string.equalsIgnoreCase("blue")) {
            return new XOMInteger(this.blue);
        }
        if (string.equalsIgnoreCase("alpha")) {
            return new XOMInteger(this.alpha);
        }
        if (string.equalsIgnoreCase("hue")) {
            if (this.hsb == null) {
                this.hsb = Color.RGBtoHSB(this.red / 257, this.green / 257, this.blue / 257, null);
            }
            return new XOMNumber(Float.valueOf(this.hsb[0]));
        }
        if (string.equalsIgnoreCase("saturation")) {
            if (this.hsb == null) {
                this.hsb = Color.RGBtoHSB(this.red / 257, this.green / 257, this.blue / 257, null);
            }
            return new XOMNumber(Float.valueOf(this.hsb[1]));
        }
        if (string.equalsIgnoreCase("brightness")) {
            if (this.hsb == null) {
                this.hsb = Color.RGBtoHSB(this.red / 257, this.green / 257, this.blue / 257, null);
            }
            return new XOMNumber(Float.valueOf(this.hsb[2]));
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public String toLanguageString() {
        if (this.alpha == 65535) {
            return "\"" + this.red + "," + this.green + "," + this.blue + "\"";
        }
        return "\"" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + "\"";
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.alpha == 65535) {
            return this.red + "," + this.green + "," + this.blue;
        }
        return this.red + "," + this.green + "," + this.blue + "," + this.alpha;
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.red ^ this.green << 16 ^ this.blue ^ this.alpha << 16;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMColor) {
            XOMColor xOMColor = (XOMColor)object;
            return this.red == xOMColor.red && this.green == xOMColor.green && this.blue == xOMColor.blue && this.alpha == xOMColor.alpha;
        }
        return false;
    }
}

