/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMDictionary
extends XOMValue {
    private static final long serialVersionUID = 1L;
    public static final XOMDictionary EMPTY_DICTIONARY = new XOMDictionary();
    private LinkedHashMap<String, XOMVariant> theDictionary = new LinkedHashMap();

    private XOMDictionary() {
    }

    public XOMDictionary(Map<String, ? extends XOMVariant> map) {
        this.theDictionary.putAll(map);
    }

    public Map<String, XOMVariant> toMap() {
        return Collections.unmodifiableMap(this.theDictionary);
    }

    public Class<? extends XOMVariant> getValueClass() {
        if (this.theDictionary.isEmpty()) {
            return XOMVariant.class;
        }
        Class<?> clazz = this.theDictionary.values().iterator().next().getClass();
        for (XOMVariant xOMVariant : this.theDictionary.values()) {
            HashSet hashSet = new HashSet();
            for (Class<?> clazz2 = xOMVariant.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                hashSet.add(clazz2);
            }
            while (!hashSet.contains(clazz)) {
                clazz = clazz.getSuperclass();
            }
        }
        return clazz.asSubclass(XOMVariant.class);
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        return string.equalsIgnoreCase("number") || string.equalsIgnoreCase("keys") || string.equalsIgnoreCase("values");
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (string.equalsIgnoreCase("number")) {
            return new XOMInteger(this.theDictionary.size());
        }
        if (string.equalsIgnoreCase("keys")) {
            Vector<XOMString> vector = new Vector<XOMString>();
            for (String string2 : this.theDictionary.keySet()) {
                vector.add(new XOMString(string2));
            }
            return new XOMList(vector);
        }
        if (string.equalsIgnoreCase("values")) {
            return new XOMList(this.theDictionary.values());
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public String toLanguageString() {
        if (this.theDictionary.isEmpty()) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (Map.Entry<String, XOMVariant> entry : this.theDictionary.entrySet()) {
            stringBuffer.append(XIONUtil.quote(entry.getKey()));
            stringBuffer.append(" = ");
            stringBuffer.append(entry.getValue().toLanguageString());
            stringBuffer.append("; ");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.theDictionary.isEmpty()) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        stringBuffer.append(this.toTextString("\t"));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private String toTextString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, XOMVariant> entry : this.theDictionary.entrySet()) {
            stringBuffer.append(string);
            stringBuffer.append(XIONUtil.quote(entry.getKey()));
            stringBuffer.append(" = ");
            if (entry.getValue() instanceof XOMDictionary) {
                XOMDictionary xOMDictionary = (XOMDictionary)entry.getValue();
                if (xOMDictionary.theDictionary.isEmpty()) {
                    stringBuffer.append("{}");
                } else {
                    stringBuffer.append("{\n");
                    stringBuffer.append(xOMDictionary.toTextString(string + "\t"));
                    stringBuffer.append(string);
                    stringBuffer.append("}");
                }
            } else {
                stringBuffer.append(entry.getValue().toLanguageString());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        if (this.theDictionary == null) {
            return 0;
        }
        int n = this.theDictionary.size();
        for (Map.Entry<String, XOMVariant> entry : this.theDictionary.entrySet()) {
            n ^= entry.getKey().hashCode() ^ entry.getValue().hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMDictionary) {
            XOMDictionary xOMDictionary = (XOMDictionary)object;
            if ((this.theDictionary == null || this.theDictionary.isEmpty()) && (xOMDictionary.theDictionary == null || xOMDictionary.theDictionary.isEmpty())) {
                return true;
            }
            if (this.theDictionary.size() != xOMDictionary.theDictionary.size()) {
                return false;
            }
            return this.theDictionary.equals(xOMDictionary.theDictionary);
        }
        return false;
    }
}

