/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMBinaryContainer;
import com.kreative.openxion.xom.XOMComparator;
import com.kreative.openxion.xom.XOMContainer;
import com.kreative.openxion.xom.XOMDictionaryContainer;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.inst.XOMDictionary;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMDictionaryType;
import com.kreative.openxion.xom.type.XOMVariantType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMDictionaryChunk
extends XOMContainer {
    private static final long serialVersionUID = 1L;
    private XOMVariant parent;
    private String key;

    public XOMDictionaryChunk(XOMVariant xOMVariant, String string) {
        this.parent = xOMVariant;
        this.key = string;
    }

    @Override
    public boolean canGetParent(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getParent(XNContext xNContext) {
        return this.parent;
    }

    @Override
    public boolean canDelete(XNContext xNContext) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canDeleteEntry(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void delete(XNContext xNContext) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canDeleteEntry(xNContext)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            xOMDictionaryContainer.deleteEntry(xNContext, this.key);
        } else if (this.parent.canPutContents(xNContext)) {
            LinkedHashMap<String, XOMVariant> linkedHashMap = new LinkedHashMap<String, XOMVariant>();
            linkedHashMap.putAll(XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent.asPrimitive(xNContext)).toMap());
            linkedHashMap.remove(this.key);
            this.parent.asContainer(xNContext, false).putIntoContents(xNContext, new XOMDictionary(linkedHashMap));
        } else {
            throw new XNScriptError("Can't understand this");
        }
    }

    @Override
    public boolean canGetContents(XNContext xNContext) {
        return true;
    }

    @Override
    public XOMVariant getContents(XNContext xNContext) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canGetEntry(xNContext)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            return xOMDictionaryContainer.getEntry(xNContext, this.key);
        }
        if (this.parent.canGetContents(xNContext)) {
            Map<String, XOMVariant> map = XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap();
            return map.containsKey(this.key) ? map.get(this.key) : XOMEmpty.EMPTY;
        }
        throw new XNScriptError("Can't understand this");
    }

    @Override
    public boolean canPutContents(XNContext xNContext) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canPutEntry(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canPutEntry(xNContext)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            xOMDictionaryContainer.putIntoEntry(xNContext, this.key, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            LinkedHashMap<String, XOMVariant> linkedHashMap = new LinkedHashMap<String, XOMVariant>();
            linkedHashMap.putAll(XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap());
            linkedHashMap.put(this.key, xOMVariant);
            this.parent.asContainer(xNContext, false).putIntoContents(xNContext, new XOMDictionary(linkedHashMap));
        } else {
            throw new XNScriptError("Can't understand this");
        }
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canPutEntry(xNContext)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            xOMDictionaryContainer.putBeforeEntry(xNContext, this.key, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            LinkedHashMap<String, XOMVariant> linkedHashMap = new LinkedHashMap<String, XOMVariant>();
            linkedHashMap.putAll(XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap());
            linkedHashMap.put(this.key, linkedHashMap.containsKey(this.key) ? XOMVariantType.instance.makeInstanceFrom(xNContext, xOMVariant, (XOMVariant)linkedHashMap.get(this.key)) : xOMVariant);
            this.parent.asContainer(xNContext, false).putIntoContents(xNContext, new XOMDictionary(linkedHashMap));
        } else {
            throw new XNScriptError("Can't understand this");
        }
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canPutEntry(xNContext)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            xOMDictionaryContainer.putAfterEntry(xNContext, this.key, xOMVariant);
        } else if (this.parent.canPutContents(xNContext)) {
            LinkedHashMap<String, XOMVariant> linkedHashMap = new LinkedHashMap<String, XOMVariant>();
            linkedHashMap.putAll(XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap());
            linkedHashMap.put(this.key, linkedHashMap.containsKey(this.key) ? XOMVariantType.instance.makeInstanceFrom(xNContext, (XOMVariant)linkedHashMap.get(this.key), xOMVariant) : xOMVariant);
            this.parent.asContainer(xNContext, false).putIntoContents(xNContext, new XOMDictionary(linkedHashMap));
        } else {
            throw new XNScriptError("Can't understand this");
        }
    }

    @Override
    public boolean canSortContents(XNContext xNContext) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canSortEntry(xNContext)) {
            return true;
        }
        return this.parent.canPutContents(xNContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sortContents(XNContext xNContext, XOMComparator xOMComparator) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canSortEntry(xNContext)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            xOMDictionaryContainer.sortEntry(xNContext, this.key, xOMComparator);
        } else if (this.parent.canPutContents(xNContext)) {
            Object object;
            LinkedHashMap<String, XOMVariant> linkedHashMap = new LinkedHashMap<String, XOMVariant>();
            linkedHashMap.putAll(XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap());
            XOMVariant xOMVariant = (XOMVariant)linkedHashMap.get(this.key);
            Vector<? extends XOMVariant> vector = new Vector<XOMVariant>();
            if (xOMVariant instanceof XOMList) {
                vector.addAll(((XOMList)xOMVariant).toPrimitiveList(xNContext));
            } else if (xOMVariant instanceof XOMDictionary) {
                for (String object2 : ((XOMDictionary)xOMVariant).toMap().keySet()) {
                    vector.add(new XOMString(object2));
                }
            } else if (xOMVariant instanceof XOMBinary) {
                void var9_22;
                object = ((XOMBinary)xOMVariant).toByteArray();
                String[] i = object;
                int n = i.length;
                boolean bl = false;
                while (var9_22 < n) {
                    String string = i[var9_22];
                    vector.add(new XOMBinary(new byte[]{(byte)string}));
                    ++var9_22;
                }
            } else {
                void var9_24;
                object = xOMVariant.toTextString(xNContext).split("\r\n|\r|\n|\u2028|\u2029");
                String[] stringArray = object;
                int n = stringArray.length;
                boolean bl = false;
                while (var9_24 < n) {
                    String string = stringArray[var9_24];
                    vector.add(new XOMString(string));
                    ++var9_24;
                }
            }
            Collections.sort(vector, xOMComparator);
            if (xOMVariant instanceof XOMList) {
                xOMVariant = new XOMList(vector);
            } else if (xOMVariant instanceof XOMDictionary) {
                object = ((XOMDictionary)xOMVariant).toMap();
                LinkedHashMap linkedHashMap2 = new LinkedHashMap();
                for (XOMVariant xOMVariant2 : vector) {
                    linkedHashMap2.put(xOMVariant2.toTextString(xNContext), object.get(xOMVariant2.toTextString(xNContext)));
                }
                xOMVariant = new XOMDictionary(linkedHashMap2);
            } else if (xOMVariant instanceof XOMBinary) {
                void var7_14;
                object = new byte[vector.size()];
                boolean bl = false;
                while (var7_14 < vector.size()) {
                    object[var7_14] = ((XOMBinary)vector.get((int)var7_14)).toByteArray()[0];
                    ++var7_14;
                }
                xOMVariant = new XOMBinary((byte[])object);
            } else {
                object = new StringBuffer();
                for (XOMVariant xOMVariant3 : vector) {
                    ((StringBuffer)object).append(xOMVariant3.toTextString(xNContext) + xNContext.getLineEnding());
                }
                if (((StringBuffer)object).length() > 0 && ((StringBuffer)object).substring(((StringBuffer)object).length() - xNContext.getLineEnding().length()).equals(xNContext.getLineEnding())) {
                    ((StringBuffer)object).delete(((StringBuffer)object).length() - xNContext.getLineEnding().length(), ((StringBuffer)object).length());
                }
                xOMVariant = new XOMString(((StringBuffer)object).toString());
            }
            linkedHashMap.put(this.key, xOMVariant);
            this.parent.asContainer(xNContext, false).putIntoContents(xNContext, new XOMDictionary(linkedHashMap));
        } else {
            throw new XNScriptError("Can't understand this");
        }
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        if (this.parent instanceof XOMBinaryContainer && ((XOMBinaryContainer)((Object)this.parent)).canGetBinaryProperty(xNContext, string)) {
            return true;
        }
        Map<String, XOMVariant> map = XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap();
        return map.containsKey(this.key) && map.get(this.key).canGetProperty(xNContext, string);
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canGetEntryProperty(xNContext, string)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            return xOMDictionaryContainer.getEntryProperty(xNContext, xNModifier, string, this.key);
        }
        Map<String, XOMVariant> map = XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap();
        if (!map.containsKey(this.key)) {
            throw new XNScriptError("Can't get that property");
        }
        return map.get(this.key).getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canSetProperty(XNContext xNContext, String string) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canSetEntryProperty(xNContext, string)) {
            return true;
        }
        Map<String, XOMVariant> map = XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap();
        return map.containsKey(this.key) && map.get(this.key).canSetProperty(xNContext, string);
    }

    @Override
    public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
        if (this.parent instanceof XOMDictionaryContainer && ((XOMDictionaryContainer)((Object)this.parent)).canSetEntryProperty(xNContext, string)) {
            XOMDictionaryContainer xOMDictionaryContainer = (XOMDictionaryContainer)((Object)this.parent);
            xOMDictionaryContainer.setEntryProperty(xNContext, string, this.key, xOMVariant);
        } else {
            Map<String, XOMVariant> map = XOMDictionaryType.instance.makeInstanceFrom(xNContext, this.parent).toMap();
            if (!map.containsKey(this.key)) {
                throw new XNScriptError("Can't set that property");
            }
            map.get(this.key).setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public String toLanguageString() {
        return "entry " + XIONUtil.quote(this.key) + " of " + this.parent.toLanguageString();
    }

    @Override
    public String toTextString(XNContext xNContext) {
        return this.getContents(xNContext).toTextString(xNContext);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this.getContents(xNContext));
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode() ^ this.key.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMDictionaryChunk) {
            XOMDictionaryChunk xOMDictionaryChunk = (XOMDictionaryChunk)object;
            return this.parent.equals(xOMDictionaryChunk.parent) && this.key.equals(xOMDictionaryChunk.key);
        }
        return false;
    }
}

