/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMNumber
extends XOMValue {
    private static final long serialVersionUID = 1L;
    public static final BigDecimal BIGDECIMAL_PI = new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068");
    public static final BigDecimal BIGDECIMAL_E = new BigDecimal("2.718281828459045235360287471352662497757247093699959574966967627724076630353547594571382178525166427");
    public static final BigDecimal BIGDECIMAL_PHI = new BigDecimal("1.618033988749894848204586834365638117720309179805762862135448622705260462818902449707207204189391137");
    public static final XOMNumber ZERO = new XOMNumber(BigDecimal.ZERO);
    public static final XOMNumber ONE = new XOMNumber(BigDecimal.ONE);
    public static final XOMNumber TEN = new XOMNumber(BigDecimal.TEN);
    public static final XOMNumber PI = new XOMNumber(BIGDECIMAL_PI);
    public static final XOMNumber E = new XOMNumber(BIGDECIMAL_E);
    public static final XOMNumber PHI = new XOMNumber(BIGDECIMAL_PHI);
    public static final XOMNumber POSITIVE_INFINITY = new XOMNumber(false, false);
    public static final XOMNumber NEGATIVE_INFINITY = new XOMNumber(false, true);
    public static final XOMNumber NaN = new XOMNumber(true, false);
    private BigDecimal theNumber;
    private boolean undefined;
    public static final int SIGN_NaN = Integer.MIN_VALUE;
    public static final int SIGN_NEGATIVE = -1;
    public static final int SIGN_ZERO = 0;
    public static final int SIGN_POSITIVE = 1;

    public XOMNumber(Number number) {
        if (number == null) {
            this.theNumber = BigDecimal.ZERO;
            this.undefined = true;
        } else if (number instanceof BigDecimal) {
            this.theNumber = (BigDecimal)number;
            this.undefined = false;
        } else if (number instanceof BigInteger) {
            this.theNumber = new BigDecimal((BigInteger)number);
            this.undefined = false;
        } else if (number instanceof Double) {
            double d = number.doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                this.theNumber = Double.isNaN(d) ? BigDecimal.ZERO : (d < 0.0 ? BigDecimal.ONE.negate() : BigDecimal.ONE);
                this.undefined = true;
            } else {
                this.theNumber = BigDecimal.valueOf(d);
                this.undefined = false;
            }
        } else if (number instanceof Float) {
            float f = number.floatValue();
            if (Float.isNaN(f) || Float.isInfinite(f)) {
                this.theNumber = Float.isNaN(f) ? BigDecimal.ZERO : (f < 0.0f ? BigDecimal.ONE.negate() : BigDecimal.ONE);
                this.undefined = true;
            } else {
                this.theNumber = new BigDecimal(Float.toString(f));
                this.undefined = false;
            }
        } else if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            this.theNumber = BigDecimal.valueOf(number.longValue());
            this.undefined = false;
        } else {
            double d = number.doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                this.theNumber = Double.isNaN(d) ? BigDecimal.ZERO : (d < 0.0 ? BigDecimal.ONE.negate() : BigDecimal.ONE);
                this.undefined = true;
            } else {
                this.theNumber = BigDecimal.valueOf(d);
                this.undefined = false;
            }
        }
    }

    private XOMNumber(boolean bl, boolean bl2) {
        this.theNumber = bl ? BigDecimal.ZERO : (bl2 ? BigDecimal.ONE.negate() : BigDecimal.ONE);
        this.undefined = true;
    }

    public boolean isUndefined() {
        return this.theNumber == null || this.undefined;
    }

    public boolean isNaN() {
        return this.theNumber == null || this.undefined && this.theNumber.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isInfinite() {
        return this.theNumber != null && this.undefined && this.theNumber.compareTo(BigDecimal.ZERO) != 0;
    }

    public boolean isZero() {
        return this.theNumber != null && !this.undefined && this.theNumber.compareTo(BigDecimal.ZERO) == 0;
    }

    public int getSign() {
        if (this.theNumber == null) {
            return Integer.MIN_VALUE;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }
        int n = this.theNumber.compareTo(BigDecimal.ZERO);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    public int getOppositeSign() {
        if (this.theNumber == null) {
            return Integer.MIN_VALUE;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return 1;
            }
            if (n > 0) {
                return -1;
            }
            return Integer.MIN_VALUE;
        }
        int n = this.theNumber.compareTo(BigDecimal.ZERO);
        if (n < 0) {
            return 1;
        }
        if (n > 0) {
            return -1;
        }
        return 0;
    }

    public XOMNumber abs() {
        if (this.theNumber == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n == 0) {
                return NaN;
            }
            return POSITIVE_INFINITY;
        }
        return new XOMNumber(this.theNumber.abs());
    }

    public XOMNumber negate() {
        if (this.theNumber == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return POSITIVE_INFINITY;
            }
            if (n > 0) {
                return NEGATIVE_INFINITY;
            }
            return NaN;
        }
        return new XOMNumber(this.theNumber.negate());
    }

    public XOMNumber signum() {
        if (this.theNumber == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n > 0) {
                return ONE;
            }
            if (n < 0) {
                return ONE.negate();
            }
            return NaN;
        }
        int n = this.theNumber.compareTo(BigDecimal.ZERO);
        if (n > 0) {
            return ONE;
        }
        if (n < 0) {
            return ONE.negate();
        }
        return ZERO;
    }

    public XOMNumber ceil() {
        return this.round(RoundingMode.CEILING);
    }

    public XOMNumber floor() {
        return this.round(RoundingMode.FLOOR);
    }

    public XOMNumber round() {
        return this.round(RoundingMode.HALF_UP);
    }

    public XOMNumber aug() {
        return this.round(RoundingMode.UP);
    }

    public XOMNumber trunc() {
        return this.round(RoundingMode.DOWN);
    }

    public XOMNumber rint() {
        return this.round(RoundingMode.HALF_EVEN);
    }

    public XOMNumber round(RoundingMode roundingMode) {
        if (this.theNumber == null || this.undefined) {
            return this;
        }
        return new XOMNumber(this.theNumber.divide(BigDecimal.ONE, 0, roundingMode));
    }

    public XOMNumber frac() {
        if (this.theNumber == null || this.undefined) {
            return NaN;
        }
        return new XOMNumber(this.theNumber.subtract(this.theNumber.divide(BigDecimal.ONE, 0, RoundingMode.DOWN)));
    }

    public Number toNumber() {
        if (this.theNumber == null) {
            return Double.NaN;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (n > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return this.theNumber;
    }

    public BigDecimal toBigDecimal() {
        if (this.theNumber == null || this.undefined) {
            return null;
        }
        return this.theNumber;
    }

    public double toDouble() {
        if (this.theNumber == null) {
            return Double.NaN;
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (n > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return this.theNumber.doubleValue();
    }

    public long toLong() {
        if (this.theNumber == null || this.undefined) {
            return 0L;
        }
        return this.theNumber.longValue();
    }

    public int toInt() {
        if (this.theNumber == null || this.undefined) {
            return 0;
        }
        return this.theNumber.intValue();
    }

    @Override
    public String toLanguageString() {
        if (this.theNumber == null) {
            return "NAN";
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return "-INF";
            }
            if (n > 0) {
                return "INF";
            }
            return "NAN";
        }
        return this.theNumber.toString().replaceAll("[Ee][-]([0-9]+)", "''$1").replaceAll("[Ee][+]?([0-9]+)", "'$1");
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.theNumber == null) {
            return "NAN";
        }
        if (this.undefined) {
            int n = this.theNumber.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return "-INF";
            }
            if (n > 0) {
                return "INF";
            }
            return "NAN";
        }
        return xNContext.getNumberFormat().format(this.theNumber);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.theNumber == null ? 0 : (this.undefined ? this.theNumber.signum() : this.theNumber.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMNumber) {
            XOMNumber xOMNumber = (XOMNumber)object;
            if (this.isNaN() && xOMNumber.isNaN()) {
                return true;
            }
            if (this.isNaN() || xOMNumber.isNaN()) {
                return false;
            }
            if (this.undefined && xOMNumber.undefined) {
                return this.theNumber.compareTo(BigDecimal.ZERO) == xOMNumber.theNumber.compareTo(BigDecimal.ZERO);
            }
            if (this.undefined || xOMNumber.undefined) {
                return false;
            }
            return this.theNumber.compareTo(xOMNumber.theNumber) == 0;
        }
        return false;
    }
}

