/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import java.awt.Point;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMPoint
extends XOMValue {
    private static final long serialVersionUID = 1L;
    private BigInteger x;
    private BigInteger y;

    public XOMPoint(int n, int n2) {
        this.x = BigInteger.valueOf(n);
        this.y = BigInteger.valueOf(n2);
    }

    public XOMPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        this.x = bigInteger;
        this.y = bigInteger2;
    }

    public XOMPoint(Point point) {
        this.x = BigInteger.valueOf(point.x);
        this.y = BigInteger.valueOf(point.y);
    }

    public BigInteger x() {
        return this.x;
    }

    public BigInteger y() {
        return this.y;
    }

    public Point toPoint() {
        return new Point(this.x.intValue(), this.y.intValue());
    }

    @Override
    public String toLanguageString() {
        return "\"" + (this.x == null ? "0" : this.x.toString()) + "," + (this.y == null ? "0" : this.y.toString()) + "\"";
    }

    @Override
    public String toTextString(XNContext xNContext) {
        return (this.x == null ? "0" : this.x.toString()) + "," + (this.y == null ? "0" : this.y.toString());
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.x.hashCode() ^ this.y.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMPoint) {
            XOMPoint xOMPoint = (XOMPoint)object;
            return this.x.compareTo(xOMPoint.x) == 0 && this.y.compareTo(xOMPoint.y) == 0;
        }
        return false;
    }
}

