/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.type;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.type.XOMListType;
import com.kreative.openxion.xom.type.XOMNumericDataType;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMComplexType
extends XOMNumericDataType<XOMComplex> {
    private static final long serialVersionUID = 1L;
    public static final XOMComplexType instance = new XOMComplexType();
    public static final XOMListType listInstance = new XOMListType("complexes", 0, instance);

    private XOMComplexType() {
        super("complex", 0, XOMComplex.class);
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant, boolean bl) {
        return xOMVariant instanceof XOMInteger || xOMVariant instanceof XOMNumber;
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, String string, boolean bl) {
        if (string.equals("")) {
            return bl;
        }
        if (string.equalsIgnoreCase("inf") || string.equalsIgnoreCase("-inf") || string.equalsIgnoreCase("nan")) {
            return true;
        }
        String[] stringArray = (string = string.replace("''", "E-").replace("'", "E+")).split(",");
        if (stringArray.length < 1 || stringArray.length > 2) {
            return false;
        }
        if (stringArray.length > 1) {
            try {
                xNContext.getNumberFormat().parseBigDecimal(stringArray[1]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            xNContext.getNumberFormat().parseBigDecimal(stringArray[0]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    protected XOMComplex makeInstanceFromImpl(XNContext xNContext) {
        return XOMComplex.ZERO;
    }

    @Override
    protected XOMComplex makeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant, boolean bl) {
        if (xOMVariant instanceof XOMInteger) {
            return new XOMComplex(new BigDecimal(((XOMInteger)xOMVariant).toBigInteger()), BigDecimal.ZERO);
        }
        if (xOMVariant instanceof XOMNumber) {
            return new XOMComplex(((XOMNumber)xOMVariant).toBigDecimal(), BigDecimal.ZERO);
        }
        throw new XOMMorphError(this.typeName);
    }

    @Override
    protected XOMComplex makeInstanceFromImpl(XNContext xNContext, String string, boolean bl) {
        if (string.equals("")) {
            if (bl) {
                return XOMComplex.ZERO;
            }
            throw new XOMMorphError(this.typeName);
        }
        if (string.equalsIgnoreCase("inf")) {
            return XOMComplex.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-inf")) {
            return XOMComplex.NEGATIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("nan")) {
            return XOMComplex.NaN;
        }
        String[] stringArray = (string = string.replace("''", "E-").replace("'", "E+")).split(",");
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new XOMMorphError(this.typeName);
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        if (stringArray.length > 1) {
            try {
                bigDecimal2 = xNContext.getNumberFormat().parseBigDecimal(stringArray[1]);
            }
            catch (Exception exception) {
                throw new XOMMorphError(this.typeName);
            }
        }
        try {
            bigDecimal = xNContext.getNumberFormat().parseBigDecimal(stringArray[0]);
        }
        catch (Exception exception) {
            throw new XOMMorphError(this.typeName);
        }
        return new XOMComplex(bigDecimal, bigDecimal2);
    }
}

