/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.type;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.type.XOMListType;
import com.kreative.openxion.xom.type.XOMNumericDataType;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMNumberType
extends XOMNumericDataType<XOMNumber> {
    private static final long serialVersionUID = 1L;
    public static final XOMNumberType instance = new XOMNumberType();
    public static final XOMListType listInstance = new XOMListType("numbers", 0, instance);

    private XOMNumberType() {
        super("number", 0, XOMNumber.class);
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant, boolean bl) {
        if (xOMVariant instanceof XOMInteger) {
            return true;
        }
        if (xOMVariant instanceof XOMComplex) {
            return ((XOMComplex)xOMVariant).isReal();
        }
        return false;
    }

    @Override
    protected boolean canMakeInstanceFromImpl(XNContext xNContext, String string, boolean bl) {
        if (string.equals("")) {
            return bl;
        }
        if (string.equalsIgnoreCase("inf") || string.equalsIgnoreCase("-inf") || string.equalsIgnoreCase("nan")) {
            return true;
        }
        string = string.replace("''", "E-").replace("'", "E+");
        try {
            xNContext.getNumberFormat().parseBigDecimal(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected XOMNumber makeInstanceFromImpl(XNContext xNContext) {
        return XOMNumber.ZERO;
    }

    @Override
    protected XOMNumber makeInstanceFromImpl(XNContext xNContext, XOMVariant xOMVariant, boolean bl) {
        if (xOMVariant instanceof XOMInteger) {
            return new XOMNumber(new BigDecimal(((XOMInteger)xOMVariant).toBigInteger()));
        }
        if (xOMVariant instanceof XOMComplex) {
            if (((XOMComplex)xOMVariant).isReal()) {
                return new XOMNumber(((XOMComplex)xOMVariant).toBigDecimals()[0]);
            }
            throw new XOMMorphError(this.typeName);
        }
        throw new XOMMorphError(this.typeName);
    }

    @Override
    protected XOMNumber makeInstanceFromImpl(XNContext xNContext, String string, boolean bl) {
        if (string.equals("")) {
            if (bl) {
                return XOMNumber.ZERO;
            }
            throw new XOMMorphError(this.typeName);
        }
        if (string.equalsIgnoreCase("inf")) {
            return XOMNumber.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-inf")) {
            return XOMNumber.NEGATIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("nan")) {
            return XOMNumber.NaN;
        }
        string = string.replace("''", "E-").replace("'", "E+");
        try {
            return new XOMNumber(xNContext.getNumberFormat().parseBigDecimal(string));
        }
        catch (Exception exception) {
            throw new XOMMorphError(this.typeName);
        }
    }
}

