/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc;

import com.kreative.xiondoc.sdom.Anchor;
import com.kreative.xiondoc.sdom.Big;
import com.kreative.xiondoc.sdom.Block;
import com.kreative.xiondoc.sdom.Bold;
import com.kreative.xiondoc.sdom.Break;
import com.kreative.xiondoc.sdom.Choice;
import com.kreative.xiondoc.sdom.ChoiceItem;
import com.kreative.xiondoc.sdom.Code;
import com.kreative.xiondoc.sdom.DialectName;
import com.kreative.xiondoc.sdom.DialectVersion;
import com.kreative.xiondoc.sdom.Else;
import com.kreative.xiondoc.sdom.Generic;
import com.kreative.xiondoc.sdom.H1;
import com.kreative.xiondoc.sdom.H2;
import com.kreative.xiondoc.sdom.H3;
import com.kreative.xiondoc.sdom.H4;
import com.kreative.xiondoc.sdom.H5;
import com.kreative.xiondoc.sdom.H6;
import com.kreative.xiondoc.sdom.HorizontalRule;
import com.kreative.xiondoc.sdom.If;
import com.kreative.xiondoc.sdom.Image;
import com.kreative.xiondoc.sdom.Italic;
import com.kreative.xiondoc.sdom.Keyword;
import com.kreative.xiondoc.sdom.ListItem;
import com.kreative.xiondoc.sdom.ListOrListItem;
import com.kreative.xiondoc.sdom.Literal;
import com.kreative.xiondoc.sdom.Metavariable;
import com.kreative.xiondoc.sdom.Optional;
import com.kreative.xiondoc.sdom.OrderedList;
import com.kreative.xiondoc.sdom.Paragraph;
import com.kreative.xiondoc.sdom.Script;
import com.kreative.xiondoc.sdom.Section;
import com.kreative.xiondoc.sdom.Small;
import com.kreative.xiondoc.sdom.Span;
import com.kreative.xiondoc.sdom.Strikethrough;
import com.kreative.xiondoc.sdom.Subscript;
import com.kreative.xiondoc.sdom.Superscript;
import com.kreative.xiondoc.sdom.Syntactic;
import com.kreative.xiondoc.sdom.Syntax;
import com.kreative.xiondoc.sdom.Table;
import com.kreative.xiondoc.sdom.TableCell;
import com.kreative.xiondoc.sdom.TableData;
import com.kreative.xiondoc.sdom.TableHeader;
import com.kreative.xiondoc.sdom.TableRow;
import com.kreative.xiondoc.sdom.TermName;
import com.kreative.xiondoc.sdom.Underline;
import com.kreative.xiondoc.sdom.UnorderedList;
import com.kreative.xiondoc.xdom.DialectSpecList;
import com.kreative.xiondoc.xdom.TermCollection;
import com.kreative.xiondoc.xdom.TermType;
import com.kreative.xiondoc.xdom.VersionNumber;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLSDOMGenerator {
    private static final Pattern INTERNAL_HREF_PATTERN = Pattern.compile("([A-Za-z]{2}):(.*)", 32);
    private final TermCollection termCollection;
    private TermType currentTermType = null;
    private String currentTermName = null;
    private String currentDialectCode = null;
    private String currentDialectTitle = null;
    private VersionNumber currentDialectVersion = null;
    private String urlPrefix = null;

    public HTMLSDOMGenerator(TermCollection termCollection) {
        this.termCollection = termCollection;
    }

    public void setTerm(TermType termType, String string) {
        this.currentTermType = termType;
        this.currentTermName = string;
    }

    public void unsetTerm() {
        this.currentTermType = null;
        this.currentTermName = null;
    }

    public void setDialect(String string, String string2, VersionNumber versionNumber) {
        this.currentDialectCode = string;
        this.currentDialectTitle = string2;
        this.currentDialectVersion = versionNumber;
    }

    public void unsetDialect() {
        this.currentDialectCode = null;
        this.currentDialectTitle = null;
        this.currentDialectVersion = null;
    }

    public void setURLPrefix(String string) {
        this.urlPrefix = string;
    }

    public void unsetURLPrefix() {
        this.urlPrefix = null;
    }

    public String generateSectionHTML(Section section) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Block block : section) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append('\n');
            }
            this.generateBlockHTML(stringBuffer, block);
        }
        return stringBuffer.toString();
    }

    private void generateBlockHTML(StringBuffer stringBuffer, Block block) {
        int n = block.getIndent();
        if (block instanceof Script) {
            stringBuffer.append("<pre class=\"block script indent" + n + "\">");
            stringBuffer.append('\n');
            stringBuffer.append(((Script)block).getScript());
            stringBuffer.append('\n');
            stringBuffer.append("</pre>");
        } else if (block instanceof Syntax) {
            stringBuffer.append("<p class=\"block syntax indent" + n + "\">");
            this.generateSyntaxHTML(stringBuffer, (Syntax)block);
            stringBuffer.append("</p>");
        } else if (block instanceof UnorderedList) {
            int n2 = ((UnorderedList)block).getBorder();
            stringBuffer.append("<ul class=\"block unorderedlist indent" + n + " border" + n2 + "\">");
            stringBuffer.append('\n');
            for (ListOrListItem listOrListItem : (UnorderedList)block) {
                this.generateListItemHTML(stringBuffer, listOrListItem);
                stringBuffer.append('\n');
            }
            stringBuffer.append("</ul>");
        } else if (block instanceof OrderedList) {
            int n3 = ((OrderedList)block).getBorder();
            stringBuffer.append("<ol class=\"block orderedlist indent" + n + " border" + n3 + "\">");
            stringBuffer.append('\n');
            for (ListOrListItem listOrListItem : (OrderedList)block) {
                this.generateListItemHTML(stringBuffer, listOrListItem);
                stringBuffer.append('\n');
            }
            stringBuffer.append("</ol>");
        } else if (block instanceof Table) {
            int n4 = ((Table)block).getBorder();
            stringBuffer.append("<table class=\"block table indent" + n + " border" + n4 + "\">");
            stringBuffer.append('\n');
            for (TableRow tableRow : (Table)block) {
                this.generateTableRowHTML(stringBuffer, tableRow);
                stringBuffer.append('\n');
            }
            stringBuffer.append("</table>");
        } else if (block instanceof Paragraph) {
            stringBuffer.append("<p class=\"block paragraph indent" + n + "\">");
            for (Span span : (Paragraph)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</p>");
        } else if (block instanceof H1) {
            stringBuffer.append("<h1>");
            for (Span span : (H1)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</h1>");
        } else if (block instanceof H2) {
            stringBuffer.append("<h2>");
            for (Span span : (H2)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</h2>");
        } else if (block instanceof H3) {
            stringBuffer.append("<h3>");
            for (Span span : (H3)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</h3>");
        } else if (block instanceof H4) {
            stringBuffer.append("<h4>");
            for (Span span : (H4)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</h4>");
        } else if (block instanceof H5) {
            stringBuffer.append("<h5>");
            for (Span span : (H5)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</h5>");
        } else if (block instanceof H6) {
            stringBuffer.append("<h6>");
            for (Span span : (H6)block) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</h6>");
        } else if (block instanceof HorizontalRule) {
            stringBuffer.append("<hr/>");
        } else if (block instanceof Image) {
            stringBuffer.append("<p class=\"block image indent" + n + "\">");
            this.generateSpanHTML(stringBuffer, (Image)block);
            stringBuffer.append("</p>");
        }
    }

    private void generateSyntaxHTML(StringBuffer stringBuffer, List<Syntactic> list) {
        boolean bl = true;
        for (Syntactic syntactic : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            this.generateSyntacticHTML(stringBuffer, syntactic);
        }
    }

    private void generateSyntacticHTML(StringBuffer stringBuffer, Syntactic syntactic) {
        if (syntactic instanceof Keyword) {
            stringBuffer.append("<code class=\"keyword\">");
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(((Keyword)syntactic).toString(), true));
            stringBuffer.append("</code>");
        } else if (syntactic instanceof Metavariable) {
            stringBuffer.append("<em class=\"metavariable\">");
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(((Metavariable)syntactic).toString(), true));
            stringBuffer.append("</em>");
        } else if (syntactic instanceof Optional) {
            if (((Optional)syntactic).size() == 1 && ((Optional)syntactic).get(0) instanceof Choice) {
                stringBuffer.append("<span class=\"optional choice\">");
                stringBuffer.append("<span class=\"metasymbol\">[</span>");
                boolean bl = true;
                for (ChoiceItem choiceItem : (Choice)((Optional)syntactic).get(0)) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append("<span class=\"metasymbol\">|</span>");
                    }
                    this.generateSyntaxHTML(stringBuffer, choiceItem);
                }
                stringBuffer.append("<span class=\"metasymbol\">]</span>");
                stringBuffer.append("</span>");
            } else {
                stringBuffer.append("<span class=\"optional\">");
                stringBuffer.append("<span class=\"metasymbol\">[</span>");
                this.generateSyntaxHTML(stringBuffer, (Optional)syntactic);
                stringBuffer.append("<span class=\"metasymbol\">]</span>");
                stringBuffer.append("</span>");
            }
        } else if (syntactic instanceof Choice) {
            stringBuffer.append("<span class=\"choice\">");
            stringBuffer.append("<span class=\"metasymbol\">(</span>");
            boolean bl = true;
            for (ChoiceItem choiceItem : (Choice)syntactic) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append("<span class=\"metasymbol\">|</span>");
                }
                this.generateSyntaxHTML(stringBuffer, choiceItem);
            }
            stringBuffer.append("<span class=\"metasymbol\">)</span>");
            stringBuffer.append("</span>");
        } else if (syntactic instanceof Break) {
            stringBuffer.append("<br/>");
            int n = ((Break)syntactic).getIndent();
            if (n > 0) {
                stringBuffer.append(' ');
                stringBuffer.append("<span class=\"syntaxindent\">");
                while (n-- > 0) {
                    stringBuffer.append("&nbsp;&nbsp;");
                }
                stringBuffer.append("</span>");
            }
        } else if (syntactic instanceof TermName && this.currentTermName != null) {
            String[] stringArray = this.currentTermName.trim().split("\\s+");
            boolean bl = true;
            for (String string : stringArray) {
                if (string.length() <= 0) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("<code class=\"keyword\">");
                stringBuffer.append(HTMLSDOMGenerator.htmlencode(string, true));
                stringBuffer.append("</code>");
            }
        }
    }

    private void generateListItemHTML(StringBuffer stringBuffer, ListOrListItem listOrListItem) {
        if (listOrListItem instanceof ListItem) {
            stringBuffer.append("<li>");
            for (Span span : (ListItem)listOrListItem) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</li>");
        } else if (listOrListItem instanceof UnorderedList) {
            stringBuffer.append("<li>");
            stringBuffer.append('\n');
            stringBuffer.append("<ul>");
            stringBuffer.append('\n');
            for (ListOrListItem listOrListItem2 : (UnorderedList)listOrListItem) {
                this.generateListItemHTML(stringBuffer, listOrListItem2);
                stringBuffer.append('\n');
            }
            stringBuffer.append("</ul>");
            stringBuffer.append('\n');
            stringBuffer.append("</li>");
        } else if (listOrListItem instanceof OrderedList) {
            stringBuffer.append("<li>");
            stringBuffer.append('\n');
            stringBuffer.append("<ol>");
            stringBuffer.append('\n');
            for (ListOrListItem listOrListItem3 : (OrderedList)listOrListItem) {
                this.generateListItemHTML(stringBuffer, listOrListItem3);
                stringBuffer.append('\n');
            }
            stringBuffer.append("</ol>");
            stringBuffer.append('\n');
            stringBuffer.append("</li>");
        }
    }

    private void generateTableRowHTML(StringBuffer stringBuffer, TableRow tableRow) {
        stringBuffer.append("<tr>");
        stringBuffer.append('\n');
        for (TableCell tableCell : tableRow) {
            this.generateTableCellHTML(stringBuffer, tableCell);
            stringBuffer.append('\n');
        }
        stringBuffer.append("</tr>");
    }

    private void generateTableCellHTML(StringBuffer stringBuffer, TableCell tableCell) {
        int n = tableCell.getColSpan();
        int n2 = tableCell.getRowSpan();
        if (tableCell instanceof TableHeader) {
            stringBuffer.append("<th");
            if (n != 1) {
                stringBuffer.append(" colspan=\"" + n + "\"");
            }
            if (n2 != 1) {
                stringBuffer.append(" rowspan=\"" + n2 + "\"");
            }
            stringBuffer.append(">");
            for (Span span : (TableHeader)tableCell) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</th>");
        } else if (tableCell instanceof TableData) {
            stringBuffer.append("<td");
            if (n != 1) {
                stringBuffer.append(" colspan=\"" + n + "\"");
            }
            if (n2 != 1) {
                stringBuffer.append(" rowspan=\"" + n2 + "\"");
            }
            stringBuffer.append(">");
            for (Span span : (TableData)tableCell) {
                this.generateSpanHTML(stringBuffer, span);
            }
            stringBuffer.append("</td>");
        }
    }

    private void generateSpanHTML(StringBuffer stringBuffer, Span span) {
        if (span instanceof Literal) {
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(((Literal)span).toString(), false));
        } else if (span instanceof Image) {
            String string = ((Image)span).getSrc();
            if (!string.contains(":")) {
                string = "images/" + string;
                if (this.urlPrefix != null) {
                    string = this.urlPrefix + string;
                }
            }
            stringBuffer.append("<img src=\"" + HTMLSDOMGenerator.htmlencode(string, true) + "\"");
            if (((Image)span).hasWidth()) {
                stringBuffer.append(" width=\"" + HTMLSDOMGenerator.htmlencode(((Image)span).getWidth(), true) + "\"");
            }
            if (((Image)span).hasHeight()) {
                stringBuffer.append(" height=\"" + HTMLSDOMGenerator.htmlencode(((Image)span).getHeight(), true) + "\"");
            }
            if (((Image)span).hasAlt()) {
                stringBuffer.append(" alt=\"" + HTMLSDOMGenerator.htmlencode(((Image)span).getAlt(), true) + "\"");
            }
            if (((Image)span).hasTitle()) {
                stringBuffer.append(" title=\"" + HTMLSDOMGenerator.htmlencode(((Image)span).getTitle(), true) + "\"");
            }
            stringBuffer.append(" />");
        } else if (span instanceof Bold) {
            stringBuffer.append("<strong>");
            for (Span span2 : (Bold)span) {
                this.generateSpanHTML(stringBuffer, span2);
            }
            stringBuffer.append("</strong>");
        } else if (span instanceof Italic) {
            stringBuffer.append("<em>");
            for (Span span3 : (Italic)span) {
                this.generateSpanHTML(stringBuffer, span3);
            }
            stringBuffer.append("</em>");
        } else if (span instanceof Underline) {
            stringBuffer.append("<u>");
            for (Span span4 : (Underline)span) {
                this.generateSpanHTML(stringBuffer, span4);
            }
            stringBuffer.append("</u>");
        } else if (span instanceof Strikethrough) {
            stringBuffer.append("<s>");
            for (Span span5 : (Strikethrough)span) {
                this.generateSpanHTML(stringBuffer, span5);
            }
            stringBuffer.append("</s>");
        } else if (span instanceof Superscript) {
            stringBuffer.append("<sup>");
            for (Span span6 : (Superscript)span) {
                this.generateSpanHTML(stringBuffer, span6);
            }
            stringBuffer.append("</sup>");
        } else if (span instanceof Subscript) {
            stringBuffer.append("<sub>");
            for (Span span7 : (Subscript)span) {
                this.generateSpanHTML(stringBuffer, span7);
            }
            stringBuffer.append("</sub>");
        } else if (span instanceof Big) {
            stringBuffer.append("<big>");
            for (Span span8 : (Big)span) {
                this.generateSpanHTML(stringBuffer, span8);
            }
            stringBuffer.append("</big>");
        } else if (span instanceof Small) {
            stringBuffer.append("<small>");
            for (Span span9 : (Small)span) {
                this.generateSpanHTML(stringBuffer, span9);
            }
            stringBuffer.append("</small>");
        } else if (span instanceof Code) {
            stringBuffer.append("<code>");
            for (Span span10 : (Code)span) {
                this.generateSpanHTML(stringBuffer, span10);
            }
            stringBuffer.append("</code>");
        } else if (span instanceof Keyword) {
            stringBuffer.append("<code class=\"keyword\">");
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(((Keyword)span).toString(), true));
            stringBuffer.append("</code>");
        } else if (span instanceof Metavariable) {
            stringBuffer.append("<em class=\"metavariable\">");
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(((Metavariable)span).toString(), true));
            stringBuffer.append("</em>");
        } else if (span instanceof Generic) {
            stringBuffer.append("<span class=\"generic\" style=\"");
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(((Generic)span).getStyle(), true));
            stringBuffer.append("\">");
            for (Span span11 : (Generic)span) {
                this.generateSpanHTML(stringBuffer, span11);
            }
            stringBuffer.append("</span>");
        } else if (span instanceof Anchor) {
            String string = ((Anchor)span).getHref();
            Matcher matcher = INTERNAL_HREF_PATTERN.matcher(string);
            if (matcher.matches()) {
                boolean bl;
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                boolean bl2 = ((Anchor)span).isEmpty() || ((Anchor)span).size() == 1 && ((Anchor)span).get(0) instanceof Literal;
                boolean bl3 = bl2 && (((Anchor)span).isEmpty() || ((Span)((Anchor)span).get(0)).toString().equalsIgnoreCase(string) || ((Span)((Anchor)span).get(0)).toString().equalsIgnoreCase(string3));
                boolean bl4 = !this.termCollection.getTerms(TermType.forCode(string2), string3, this.currentDialectCode, this.currentDialectVersion).isEmpty();
                boolean bl5 = bl = this.currentTermType != null && this.currentTermName != null && (this.currentTermType.getCode() + ":" + this.currentTermName).equalsIgnoreCase(string);
                if (bl2) {
                    stringBuffer.append("<code>");
                }
                if (bl4 && !bl) {
                    stringBuffer.append("<a href=\"");
                    if (this.urlPrefix != null) {
                        stringBuffer.append(HTMLSDOMGenerator.htmlencode(this.urlPrefix, false));
                    }
                    stringBuffer.append(HTMLSDOMGenerator.htmlencode(HTMLSDOMGenerator.fnencode(string2.toLowerCase()) + "/" + HTMLSDOMGenerator.fnencode(string3.toLowerCase()) + ".html", true));
                    stringBuffer.append("\">");
                }
                if (bl3) {
                    stringBuffer.append(HTMLSDOMGenerator.htmlencode(string3, false));
                } else {
                    for (Span span12 : (Anchor)span) {
                        this.generateSpanHTML(stringBuffer, span12);
                    }
                }
                if (bl4 && !bl) {
                    stringBuffer.append("</a>");
                }
                if (bl2) {
                    stringBuffer.append("</code>");
                }
            } else {
                stringBuffer.append("<a href=\"");
                stringBuffer.append(HTMLSDOMGenerator.htmlencode(string, true));
                stringBuffer.append("\">");
                for (Span span13 : (Anchor)span) {
                    this.generateSpanHTML(stringBuffer, span13);
                }
                stringBuffer.append("</a>");
            }
        } else if (span instanceof If) {
            DialectSpecList dialectSpecList = new DialectSpecList(((If)span).getCondition());
            if (this.currentDialectCode != null && this.currentDialectVersion != null && dialectSpecList.matches(this.currentDialectCode, this.currentDialectVersion)) {
                for (Span span14 : (If)span) {
                    if (span14 instanceof Else) continue;
                    this.generateSpanHTML(stringBuffer, span14);
                }
            } else {
                for (Span span15 : (If)span) {
                    if (!(span15 instanceof Else)) continue;
                    this.generateSpanHTML(stringBuffer, span15);
                }
            }
        } else if (span instanceof Else) {
            for (Span span16 : (Else)span) {
                this.generateSpanHTML(stringBuffer, span16);
            }
        } else if (span instanceof Break) {
            stringBuffer.append("<br/>");
        } else if (span instanceof DialectName) {
            if (this.currentDialectTitle != null) {
                stringBuffer.append(HTMLSDOMGenerator.htmlencode(this.currentDialectTitle, true));
            }
        } else if (span instanceof DialectVersion) {
            if (this.currentDialectVersion != null) {
                stringBuffer.append(HTMLSDOMGenerator.htmlencode(this.currentDialectVersion.toString(), true));
            }
        } else if (span instanceof TermName && this.currentTermName != null) {
            stringBuffer.append("<code>");
            stringBuffer.append(HTMLSDOMGenerator.htmlencode(this.currentTermName, true));
            stringBuffer.append("</code>");
        }
    }

    private static String htmlencode(String string, boolean bl) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    break;
                }
                case '\u00a0': {
                    stringBuffer.append("&nbsp;");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                        stringBuffer.append(" ");
                        break;
                    }
                    if (c >= '\u00a0') {
                        stringBuffer.append("&#" + c + ";");
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        if (bl) {
            return stringBuffer.toString().trim().replaceAll("\\s+", " ");
        }
        return stringBuffer.toString().replaceAll("\\s+", " ");
    }

    private static String fnencode(String string) {
        boolean bl = false;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string.toLowerCase());
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c > ' ' && c < '\u007f' && Character.isLetterOrDigit(c)) {
                bl = true;
                break;
            }
            c = stringCharacterIterator.next();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringCharacterIterator = new StringCharacterIterator(string.toLowerCase());
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (c2 > ' ' && c2 < '\u007f' && Character.isLetterOrDigit(c2)) {
                stringBuffer.append(c2);
            } else if (bl && (c2 == ' ' || c2 == '-' || c2 == '_' || c2 == '.' || c2 == '\'')) {
                stringBuffer.append('_');
            } else {
                String string2 = "0000" + Integer.toHexString(c2).toUpperCase();
                stringBuffer.append('$');
                stringBuffer.append(string2.substring(string2.length() - 4));
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

