/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc;

import com.kreative.xiondoc.XIONDocReader;
import com.kreative.xiondoc.XMLXDOMParser;
import com.kreative.xiondoc.xdom.DocumentationSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLReader
implements XIONDocReader {
    private XMLXDOMParser p = new XMLXDOMParser(true);

    public String derive(File file) {
        String string = file.getAbsolutePath();
        while (string.endsWith(".xnd") || string.endsWith(".xml")) {
            string = string.substring(0, string.length() - 4);
        }
        return string;
    }

    public void read(String string, DocumentationSet documentationSet) throws IOException {
        try {
            System.out.println("Parsing XML document...");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new XIONDocEntityResolver());
            documentBuilder.setErrorHandler(new XIONDocErrorHandler());
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            System.out.println("Traversing XML document...");
            this.p.parseDocument(document, documentationSet);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    private static class XIONDocErrorHandler
    implements ErrorHandler {
        private XIONDocErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            System.out.println("ERROR on " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.out.println("FATAL ERROR on " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.out.println("WARNING on " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
    }

    private static class XIONDocEntityResolver
    implements EntityResolver {
        private XIONDocEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2.contains("xiondoc-1.3.dtd")) {
                URL uRL = XMLReader.class.getResource("xiondoc-1.3.dtd");
                URLConnection uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                return new InputSource(inputStream);
            }
            return null;
        }
    }
}

