/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import com.kreative.xiondoc.xdom.VersionNumber;
import com.kreative.xiondoc.xdom.VersionNumberRange;
import java.io.Serializable;

public class DialectSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private VersionNumberRange versions;

    public DialectSpec(String string, VersionNumberRange versionNumberRange) {
        this.name = string;
        this.versions = versionNumberRange;
    }

    public DialectSpec(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && Character.isLetter(string.charAt(n)); ++n) {
        }
        this.name = string.substring(0, n);
        this.versions = new VersionNumberRange(string.substring(n).trim());
    }

    public String getName() {
        return this.name;
    }

    public VersionNumberRange getVersions() {
        return this.versions;
    }

    public boolean matches(String string, VersionNumber versionNumber) {
        return !(string != null && !this.name.equalsIgnoreCase(string) || versionNumber != null && !this.versions.contains(versionNumber));
    }

    public String toString() {
        return this.name + " " + this.versions.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof DialectSpec) {
            DialectSpec dialectSpec = (DialectSpec)object;
            return this.name.equalsIgnoreCase(dialectSpec.name) && this.versions.equals(dialectSpec.versions);
        }
        return false;
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode() ^ this.versions.hashCode();
    }
}

