/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import com.kreative.xiondoc.sdom.Section;
import com.kreative.xiondoc.xdom.Descriptor;
import com.kreative.xiondoc.xdom.Precedence;
import com.kreative.xiondoc.xdom.TermName;
import com.kreative.xiondoc.xdom.TermNameList;
import com.kreative.xiondoc.xdom.TermSpec;
import com.kreative.xiondoc.xdom.TermSpecList;
import com.kreative.xiondoc.xdom.TermType;
import com.kreative.xiondoc.xdom.VersionNumber;
import java.io.Serializable;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Term
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TermType type;
    private TermNameList names;
    private Section appliesTo;
    private Precedence precedence;
    private String descriptionShort;
    private TermSpec dataType;
    private String dataValue;
    private Section syntax;
    private Section examples;
    private Section description;
    private EnumSet<Descriptor> descriptors;
    private TermSpecList properties;
    private Section scripts;
    private Section notes;
    private Section security;
    private Section compatibility;
    private TermSpecList seeAlso;

    public Term(TermType termType) {
        this.type = termType;
        this.names = new TermNameList();
        this.appliesTo = null;
        this.precedence = null;
        this.descriptionShort = null;
        this.dataType = null;
        this.dataValue = null;
        this.syntax = null;
        this.examples = null;
        this.description = null;
        this.descriptors = EnumSet.noneOf(Descriptor.class);
        this.properties = new TermSpecList();
        this.scripts = null;
        this.notes = null;
        this.security = null;
        this.compatibility = null;
        this.seeAlso = new TermSpecList();
    }

    public TermType type() {
        return this.type;
    }

    public TermNameList names() {
        return this.names;
    }

    public boolean hasAppliesTo() {
        return this.appliesTo != null && !this.appliesTo.isEmpty();
    }

    public Section getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(Section section) {
        this.appliesTo = section;
    }

    public void appendAppliesTo(Section section) {
        if (this.appliesTo == null) {
            this.appliesTo = section;
        } else {
            this.appliesTo.addAll(section);
        }
    }

    public boolean hasPrecedence() {
        return this.precedence != null && this.precedence != Precedence.NULL;
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Precedence precedence) {
        this.precedence = precedence;
    }

    public boolean hasDescriptionShort() {
        return this.descriptionShort != null && this.descriptionShort.length() > 0;
    }

    public String getDescriptionShort() {
        return this.descriptionShort;
    }

    public void setDescriptionShort(String string) {
        this.descriptionShort = string;
    }

    public void appendDescriptionShort(String string) {
        this.descriptionShort = this.descriptionShort == null ? string : this.descriptionShort + " " + string;
    }

    public boolean hasDataType() {
        return this.dataType != null;
    }

    public TermSpec getDataType() {
        return this.dataType;
    }

    public void setDataType(TermSpec termSpec) {
        this.dataType = termSpec;
    }

    public boolean hasDataValue() {
        return this.dataValue != null && this.dataValue.length() > 0;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(String string) {
        this.dataValue = string;
    }

    public boolean hasSyntax() {
        return this.syntax != null && !this.syntax.isEmpty();
    }

    public Section getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Section section) {
        this.syntax = section;
    }

    public void appendSyntax(Section section) {
        if (this.syntax == null) {
            this.syntax = section;
        } else {
            this.syntax.addAll(section);
        }
    }

    public boolean hasExamples() {
        return this.examples != null && !this.examples.isEmpty();
    }

    public Section getExamples() {
        return this.examples;
    }

    public void setExamples(Section section) {
        this.examples = section;
    }

    public void appendExamples(Section section) {
        if (this.examples == null) {
            this.examples = section;
        } else {
            this.examples.addAll(section);
        }
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Section getDescription() {
        return this.description;
    }

    public void setDescription(Section section) {
        this.description = section;
    }

    public void appendDescription(Section section) {
        if (this.description == null) {
            this.description = section;
        } else {
            this.description.addAll(section);
        }
    }

    public EnumSet<Descriptor> descriptors() {
        return this.descriptors;
    }

    public TermSpecList properties() {
        return this.properties;
    }

    public boolean hasScripts() {
        return this.scripts != null && !this.scripts.isEmpty();
    }

    public Section getScripts() {
        return this.scripts;
    }

    public void setScripts(Section section) {
        this.scripts = section;
    }

    public void appendScripts(Section section) {
        if (this.scripts == null) {
            this.scripts = section;
        } else {
            this.scripts.addAll(section);
        }
    }

    public boolean hasNotes() {
        return this.notes != null && !this.notes.isEmpty();
    }

    public Section getNotes() {
        return this.notes;
    }

    public void setNotes(Section section) {
        this.notes = section;
    }

    public void appendNotes(Section section) {
        if (this.notes == null) {
            this.notes = section;
        } else {
            this.notes.addAll(section);
        }
    }

    public boolean hasSecurity() {
        return this.security != null && !this.security.isEmpty();
    }

    public Section getSecurity() {
        return this.security;
    }

    public void setSecurity(Section section) {
        this.security = section;
    }

    public void appendSecurity(Section section) {
        if (this.security == null) {
            this.security = section;
        } else {
            this.security.addAll(section);
        }
    }

    public boolean hasCompatibility() {
        return this.compatibility != null && !this.compatibility.isEmpty();
    }

    public Section getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(Section section) {
        this.compatibility = section;
    }

    public void appendCompatibility(Section section) {
        if (this.compatibility == null) {
            this.compatibility = section;
        } else {
            this.compatibility.addAll(section);
        }
    }

    public boolean hasSynonyms(String string, VersionNumber versionNumber) {
        if (this.names == null || this.names.isEmpty()) {
            return false;
        }
        int n = 0;
        for (TermName termName : this.names) {
            if (string != null && !termName.getDialects().matches(string, versionNumber)) continue;
            ++n;
        }
        return n > 1;
    }

    public TermSpecList getSynonyms(String string, VersionNumber versionNumber, String string2) {
        if (this.names == null || this.names.isEmpty()) {
            return new TermSpecList();
        }
        TermSpecList termSpecList = new TermSpecList();
        for (TermName termName : this.names) {
            if (string != null && !termName.getDialects().matches(string, versionNumber) || string2 != null && termName.getName().equalsIgnoreCase(string2)) continue;
            termSpecList.add(new TermSpec(this.type, termName.getName()));
        }
        return termSpecList;
    }

    public TermSpecList seeAlso() {
        return this.seeAlso;
    }
}

