/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import com.kreative.xiondoc.xdom.DialectSpec;
import com.kreative.xiondoc.xdom.Term;
import com.kreative.xiondoc.xdom.TermName;
import com.kreative.xiondoc.xdom.TermType;
import com.kreative.xiondoc.xdom.VersionNumber;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Term> allTerms = new HashSet<Term>();
    private Map<TermType, Set<Term>> termsByType = new HashMap<TermType, Set<Term>>();
    private Map<String, Set<Term>> termsByName = new HashMap<String, Set<Term>>();
    private Map<String, Set<Term>> termsByDialect = new HashMap<String, Set<Term>>();

    public void addTerm(Term term) {
        this.allTerms.add(term);
        if (this.termsByType.containsKey((Object)term.type())) {
            this.termsByType.get((Object)term.type()).add(term);
        } else {
            HashSet<Term> hashSet = new HashSet<Term>();
            hashSet.add(term);
            this.termsByType.put(term.type(), hashSet);
        }
        for (TermName termName : term.names()) {
            String string = termName.getName().toLowerCase();
            if (this.termsByName.containsKey(string)) {
                this.termsByName.get(string).add(term);
            } else {
                HashSet<Term> hashSet = new HashSet<Term>();
                hashSet.add(term);
                this.termsByName.put(string, hashSet);
            }
            for (DialectSpec dialectSpec : termName.getDialects()) {
                String string2 = dialectSpec.getName().toLowerCase();
                if (this.termsByDialect.containsKey(string2)) {
                    this.termsByDialect.get(string2).add(term);
                    continue;
                }
                HashSet<Term> hashSet = new HashSet<Term>();
                hashSet.add(term);
                this.termsByDialect.put(string2, hashSet);
            }
        }
    }

    public Collection<Term> getTerms(TermType termType, String string, String string2, VersionNumber versionNumber) {
        HashSet<Term> hashSet = new HashSet<Term>();
        if (termType != null) {
            if (this.termsByType.containsKey((Object)termType)) {
                hashSet.addAll((Collection)this.termsByType.get((Object)termType));
            }
            if (string != null) {
                if (this.termsByName.containsKey(string = string.toLowerCase())) {
                    hashSet.retainAll((Collection)this.termsByName.get(string));
                } else {
                    hashSet.clear();
                }
            }
            if (string2 != null) {
                if (this.termsByDialect.containsKey(string2 = string2.toLowerCase())) {
                    hashSet.retainAll((Collection)this.termsByDialect.get(string2));
                } else {
                    hashSet.clear();
                }
            }
        } else if (string != null) {
            if (this.termsByName.containsKey(string = string.toLowerCase())) {
                hashSet.addAll((Collection<Term>)this.termsByName.get(string));
            }
            if (string2 != null) {
                if (this.termsByDialect.containsKey(string2 = string2.toLowerCase())) {
                    hashSet.retainAll((Collection)this.termsByDialect.get(string2));
                } else {
                    hashSet.clear();
                }
            }
        } else if (string2 != null) {
            if (this.termsByDialect.containsKey(string2 = string2.toLowerCase())) {
                hashSet.addAll((Collection<Term>)this.termsByDialect.get(string2));
            }
        } else {
            hashSet.addAll(this.allTerms);
        }
        if (versionNumber != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Term term = (Term)iterator.next();
                boolean bl = false;
                for (TermName termName : term.names()) {
                    if (string != null && !string.equalsIgnoreCase(termName.getName())) continue;
                    for (DialectSpec dialectSpec : termName.getDialects()) {
                        if (!dialectSpec.matches(string2, versionNumber)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
                if (bl) continue;
                iterator.remove();
            }
        }
        return hashSet;
    }
}

