/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import com.kreative.xiondoc.xdom.TermType;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermSpec
implements Serializable,
Comparable<TermSpec> {
    private static final long serialVersionUID = 1L;
    private TermType type;
    private String name;

    public TermSpec(TermType termType, String string) {
        this.type = termType;
        this.name = string;
    }

    public TermSpec(String string) {
        String[] stringArray = string.split(":", 2);
        if (stringArray.length >= 2) {
            this.type = TermType.forCode(stringArray[0].trim());
            this.name = stringArray[1].trim();
        } else {
            this.type = TermType.FUNCTION;
            this.name = string.trim();
        }
    }

    public TermSpec(String string, TermType termType) {
        String[] stringArray = string.split(":", 2);
        if (stringArray.length >= 2) {
            this.type = TermType.forCode(stringArray[0].trim());
            this.name = stringArray[1].trim();
        } else {
            this.type = termType;
            this.name = string.trim();
        }
    }

    public TermType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.type.getCode() + ":" + this.name;
    }

    @Override
    public int compareTo(TermSpec termSpec) {
        boolean bl;
        int n = this.type.compareTo(termSpec.type);
        if (n != 0) {
            return n;
        }
        String string = this.name;
        String string2 = termSpec.name;
        boolean bl2 = string.length() > 0 && Character.isLetterOrDigit(string.charAt(0));
        boolean bl3 = bl = string2.length() > 0 && Character.isLetterOrDigit(string2.charAt(0));
        if (bl2 == bl) {
            return string.compareToIgnoreCase(string2);
        }
        if (bl2) {
            return -1;
        }
        if (bl) {
            return 1;
        }
        return string.compareToIgnoreCase(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof TermSpec) {
            TermSpec termSpec = (TermSpec)object;
            return this.type == termSpec.type && this.name.equalsIgnoreCase(termSpec.name);
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.name.toLowerCase().hashCode();
    }
}

