/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class XNLexer {
    private static final int LOOKAHEAD_LIMIT = 65536;
    private Object source;
    private XNReader reader;
    private Vector<XNToken> buffer;
    private XNToken lastToken;

    public XNLexer(Object object, Reader reader) {
        this.source = object;
        this.reader = new XNReader(reader);
        this.buffer = new Vector();
        this.lastToken = null;
    }

    private static boolean isNumStart(int n) {
        return n == 46 || Character.isDigit(n);
    }

    private static boolean isNumPart(int n) {
        return n == 46 || n == 39 || Character.isDigit(n);
    }

    private static boolean isIdStart(int n) {
        int n2 = Character.getType(n);
        return n == 39 || Character.isLetter(n) || n2 == 6 || n2 == 8 || n2 == 18 || n2 == 23;
    }

    private static boolean isIdPart(int n) {
        int n2 = Character.getType(n);
        return n == 46 || n == 39 || Character.isDigit(n) || Character.isLetter(n) || n2 == 6 || n2 == 8 || n2 == 18 || n2 == 23;
    }

    private static boolean isLineTerm(int n) {
        return n < 0 || n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    private static boolean isWhiteSpace(int n) {
        return n <= 32 || n >= 127 && n <= 160 || Character.isSpaceChar(n);
    }

    private XNToken internalGetNextToken1() throws IOException {
        this.reader.mark(65536);
        int n = this.reader.read();
        int n2 = 1;
        if (XNLexer.isLineTerm(n)) {
            if (n < 0) {
                return new XNToken(0, "", this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getMarkedLine(), this.reader.getMarkedCol());
            }
            int n3 = n;
            while (n3 >= 0 && XNLexer.isLineTerm(n3 = this.reader.read())) {
                ++n2;
            }
            char[] cArray = new char[n2];
            this.reader.reset();
            this.reader.read(cArray);
            return new XNToken(0, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (n == 34) {
            int n4;
            while (!XNLexer.isLineTerm(n4 = this.reader.read())) {
                ++n2;
                if (n4 == 34) break;
                if (n4 != 92) continue;
                n4 = this.reader.read();
                if (XNLexer.isLineTerm(n4)) break;
                ++n2;
            }
            char[] cArray = new char[n2];
            this.reader.reset();
            this.reader.read(cArray);
            return new XNToken(1, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (XNLexer.isNumStart(n)) {
            while (XNLexer.isNumPart(this.reader.read())) {
                ++n2;
            }
            char[] cArray = new char[n2];
            this.reader.reset();
            this.reader.read(cArray);
            return new XNToken(2, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (XNLexer.isIdStart(n)) {
            while (XNLexer.isIdPart(this.reader.read())) {
                ++n2;
            }
            char[] cArray = new char[n2];
            this.reader.reset();
            this.reader.read(cArray);
            return new XNToken(3, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (n == 35 || n == 8212 || n == 8213) {
            while (!XNLexer.isLineTerm(this.reader.read())) {
                ++n2;
            }
            char[] cArray = new char[n2];
            this.reader.reset();
            this.reader.read(cArray);
            return new XNToken(5, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (n == 45 || n == 47) {
            int n5 = this.reader.read();
            ++n2;
            if (n == n5) {
                while (!XNLexer.isLineTerm(this.reader.read())) {
                    ++n2;
                }
                char[] cArray = new char[n2];
                this.reader.reset();
                this.reader.read(cArray);
                return new XNToken(5, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
            }
            this.reader.reset();
            this.reader.read();
            return new XNToken(4, new String(Character.toChars(n)), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (n == 8734 || n == 126) {
            int n6 = this.reader.read();
            ++n2;
            if (n == n6) {
                int n7 = n;
                int n8 = n6;
                while (n7 == n && n8 == n) {
                    n7 = n8;
                    n8 = this.reader.read();
                    ++n2;
                }
                while (n7 >= 0 && n7 != n || n8 >= 0 && n8 != n) {
                    n7 = n8;
                    n8 = this.reader.read();
                    ++n2;
                }
                while (this.reader.read() == n) {
                    ++n2;
                }
                char[] cArray = new char[n2];
                this.reader.reset();
                this.reader.read(cArray);
                return new XNToken(5, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
            }
            this.reader.reset();
            this.reader.read();
            return new XNToken(4, new String(Character.toChars(n)), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (n == 172 || n == 92) {
            int n9;
            do {
                n9 = this.reader.read();
                ++n2;
                if (!XNLexer.isLineTerm(n9)) continue;
                while (n9 >= 0 && XNLexer.isLineTerm(n9 = this.reader.read())) {
                    ++n2;
                }
                char[] cArray = new char[n2];
                this.reader.reset();
                this.reader.read(cArray);
                return new XNToken(6, new String(cArray), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
            } while (XNLexer.isWhiteSpace(n9));
            this.reader.reset();
            this.reader.read();
            return new XNToken(4, new String(Character.toChars(n)), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        if (XNLexer.isWhiteSpace(n)) {
            return new XNToken(7, new String(Character.toChars(n)), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
        }
        return new XNToken(4, new String(Character.toChars(n)), this.source, this.reader.getMarkedLine(), this.reader.getMarkedCol(), this.reader.getLine(), this.reader.getCol());
    }

    private XNToken internalGetNextToken2() throws IOException {
        XNToken xNToken = this.internalGetNextToken1();
        while (xNToken.kind == 5 || xNToken.kind == 6 || xNToken.kind == 7) {
            XNToken xNToken2 = this.internalGetNextToken1();
            xNToken2.specialToken = xNToken;
            xNToken = xNToken2;
        }
        return xNToken;
    }

    public XNToken getToken() throws IOException {
        XNToken xNToken;
        XNToken xNToken2 = xNToken = !this.buffer.isEmpty() ? this.buffer.remove(0) : this.internalGetNextToken2();
        if (this.lastToken != null) {
            this.lastToken.next = xNToken;
        }
        this.lastToken = xNToken;
        return xNToken;
    }

    public XNToken lookToken(int n) throws IOException {
        if (n < 1) {
            return this.lastToken;
        }
        while (this.buffer.size() < n) {
            this.buffer.add(this.internalGetNextToken2());
        }
        return this.buffer.get(n - 1);
    }

    public Object getSource() {
        return this.source;
    }

    public int getCurrentLine() {
        return this.reader.getLine();
    }

    public int getCurrentCol() {
        return this.reader.getCol();
    }

    private static class XNReader
    extends BufferedReader {
        private static final int SKIP_BUFFER_SIZE = 65536;
        private int line = 1;
        private int col = 1;
        private int mline = 1;
        private int mcol = 1;
        private boolean lastCR = false;
        private boolean mlastCR = false;

        public XNReader(Reader reader) {
            super(reader);
        }

        public XNReader(Reader reader, int n) {
            super(reader, n);
        }

        public void mark(int n) throws IOException {
            super.mark(n);
            this.mline = this.line;
            this.mcol = this.col;
            this.mlastCR = this.lastCR;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n == 8232 || n == 8233) {
                ++this.line;
                this.col = 1;
                this.lastCR = false;
            } else if (n == 13) {
                ++this.line;
                this.col = 1;
                this.lastCR = true;
            } else if (n == 10) {
                if (!this.lastCR) {
                    ++this.line;
                }
                this.col = 1;
                this.lastCR = false;
            } else {
                ++this.col;
                this.lastCR = false;
            }
            return n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = super.read(cArray, n, n2);
            int n4 = n;
            for (int i = 0; i < n3; ++i) {
                if (cArray[n4] == '\u2028' || cArray[n4] == '\u2029') {
                    ++this.line;
                    this.col = 1;
                    this.lastCR = false;
                } else if (cArray[n4] == '\r') {
                    ++this.line;
                    this.col = 1;
                    this.lastCR = true;
                } else if (cArray[n4] == '\n') {
                    if (!this.lastCR) {
                        ++this.line;
                    }
                    this.col = 1;
                    this.lastCR = false;
                } else {
                    ++this.col;
                    this.lastCR = false;
                }
                ++n4;
            }
            return n3;
        }

        public String readLine() throws IOException {
            String string = super.readLine();
            ++this.line;
            this.col = 1;
            this.lastCR = false;
            return string;
        }

        public void reset() throws IOException {
            super.reset();
            this.line = this.mline;
            this.col = this.mcol;
            this.lastCR = this.mlastCR;
        }

        public long skip(long l) throws IOException {
            long l2 = 0L;
            char[] cArray = new char[65536];
            while (l > 65536L) {
                l2 += (long)this.read(cArray, 0, 65536);
                l -= 65536L;
            }
            return l2 += (long)this.read(cArray, 0, (int)l);
        }

        public int getMarkedLine() {
            return this.mline;
        }

        public int getMarkedCol() {
            return this.mcol;
        }

        public int getLine() {
            return this.line;
        }

        public int getCol() {
            return this.col;
        }
    }
}

