/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNLexer;
import com.kreative.openxion.XNParser;
import com.kreative.openxion.ast.XNFunctionCallPropertyDescriptor;
import com.kreative.openxion.ast.XNListExpression;
import com.kreative.openxion.ast.XNStatement;
import com.kreative.openxion.ast.XNStringExpression;
import com.kreative.openxion.util.XIONUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNMessageExtractor {
    private XNContext context;
    private String textEncoding;

    public XNMessageExtractor(XNContext xNContext, String string) {
        this.context = xNContext;
        this.textEncoding = string;
    }

    public Map<String, List<XNStringExpression>> extractFromFile(File file, String string) throws IOException {
        XNLexer xNLexer = new XNLexer(file, new InputStreamReader((InputStream)new FileInputStream(file), string));
        XNParser xNParser = new XNParser(this.context, xNLexer);
        List<XNStatement> list = xNParser.parse();
        return this.extractFrom(list);
    }

    public Map<String, List<XNStringExpression>> extractFromString(String string) {
        XNLexer xNLexer = new XNLexer(string, new StringReader(string));
        XNParser xNParser = new XNParser(this.context, xNLexer);
        List<XNStatement> list = xNParser.parse();
        return this.extractFrom(list);
    }

    public Map<String, List<XNStringExpression>> extractFrom(List<XNStatement> list) {
        LinkedHashMap<String, List<XNStringExpression>> linkedHashMap = new LinkedHashMap<String, List<XNStringExpression>>();
        for (XNStatement xNStatement : list) {
            this.extractFrom(xNStatement, linkedHashMap);
        }
        return linkedHashMap;
    }

    private void extractFrom(Object object, Map<String, List<XNStringExpression>> map) {
        Object object2;
        Object object4;
        if (object == null) {
            return;
        }
        if (object instanceof XNFunctionCallPropertyDescriptor) {
            object4 = (Object[])object;
            if (((XNFunctionCallPropertyDescriptor)object4).identifier.equals("'")) {
                Object object3;
                if (((XNFunctionCallPropertyDescriptor)object4).argument instanceof XNStringExpression) {
                    XNStringExpression object32 = (XNStringExpression)((XNFunctionCallPropertyDescriptor)object4).argument;
                    object2 = XIONUtil.unquote(object32.literal.image, this.textEncoding);
                    if (map.containsKey(object2)) {
                        map.get(object2).add(object32);
                    } else {
                        object3 = new LinkedList<XNStringExpression>();
                        object3.add(object32);
                        map.put((String)object2, (List<XNStringExpression>)object3);
                    }
                } else if (((XNFunctionCallPropertyDescriptor)object4).argument instanceof XNListExpression) {
                    XNListExpression xNListExpression = (XNListExpression)((XNFunctionCallPropertyDescriptor)object4).argument;
                    if (xNListExpression.exprs.size() > 0 && xNListExpression.exprs.get(0) instanceof XNStringExpression) {
                        object2 = (XNStringExpression)xNListExpression.exprs.get(0);
                        object3 = XIONUtil.unquote(((XNStringExpression)object2).literal.image, this.textEncoding);
                        if (map.containsKey(object3)) {
                            map.get(object3).add((XNStringExpression)object2);
                        } else {
                            LinkedList<Object> linkedList = new LinkedList<Object>();
                            linkedList.add(object2);
                            map.put((String)object3, linkedList);
                        }
                    }
                }
            }
        }
        if (object instanceof Object[]) {
            for (Object object3 : (Object[])object) {
                this.extractFrom(object3, map);
            }
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.extractFrom(e, map);
            }
        } else if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                object2 = entry;
                this.extractFrom(object2.getValue(), map);
            }
        } else {
            object4 = object.getClass();
            while (((Class)object4).getSimpleName().startsWith("XN")) {
                Field[] fieldArray = ((Class)object4).getDeclaredFields();
                for (Field field : fieldArray) {
                    if (Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                    try {
                        field.setAccessible(true);
                        this.extractFrom(field.get(object), map);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                object4 = ((Class)object4).getSuperclass();
            }
        }
    }
}

