/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.ast;

import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNExpression;
import com.kreative.openxion.ast.XNOperator;

public class XNBetweenExpression
extends XNExpression {
    private static final long serialVersionUID = 130L;
    public XNExpression left;
    public XNOperator operator;
    public XNExpression rightStart;
    public XNToken andToken;
    public XNExpression rightEnd;
    public XNToken[] options;

    public XNBetweenExpression(XNExpression xNExpression, XNOperator xNOperator, XNExpression xNExpression2, XNToken xNToken, XNExpression xNExpression3, XNToken[] xNTokenArray) {
        this.left = xNExpression;
        this.operator = xNOperator;
        this.rightStart = xNExpression2;
        this.andToken = xNToken;
        this.rightEnd = xNExpression3;
        this.options = xNTokenArray;
    }

    public Object getSource() {
        return this.left.getSource();
    }

    public int getBeginCol() {
        return this.left.getBeginCol();
    }

    public int getBeginLine() {
        return this.left.getBeginLine();
    }

    public int getEndCol() {
        if (this.options != null && this.options.length > 0) {
            return this.options[this.options.length - 1].endColumn;
        }
        return this.rightEnd.getEndCol();
    }

    public int getEndLine() {
        if (this.options != null && this.options.length > 0) {
            return this.options[this.options.length - 1].endLine;
        }
        return this.rightEnd.getEndLine();
    }

    private String optionString() {
        String string = "";
        if (this.options != null) {
            for (XNToken xNToken : this.options) {
                string = string + xNToken.image.toLowerCase();
            }
        }
        return string;
    }

    public boolean isLeftInclusive() {
        String string = this.optionString();
        return string.startsWith("inc") || string.startsWith("left") || string.equals("");
    }

    public boolean isRightInclusive() {
        String string = this.optionString();
        return string.startsWith("inc") || string.startsWith("right") || string.equals("");
    }

    public String toString() {
        String string = "( " + this.left + " " + (Object)((Object)this.operator) + " " + this.rightStart + " " + this.andToken.image.toLowerCase() + " " + this.rightEnd;
        if (this.options != null) {
            for (XNToken xNToken : this.options) {
                string = string + " " + xNToken.image.trim().toLowerCase();
            }
        }
        return string + " )";
    }
}

