/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.ast;

import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNHandlerParameter;
import com.kreative.openxion.ast.XNStatement;
import java.util.List;

public class XNFunctionHandler
extends XNStatement {
    private static final long serialVersionUID = 118L;
    public XNToken functionToken;
    public String name;
    public List<XNHandlerParameter> parameters;
    public List<XNStatement> body;
    public XNToken endFunctionToken;

    public int getFunctionLine() {
        if (this.functionToken == null) {
            return 0;
        }
        return this.functionToken.beginLine;
    }

    public int getFunctionCol() {
        if (this.functionToken == null) {
            return 0;
        }
        return this.functionToken.beginColumn;
    }

    public int getEndFunctionLine() {
        if (this.endFunctionToken == null) {
            return 0;
        }
        return this.endFunctionToken.beginLine;
    }

    public int getEndFunctionCol() {
        if (this.endFunctionToken == null) {
            return 0;
        }
        return this.endFunctionToken.beginColumn;
    }

    protected String toString(String string) {
        String string2 = string + "function " + this.name;
        if (this.parameters != null && this.parameters.size() > 0) {
            for (XNHandlerParameter cloneable : this.parameters) {
                string2 = string2 + " " + cloneable.toString() + ",";
            }
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (this.body != null) {
            for (XNStatement xNStatement : this.body) {
                string2 = string2 + "\n" + xNStatement.toString(string + "\t");
            }
        }
        string2 = string2 + "\n" + string + "end " + this.name;
        return string2;
    }
}

