/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.audio;

import com.kreative.openxion.audio.Speaker;
import java.beans.PropertyVetoException;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.SpeakableEvent;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class JSAPISpeaker
implements Speaker,
SpeakableListener {
    private Synthesizer synth = Central.createSynthesizer((EngineModeDesc)new SynthesizerModeDesc(null, "general", null, null, null));
    private SynthesizerModeDesc smd;
    private boolean speaking;
    private String text;

    public JSAPISpeaker() throws AudioException, EngineException {
        this.synth.allocate();
        this.synth.resume();
        this.synth.addSpeakableListener((SpeakableListener)this);
        this.smd = (SynthesizerModeDesc)this.synth.getEngineModeDesc();
        this.speaking = false;
        this.text = "";
    }

    protected void finalize() throws EngineException {
        this.synth.cancelAll();
        this.synth.deallocate();
    }

    public String[] getVoices() {
        Voice[] voiceArray = this.smd.getVoices();
        String[] stringArray = new String[voiceArray.length];
        for (int i = 0; i < voiceArray.length; ++i) {
            stringArray[i] = voiceArray[i].getName();
        }
        return stringArray;
    }

    public String getDefaultVoice() {
        Voice[] voiceArray = this.smd.getVoices();
        return voiceArray[0].getName();
    }

    public String getMaleVoice() {
        Voice[] voiceArray;
        for (Voice voice : voiceArray = this.smd.getVoices()) {
            if (voice.getGender() != 2) continue;
            return voice.getName();
        }
        return voiceArray[0].getName();
    }

    public String getFemaleVoice() {
        Voice[] voiceArray;
        for (Voice voice : voiceArray = this.smd.getVoices()) {
            if (voice.getGender() != 1) continue;
            return voice.getName();
        }
        return voiceArray[0].getName();
    }

    public String getNeuterVoice() {
        Voice[] voiceArray;
        for (Voice voice : voiceArray = this.smd.getVoices()) {
            if (voice.getGender() != 4) continue;
            return voice.getName();
        }
        return voiceArray[0].getName();
    }

    public boolean hasVoice(String string) {
        Voice[] voiceArray;
        for (Voice voice : voiceArray = this.smd.getVoices()) {
            if (!voice.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void speak(String string) {
        this.synth.speakPlainText(string, null);
    }

    public void speak(String string, String string2) {
        try {
            Voice[] voiceArray;
            for (Voice voice : voiceArray = this.smd.getVoices()) {
                if (!voice.getName().equalsIgnoreCase(string)) continue;
                this.synth.getSynthesizerProperties().setVoice(voice);
                break;
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        this.synth.speakPlainText(string2, null);
    }

    public boolean isSpeaking() {
        return this.speaking || this.synth.testEngineState(131072L);
    }

    public String getVoiceSpoken() {
        String string = this.synth.getSynthesizerProperties().getVoice().getName();
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.getDefaultVoice();
    }

    public String getPhonemeSpoken() {
        return this.text;
    }

    public String getPhraseSpoken() {
        return this.text;
    }

    public void finishSpeaking() {
        try {
            this.synth.waitEngineState(65536L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void stopSpeaking() {
        this.synth.cancelAll();
    }

    public void markerReached(SpeakableEvent speakableEvent) {
    }

    public void speakableCancelled(SpeakableEvent speakableEvent) {
        this.speaking = false;
    }

    public void speakableEnded(SpeakableEvent speakableEvent) {
        this.speaking = false;
    }

    public void speakablePaused(SpeakableEvent speakableEvent) {
    }

    public void speakableResumed(SpeakableEvent speakableEvent) {
    }

    public void speakableStarted(SpeakableEvent speakableEvent) {
        this.speaking = true;
        this.text = speakableEvent.getText() != null ? speakableEvent.getText() : speakableEvent.getSource().toString();
    }

    public void topOfQueue(SpeakableEvent speakableEvent) {
    }

    public void wordStarted(SpeakableEvent speakableEvent) {
    }
}

