/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.audio;

import com.kreative.openxion.audio.AudioDialer;
import com.kreative.openxion.audio.Toner;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class ToneGenerator
implements Toner,
AudioDialer {
    private float lastFreq = 0.0f;
    private float[] lastFreqs = null;
    private char lastButton = '\u0000';
    private char[] lastButtons = null;
    private String lastNumber = null;
    private Vector<Object> q = new Vector();
    private ToneGeneratorThread qt = null;

    public float getMinimumAmplitude() {
        return 0.0f;
    }

    public float getMaximumAmplitude() {
        return 32000.0f;
    }

    public synchronized void tone(long l, float f, float f2) {
        this.q.add(new PCMTone(new float[]{f2}, new float[]{f}, l));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new ToneGeneratorThread();
            this.qt.start();
        }
    }

    public synchronized void tone(long l, float[] fArray, float[] fArray2) {
        this.q.add(new PCMTone(fArray2, fArray, l));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new ToneGeneratorThread();
            this.qt.start();
        }
    }

    public synchronized boolean isToning() {
        return this.qt != null && this.qt.isAlive();
    }

    public synchronized float getFrequencyToned() {
        return this.lastFreq;
    }

    public synchronized float[] getFrequenciesToned() {
        return this.lastFreqs;
    }

    public synchronized void finishToning() {
        if (this.qt != null) {
            try {
                this.qt.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.qt = null;
        }
        this.q.clear();
    }

    public synchronized void stopToning() {
        if (this.qt != null) {
            this.qt.interrupt();
            this.qt = null;
        }
        this.q.clear();
    }

    public synchronized void dial(char c, long l, float f) {
        this.q.add(new PCMDialtoneString(new char[]{c}, f, l));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new ToneGeneratorThread();
            this.qt.start();
        }
    }

    public synchronized void dial(char[] cArray, long l, float f) {
        this.q.add(new PCMDialtoneString(cArray, f, l));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new ToneGeneratorThread();
            this.qt.start();
        }
    }

    public synchronized void dial(String string, long l, float f) {
        this.q.add(new PCMDialtoneString(string, f, l));
        if (this.qt == null || !this.qt.isAlive()) {
            this.qt = new ToneGeneratorThread();
            this.qt.start();
        }
    }

    public synchronized boolean isDialing() {
        return this.qt != null && this.qt.isAlive();
    }

    public synchronized char getButtonDialed() {
        return this.lastButton;
    }

    public synchronized char[] getButtonsDialed() {
        return this.lastButtons;
    }

    public synchronized String getNumberDialed() {
        return this.lastNumber;
    }

    public synchronized void finishDialing() {
        if (this.qt != null) {
            try {
                this.qt.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.qt = null;
        }
        this.q.clear();
    }

    public synchronized void stopDialing() {
        if (this.qt != null) {
            this.qt.interrupt();
            this.qt = null;
        }
        this.q.clear();
    }

    static /* synthetic */ char[] access$202(ToneGenerator toneGenerator, char[] cArray) {
        toneGenerator.lastButtons = cArray;
        return cArray;
    }

    static /* synthetic */ float[] access$502(ToneGenerator toneGenerator, float[] fArray) {
        toneGenerator.lastFreqs = fArray;
        return fArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PCMDialtoneString {
        private char[] buttons;
        private String number;
        private float amp;
        private long dur;

        public PCMDialtoneString(char[] cArray, float f, long l) {
            this.buttons = cArray;
            this.number = new String(cArray);
            this.amp = f;
            this.dur = l;
        }

        public PCMDialtoneString(String string, float f, long l) {
            string = string.replaceAll("[^0-9A-Da-d*#,]", "").toUpperCase();
            this.buttons = string.toCharArray();
            this.number = string;
            this.amp = f;
            this.dur = l;
        }

        public char[] buttons() {
            return this.buttons;
        }

        public String number() {
            return this.number;
        }

        public List<PCMDialtone> toList() {
            Vector<PCMDialtone> vector = new Vector<PCMDialtone>();
            for (char c : this.buttons) {
                vector.add(new PCMDialtone(c, this.amp, this.dur));
            }
            return vector;
        }
    }

    private static class PCMDialtone
    extends PCMTone {
        private char button;

        private static float[] dtmfFreq(char c) {
            switch (c) {
                case '0': {
                    return AudioDialer.DTMF_0;
                }
                case '1': {
                    return AudioDialer.DTMF_1;
                }
                case '2': {
                    return AudioDialer.DTMF_2;
                }
                case '3': {
                    return AudioDialer.DTMF_3;
                }
                case '4': {
                    return AudioDialer.DTMF_4;
                }
                case '5': {
                    return AudioDialer.DTMF_5;
                }
                case '6': {
                    return AudioDialer.DTMF_6;
                }
                case '7': {
                    return AudioDialer.DTMF_7;
                }
                case '8': {
                    return AudioDialer.DTMF_8;
                }
                case '9': {
                    return AudioDialer.DTMF_9;
                }
                case 'A': 
                case 'a': {
                    return AudioDialer.DTMF_A;
                }
                case 'B': 
                case 'b': {
                    return AudioDialer.DTMF_B;
                }
                case 'C': 
                case 'c': {
                    return AudioDialer.DTMF_C;
                }
                case 'D': 
                case 'd': {
                    return AudioDialer.DTMF_D;
                }
                case '*': {
                    return AudioDialer.DTMF_STAR;
                }
                case '#': {
                    return AudioDialer.DTMF_POUND;
                }
            }
            return AudioDialer.DTMF_NULL;
        }

        public PCMDialtone(char c, float f, long l) {
            super(PCMDialtone.dtmfFreq(c), new float[]{f, f}, l);
            this.button = c;
        }

        public char button() {
            return this.button;
        }
    }

    private static class PCMTone {
        private float[] freq;
        private float[] amp;
        private long dur;
        private int numTones;
        private long max;
        private byte[] stuff;
        private double[] m;

        public PCMTone(float[] fArray, float[] fArray2, long l) {
            this.freq = fArray;
            this.amp = fArray2;
            this.dur = l;
            this.numTones = Math.min(fArray.length, fArray2.length);
            this.max = l * 44100L / 1000L;
            this.stuff = new byte[this.numTones * 2];
            this.m = new double[this.numTones];
            for (int i = 0; i < this.numTones; ++i) {
                this.m[i] = Math.PI * 2 * (double)fArray[i] / 44100.0;
            }
        }

        public float frequency() {
            float f = 0.0f;
            for (float f2 : this.freq) {
                f += f2;
            }
            return f / (float)this.freq.length;
        }

        public float[] frequencies() {
            return this.freq;
        }

        public long duration() {
            return this.dur;
        }

        public PlayerThread makePlayerThread() throws LineUnavailableException {
            return new PlayerThread();
        }

        public class PlayerThread
        extends Thread {
            private static final int ENV = 100;
            private AudioFormat af;
            private SourceDataLine dl;
            private boolean stop;

            public PlayerThread() throws LineUnavailableException {
                this.af = new AudioFormat(44100.0f, 16, PCMTone.this.numTones, true, false);
                this.dl = AudioSystem.getSourceDataLine(this.af);
                this.dl.open(this.af);
                this.stop = false;
            }

            public void run() {
                this.dl.start();
                for (long i = 0L; i < PCMTone.this.max && !this.stop; ++i) {
                    int n = 0;
                    for (int j = 0; j < PCMTone.this.numTones; ++j) {
                        short s = (short)(Math.sin((double)i * PCMTone.this.m[j]) * (double)PCMTone.this.amp[j]);
                        if (i < 100L) {
                            s = (short)((long)s * i / 100L);
                        }
                        if (i > PCMTone.this.max - 100L) {
                            s = (short)((long)s * (PCMTone.this.max - i) / 100L);
                        }
                        ((PCMTone)PCMTone.this).stuff[n++] = (byte)(s & 0xFF);
                        ((PCMTone)PCMTone.this).stuff[n++] = (byte)(s >>> 8 & 0xFF);
                    }
                    this.dl.write(PCMTone.this.stuff, 0, PCMTone.this.stuff.length);
                }
            }

            public void end() {
                this.stop = true;
                this.dl.stop();
                this.dl.flush();
                this.dl.close();
            }
        }
    }

    private class ToneGeneratorThread
    extends Thread {
        private ToneGeneratorThread() {
        }

        public void run() {
            while (!Thread.interrupted() && !ToneGenerator.this.q.isEmpty()) {
                PCMTone.PlayerThread playerThread;
                Object e = ToneGenerator.this.q.remove(0);
                if (e instanceof PCMDialtoneString) {
                    ToneGenerator.access$202(ToneGenerator.this, ((PCMDialtoneString)e).buttons());
                    ToneGenerator.this.lastNumber = ((PCMDialtoneString)e).number();
                    ToneGenerator.this.q.addAll(0, ((PCMDialtoneString)e).toList());
                    continue;
                }
                if (e instanceof PCMDialtone) {
                    ToneGenerator.this.lastFreq = ((PCMDialtone)e).frequency();
                    ToneGenerator.access$502(ToneGenerator.this, ((PCMDialtone)e).frequencies());
                    ToneGenerator.this.lastButton = ((PCMDialtone)e).button();
                    try {
                        playerThread = ((PCMDialtone)e).makePlayerThread();
                        playerThread.start();
                        try {
                            Thread.sleep(((PCMDialtone)e).duration() + 50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        playerThread.end();
                        try {
                            playerThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        ToneGenerator.this.q.add(0, e);
                    }
                    continue;
                }
                if (!(e instanceof PCMTone)) continue;
                ToneGenerator.this.lastFreq = ((PCMTone)e).frequency();
                ToneGenerator.access$502(ToneGenerator.this, ((PCMTone)e).frequencies());
                try {
                    playerThread = ((PCMTone)e).makePlayerThread();
                    playerThread.start();
                    try {
                        Thread.sleep(((PCMTone)e).duration() + 50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    playerThread.end();
                    try {
                        playerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (LineUnavailableException lineUnavailableException) {
                    ToneGenerator.this.q.add(0, e);
                }
            }
        }
    }
}

