/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.audio;

import com.kreative.openxion.audio.AudioDialer;
import com.kreative.openxion.audio.MIDIPlayer;
import com.kreative.openxion.audio.MacSpeaker;
import com.kreative.openxion.audio.ModemDialer;
import com.kreative.openxion.audio.Player;
import com.kreative.openxion.audio.Speaker;
import com.kreative.openxion.audio.ToneGenerator;
import com.kreative.openxion.audio.Toner;
import com.kreative.openxion.util.XIONUtil;

public class XNAudioManager {
    private static XNAudioManager instance = null;
    private AudioDialer ad;
    private ModemDialer md;
    private Player[] p;
    private int pi;
    private Speaker s;
    private Toner[] t;
    private int ti;

    public static final synchronized XNAudioManager instance() {
        if (instance == null) {
            instance = new XNAudioManager();
        }
        return instance;
    }

    private XNAudioManager() {
        this.ad = new ToneGenerator();
        try {
            this.md = (ModemDialer)Class.forName("com.kreative.openxion.audio.RXTXDialer").newInstance();
        }
        catch (Throwable throwable) {
            try {
                this.md = (ModemDialer)Class.forName("com.kreative.openxion.audio.CommDialer").newInstance();
            }
            catch (Throwable throwable2) {
                this.md = null;
            }
        }
        this.p = new Player[]{new MIDIPlayer(), new MIDIPlayer(), new MIDIPlayer(), new MIDIPlayer(), new MIDIPlayer(), new MIDIPlayer(), new MIDIPlayer(), new MIDIPlayer()};
        this.pi = 0;
        try {
            this.s = XIONUtil.isMacOS() ? new MacSpeaker() : (Speaker)Class.forName("com.kreative.openxion.audio.JSAPISpeaker").newInstance();
        }
        catch (Throwable throwable) {
            this.s = null;
        }
        this.t = new Toner[]{new ToneGenerator(), new ToneGenerator(), new ToneGenerator(), new ToneGenerator(), new ToneGenerator(), new ToneGenerator(), new ToneGenerator(), new ToneGenerator()};
        this.ti = 0;
    }

    public XNAudioManager(AudioDialer audioDialer, ModemDialer modemDialer, Player player, Speaker speaker, Toner toner) {
        this.ad = audioDialer;
        this.md = modemDialer;
        this.p = new Player[]{player};
        this.pi = 0;
        this.s = speaker;
        this.t = new Toner[]{toner};
        this.ti = 0;
    }

    public XNAudioManager(AudioDialer audioDialer, ModemDialer modemDialer, Player[] playerArray, Speaker speaker, Toner[] tonerArray) {
        this.ad = audioDialer;
        this.md = modemDialer;
        this.p = playerArray;
        this.pi = 0;
        this.s = speaker;
        this.t = tonerArray;
        this.ti = 0;
    }

    public boolean supportsAudioDial() {
        return this.ad != null;
    }

    public boolean supportsModemDial() {
        return this.md != null;
    }

    public boolean supportsPlay() {
        return this.p != null;
    }

    public boolean supportsSpeak() {
        return this.s != null;
    }

    public boolean supportsTone() {
        return this.t != null;
    }

    public AudioDialer getAudioDialer() {
        return this.ad;
    }

    public ModemDialer getModemDialer() {
        return this.md;
    }

    public Player getPlayer() {
        return this.p[this.pi];
    }

    public Player getPlayer(int n) {
        return this.p[n];
    }

    public int getPlayerChannel() {
        return this.pi;
    }

    public int getPlayerChannels() {
        return this.p.length;
    }

    public void setPlayerChannel(int n) {
        this.pi = Math.max(0, Math.min(n, this.p.length - 1));
    }

    public Speaker getSpeaker() {
        return this.s;
    }

    public Toner getToner() {
        return this.t[this.ti];
    }

    public Toner getToner(int n) {
        return this.t[n];
    }

    public int getTonerChannel() {
        return this.ti;
    }

    public int getTonerChannels() {
        return this.t.length;
    }

    public void setTonerChannel(int n) {
        this.ti = Math.max(0, Math.min(n, this.t.length - 1));
    }
}

