/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.FPUtilities;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.BitSet;

public class BitInputStream
extends InputStream
implements Closeable,
DataInput {
    private DataInputStream in;
    private int bitpos;
    private int bittmp;
    private long bitsread;
    private int markbitpos;
    private int markbittmp;
    private long markbitsread;

    public BitInputStream(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
        this.bitpos = 0;
        this.bittmp = 0;
        this.bitsread = 0L;
        this.markbitpos = 0;
        this.markbittmp = 0;
        this.markbitsread = 0L;
    }

    public boolean atBitBoundary(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0 || n == 1) {
            return true;
        }
        return this.bitsread % (long)n == 0L;
    }

    public boolean atByteBoundary(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return this.bitpos == 0;
        }
        return this.bitpos == 0 && (this.bitsread >> 3) % (long)n == 0L;
    }

    public long bitsRead() {
        return this.bitsread;
    }

    public long bytesRead() {
        return this.bitsread >> 3;
    }

    public boolean readBit() throws IOException {
        if (this.bitpos == 0) {
            byte bl = this.in.readByte();
            this.bitpos = 128;
            this.bittmp = bl;
        }
        boolean bl = (this.bittmp & this.bitpos) != 0;
        this.bitpos >>= 1;
        ++this.bitsread;
        return bl;
    }

    public boolean skipBit() throws IOException {
        if (this.bitpos == 0) {
            int n = this.in.read();
            if (n < 0) {
                return false;
            }
            this.bitpos = 128;
            this.bittmp = n;
        }
        this.bitpos >>= 1;
        ++this.bitsread;
        return true;
    }

    public boolean availableBit() throws IOException {
        if (this.bitpos == 0) {
            return this.in.available() > 0;
        }
        return true;
    }

    public BitSet readBits(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return new BitSet();
        }
        BitSet bitSet = new BitSet();
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public BitSet readBitsLE(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return new BitSet();
        }
        if (this.bitpos != 0 || (n & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        int n2 = (n >> 3) - 1;
        BitSet bitSet = new BitSet();
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            bitSet.set(n & 7 | n2 - (n >> 3) << 3);
        }
        return bitSet;
    }

    public long skipBits(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = 0L;
        while (l > 0L && this.bitpos > 0) {
            if (this.skipBit()) {
                --l;
                ++l2;
                continue;
            }
            return l2;
        }
        if (l >= 8L) {
            long l3 = this.in.skip(l >> 3);
            this.bitsread += l3 << 3;
            l -= l3 << 3;
            l2 += l3 << 3;
        }
        while (l > 0L) {
            if (this.skipBit()) {
                --l;
                ++l2;
                continue;
            }
            return l2;
        }
        return l2;
    }

    public long availableBits() throws IOException {
        int n = this.bitpos;
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return (long)n2 + ((long)this.in.available() << 3);
    }

    public BigInteger readInteger(int n) throws IOException {
        BigInteger bigInteger;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        BigInteger bigInteger2 = bigInteger = this.readBit() ? BigInteger.ONE.negate().shiftLeft(--n) : BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            bigInteger = bigInteger.setBit(n);
        }
        return bigInteger;
    }

    public BigInteger readIntegerLE(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        if (this.bitpos != 0 || (n & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        int n2 = n;
        int n3 = (n >> 3) - 1;
        BigInteger bigInteger = BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            bigInteger = bigInteger.setBit(n & 7 | n3 - (n >> 3) << 3);
        }
        if (bigInteger.testBit(n2 - 1)) {
            bigInteger = bigInteger.xor(BigInteger.ONE.negate().shiftLeft(n2));
        }
        return bigInteger;
    }

    public BigInteger readUnsignedInteger(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        BigInteger bigInteger = BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            bigInteger = bigInteger.setBit(n);
        }
        return bigInteger;
    }

    public BigInteger readUnsignedIntegerLE(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BigInteger.ZERO;
        }
        if (this.bitpos != 0 || (n & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        int n2 = (n >> 3) - 1;
        BigInteger bigInteger = BigInteger.ZERO;
        while (n > 0) {
            --n;
            if (!this.readBit()) continue;
            bigInteger = bigInteger.setBit(n & 7 | n2 - (n >> 3) << 3);
        }
        return bigInteger;
    }

    public Number readFloat(int n, MathContext mathContext) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = FPUtilities.optimalSignWidth(n);
        int n3 = FPUtilities.optimalExponentWidth(n);
        int n4 = FPUtilities.optimalMantissaWidth(n);
        return this.readFloat(n2, n3, n4, mathContext);
    }

    public Number readFloatLE(int n, MathContext mathContext) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = FPUtilities.optimalSignWidth(n);
        int n3 = FPUtilities.optimalExponentWidth(n);
        int n4 = FPUtilities.optimalMantissaWidth(n);
        return this.readFloatLE(n2, n3, n4, mathContext);
    }

    public Number readFloat(int n, int n2, int n3, MathContext mathContext) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = FPUtilities.optimalBias(n2);
        return this.readFloat(n, n2, n3, n4, mathContext);
    }

    public Number readFloatLE(int n, int n2, int n3, MathContext mathContext) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = FPUtilities.optimalBias(n2);
        return this.readFloatLE(n, n2, n3, n4, mathContext);
    }

    public Number readFloat(int n, int n2, int n3, int n4, MathContext mathContext) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger bigInteger = this.readUnsignedInteger(n);
        BigInteger bigInteger2 = this.readUnsignedInteger(n2);
        BigInteger bigInteger3 = this.readUnsignedInteger(n3);
        return FPUtilities.decodeFloat(bigInteger, bigInteger2, bigInteger3, n, n2, n3, n4, mathContext);
    }

    public Number readFloatLE(int n, int n2, int n3, int n4, MathContext mathContext) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (this.bitpos != 0 || (n + n2 + n3 & 7) != 0) {
            throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
        }
        BigInteger bigInteger = this.readUnsignedIntegerLE(n + n2 + n3);
        BigInteger[] bigIntegerArray = FPUtilities.splitFloat(bigInteger, n, n2, n3);
        return FPUtilities.decodeFloat(bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2], n, n2, n3, n4, mathContext);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int n) {
        this.in.mark(n);
        this.markbitpos = this.bitpos;
        this.markbittmp = this.bittmp;
        this.markbitsread = this.bitsread;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        if (this.bitpos == 0) {
            int n = this.in.read();
            if (n >= 0) {
                this.bitsread += 8L;
            }
            return n;
        }
        int n = this.in.read();
        if (n >= 0) {
            int n2 = 0;
            int n3 = 128;
            while (this.bitpos > 0) {
                if ((this.bittmp & this.bitpos) != 0) {
                    n2 |= n3;
                }
                n3 >>= 1;
                this.bitpos >>= 1;
                ++this.bitsread;
            }
            this.bitpos = 128;
            this.bittmp = n;
            while (n3 > 0) {
                if ((this.bittmp & this.bitpos) != 0) {
                    n2 |= n3;
                }
                n3 >>= 1;
                this.bitpos >>= 1;
                ++this.bitsread;
            }
            return n2;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.bitpos == 0) {
            int n = this.in.read(byArray);
            if (n >= 0) {
                this.bitsread += (long)n << 3;
            }
            return n;
        }
        int n = 0;
        int n2 = 0;
        while (n < byArray.length && (n2 = this.read()) >= 0) {
            byArray[n++] = (byte)n2;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.bitpos == 0) {
            int n4 = this.in.read(byArray, n, n2);
            if (n4 >= 0) {
                this.bitsread += (long)n4 << 3;
            }
            return n4;
        }
        int n5 = 0;
        for (n3 = 0; n3 < n2 && (n5 = this.read()) >= 0; ++n3) {
            byArray[n++] = (byte)n5;
        }
        return n3;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.bitpos = this.markbitpos;
        this.bittmp = this.markbittmp;
        this.bitsread = this.markbitsread;
    }

    public long skip(long l) throws IOException {
        if (this.bitpos == 0) {
            long l2 = this.in.skip(l);
            if (l2 >= 0L) {
                this.bitsread += l2 << 3;
            }
            return l2;
        }
        return this.skipBits(l << 3) >> 3;
    }

    public void readFully(byte[] byArray) throws IOException {
        if (this.bitpos == 0) {
            this.in.readFully(byArray);
            this.bitsread += (long)byArray.length << 3;
        } else {
            int n = 0;
            while (n < byArray.length) {
                byArray[n++] = this.readByte();
            }
        }
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.bitpos == 0) {
            this.in.readFully(byArray, n, n2);
            this.bitsread += (long)n2 << 3;
        } else {
            for (int i = 0; i < n2; ++i) {
                byArray[n++] = this.readByte();
            }
        }
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public boolean readBoolean() throws IOException {
        if (this.bitpos == 0) {
            boolean bl = this.in.readBoolean();
            this.bitsread += 8L;
            return bl;
        }
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        if (this.bitpos == 0) {
            byte by = this.in.readByte();
            this.bitsread += 8L;
            return by;
        }
        byte by = this.in.readByte();
        byte by2 = 0;
        int n = 128;
        while (this.bitpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                by2 = (byte)(by2 | n);
            }
            n >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        this.bitpos = 128;
        this.bittmp = by;
        while (n > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                by2 = (byte)(by2 | n);
            }
            n >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        return by2;
    }

    public int readUnsignedByte() throws IOException {
        if (this.bitpos == 0) {
            int n = this.in.readUnsignedByte();
            this.bitsread += 8L;
            return n;
        }
        return this.readByte() & 0xFF;
    }

    public short readShort() throws IOException {
        if (this.bitpos == 0) {
            short s = this.in.readShort();
            this.bitsread += 16L;
            return s;
        }
        short s = this.in.readShort();
        short s2 = 0;
        int n = 32768;
        while (this.bitpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                s2 = (short)(s2 | n);
            }
            n >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        this.bitpos = 32768;
        this.bittmp = s;
        while (n > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                s2 = (short)(s2 | n);
            }
            n >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        return s2;
    }

    public short readShortLE() throws IOException {
        if (this.bitpos == 0) {
            short s = Short.reverseBytes(this.in.readShort());
            this.bitsread += 16L;
            return s;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public int readUnsignedShort() throws IOException {
        if (this.bitpos == 0) {
            int n = this.in.readUnsignedShort();
            this.bitsread += 16L;
            return n;
        }
        return this.readShort() & 0xFFFF;
    }

    public int readUnsignedShortLE() throws IOException {
        if (this.bitpos == 0) {
            int n = Integer.reverseBytes(this.in.readUnsignedShort()) >>> 16;
            this.bitsread += 16L;
            return n;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public char readChar() throws IOException {
        if (this.bitpos == 0) {
            char c = this.in.readChar();
            this.bitsread += 16L;
            return c;
        }
        char c = this.in.readChar();
        char c2 = '\u0000';
        int n = 32768;
        while (this.bitpos > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                c2 = (char)(c2 | n);
            }
            n >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        this.bitpos = 32768;
        this.bittmp = c;
        while (n > 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                c2 = (char)(c2 | n);
            }
            n >>= 1;
            this.bitpos >>= 1;
            ++this.bitsread;
        }
        return c2;
    }

    public char readCharLE() throws IOException {
        if (this.bitpos == 0) {
            char c = Character.reverseBytes(this.in.readChar());
            this.bitsread += 16L;
            return c;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public int readInt() throws IOException {
        if (this.bitpos == 0) {
            int n = this.in.readInt();
            this.bitsread += 32L;
            return n;
        }
        int n = this.in.readInt();
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        while (this.bitpos != 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                n2 |= n3;
            }
            n3 >>>= 1;
            this.bitpos >>>= 1;
            ++this.bitsread;
        }
        this.bitpos = Integer.MIN_VALUE;
        this.bittmp = n;
        while (n3 != 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                n2 |= n3;
            }
            n3 >>>= 1;
            this.bitpos >>>= 1;
            ++this.bitsread;
        }
        return n2;
    }

    public int readIntLE() throws IOException {
        if (this.bitpos == 0) {
            int n = Integer.reverseBytes(this.in.readInt());
            this.bitsread += 32L;
            return n;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public long readLong() throws IOException {
        if (this.bitpos == 0) {
            long l = this.in.readLong();
            this.bitsread += 64L;
            return l;
        }
        long l = this.in.readLong();
        long l2 = 0L;
        long l3 = Long.MIN_VALUE;
        while (this.bitpos != 0) {
            if ((this.bittmp & this.bitpos) != 0) {
                l2 |= l3;
            }
            l3 >>>= 1;
            this.bitpos >>>= 1;
            ++this.bitsread;
        }
        long l4 = Long.MIN_VALUE;
        long l5 = l;
        while (l3 != 0L) {
            if ((l5 & l4) != 0L) {
                l2 |= l3;
            }
            l3 >>>= 1;
            l4 >>>= 1;
            ++this.bitsread;
        }
        this.bitpos = (int)l4;
        this.bittmp = (int)l5;
        return l2;
    }

    public long readLongLE() throws IOException {
        if (this.bitpos == 0) {
            long l = Long.reverseBytes(this.in.readLong());
            this.bitsread += 64L;
            return l;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public float readFloat() throws IOException {
        if (this.bitpos == 0) {
            float f = this.in.readFloat();
            this.bitsread += 32L;
            return f;
        }
        return Float.intBitsToFloat(this.readInt());
    }

    public float readFloatLE() throws IOException {
        if (this.bitpos == 0) {
            float f = Float.intBitsToFloat(Integer.reverseBytes(this.in.readInt()));
            this.bitsread += 32L;
            return f;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public double readDouble() throws IOException {
        if (this.bitpos == 0) {
            double d = this.in.readDouble();
            this.bitsread += 64L;
            return d;
        }
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDoubleLE() throws IOException {
        if (this.bitpos == 0) {
            double d = Double.longBitsToDouble(Long.reverseBytes(this.in.readLong()));
            this.bitsread += 64L;
            return d;
        }
        throw new IOException("Can't read little-endian values unless on a byte boundry with a byte-multiple width");
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }
}

