/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.FPUtilities;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.StringCharacterIterator;
import java.util.BitSet;

public class BitOutputStream
extends OutputStream
implements Closeable,
DataOutput {
    private DataOutputStream out;
    private int bitpos;
    private int bittmp;
    private long bitswritten;

    public BitOutputStream(OutputStream outputStream) {
        this.out = new DataOutputStream(outputStream);
        this.bitpos = 0;
        this.bittmp = 0;
        this.bitswritten = 0L;
    }

    public boolean atBitBoundary(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0 || n == 1) {
            return true;
        }
        return this.bitswritten % (long)n == 0L;
    }

    public boolean atByteBoundary(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return this.bitpos == 0;
        }
        return this.bitpos == 0 && (this.bitswritten >> 3) % (long)n == 0L;
    }

    public long bitsWritten() {
        return this.bitswritten;
    }

    public long bytesWritten() {
        return this.bitswritten >> 3;
    }

    public void writeBit(boolean bl) throws IOException {
        if (this.bitpos == 0) {
            this.bitpos = 128;
            this.bittmp = 0;
        }
        if (bl) {
            this.bittmp |= this.bitpos;
        }
        this.bitpos >>= 1;
        ++this.bitswritten;
        if (this.bitpos == 0) {
            this.out.writeByte(this.bittmp);
        }
    }

    public void writeBits(int n, BitSet bitSet) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0) {
            this.writeBit(bitSet.get(--n));
        }
    }

    public void writeBitsLE(int n, BitSet bitSet) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n != 0) {
            if (this.bitpos != 0 || (n & 7) != 0) {
                throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
            }
            int n2 = (n >> 3) - 1;
            while (n > 0) {
                this.writeBit(bitSet.get(--n & 7 | n2 - (n >> 3) << 3));
            }
        }
    }

    public void writeInteger(int n, BigInteger bigInteger) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0) {
            this.writeBit(bigInteger.testBit(--n));
        }
    }

    public void writeIntegerLE(int n, BigInteger bigInteger) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n != 0) {
            if (this.bitpos != 0 || (n & 7) != 0) {
                throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
            }
            int n2 = (n >> 3) - 1;
            while (n > 0) {
                this.writeBit(bigInteger.testBit(--n & 7 | n2 - (n >> 3) << 3));
            }
        }
    }

    public void writeFloat(int n, MathContext mathContext, Number number) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = FPUtilities.optimalSignWidth(n);
        int n3 = FPUtilities.optimalExponentWidth(n);
        int n4 = FPUtilities.optimalMantissaWidth(n);
        this.writeFloat(n2, n3, n4, mathContext, number);
    }

    public void writeFloatLE(int n, MathContext mathContext, Number number) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = FPUtilities.optimalSignWidth(n);
        int n3 = FPUtilities.optimalExponentWidth(n);
        int n4 = FPUtilities.optimalMantissaWidth(n);
        this.writeFloatLE(n2, n3, n4, mathContext, number);
    }

    public void writeFloat(int n, int n2, int n3, MathContext mathContext, Number number) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = FPUtilities.optimalBias(n2);
        this.writeFloat(n, n2, n3, n4, mathContext, number);
    }

    public void writeFloatLE(int n, int n2, int n3, MathContext mathContext, Number number) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = FPUtilities.optimalBias(n2);
        this.writeFloatLE(n, n2, n3, n4, mathContext, number);
    }

    public void writeFloat(int n, int n2, int n3, int n4, MathContext mathContext, Number number) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger[] bigIntegerArray = FPUtilities.encodeFloat(number, n, n2, n3, n4, mathContext);
        this.writeInteger(n, bigIntegerArray[0]);
        this.writeInteger(n2, bigIntegerArray[1]);
        this.writeInteger(n3, bigIntegerArray[2]);
    }

    public void writeFloatLE(int n, int n2, int n3, int n4, MathContext mathContext, Number number) throws IOException {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (this.bitpos != 0 || (n + n2 + n3 & 7) != 0) {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
        BigInteger[] bigIntegerArray = FPUtilities.encodeFloat(number, n, n2, n3, n4, mathContext);
        BigInteger bigInteger = FPUtilities.joinFloat(bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2], n, n2, n3);
        this.writeIntegerLE(n + n2 + n3, bigInteger);
    }

    public void close() throws IOException {
        if (this.bitpos != 0) {
            this.out.writeByte(this.bittmp);
        }
        this.out.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.write(n);
            this.bitswritten += 8L;
        } else {
            for (int i = 128; i != 0; i >>>= 1) {
                this.writeBit((n & i) != 0);
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.bitpos == 0) {
            this.out.write(byArray);
            this.bitswritten += (long)byArray.length << 3;
        } else {
            for (byte by : byArray) {
                for (int i = 128; i != 0; i >>>= 1) {
                    this.writeBit((by & i) != 0);
                }
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bitpos == 0) {
            this.out.write(byArray, n, n2);
            this.bitswritten += (long)n2 << 3;
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 128; j != 0; j >>>= 1) {
                    this.writeBit((byArray[n] & j) != 0);
                }
                ++n;
            }
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeBoolean(bl);
            this.bitswritten += 8L;
        } else {
            this.writeByte(bl ? 1 : 0);
        }
    }

    public void writeByte(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeByte(n);
            this.bitswritten += 8L;
        } else {
            for (int i = 128; i != 0; i >>>= 1) {
                this.writeBit((n & i) != 0);
            }
        }
    }

    public void writeShort(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeShort(n);
            this.bitswritten += 16L;
        } else {
            for (int i = 32768; i != 0; i >>>= 1) {
                this.writeBit((n & i) != 0);
            }
        }
    }

    public void writeShortLE(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeShort(Short.reverseBytes((short)n));
            this.bitswritten += 16L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeChar(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeChar(n);
            this.bitswritten += 16L;
        } else {
            for (int i = 32768; i != 0; i >>>= 1) {
                this.writeBit((n & i) != 0);
            }
        }
    }

    public void writeCharLE(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeChar(Character.reverseBytes((char)n));
            this.bitswritten += 16L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeInt(n);
            this.bitswritten += 32L;
        } else {
            for (int i = Integer.MIN_VALUE; i != 0; i >>>= 1) {
                this.writeBit((n & i) != 0);
            }
        }
    }

    public void writeIntLE(int n) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeInt(Integer.reverseBytes(n));
            this.bitswritten += 32L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeLong(l);
            this.bitswritten += 64L;
        } else {
            for (long i = Long.MIN_VALUE; i != 0L; i >>>= 1) {
                this.writeBit((l & i) != 0L);
            }
        }
    }

    public void writeLongLE(long l) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeLong(Long.reverseBytes(l));
            this.bitswritten += 64L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeFloat(float f) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeFloat(f);
            this.bitswritten += 32L;
        } else {
            this.writeInt(Float.floatToRawIntBits(f));
        }
    }

    public void writeFloatLE(float f) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeInt(Integer.reverseBytes(Float.floatToRawIntBits(f)));
            this.bitswritten += 32L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeDouble(double d) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeDouble(d);
            this.bitswritten += 64L;
        } else {
            this.writeLong(Double.doubleToRawLongBits(d));
        }
    }

    public void writeDoubleLE(double d) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeLong(Long.reverseBytes(Double.doubleToRawLongBits(d)));
            this.bitswritten += 64L;
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeBytes(String string) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeBytes(string);
            this.bitswritten += (long)string.length() << 3;
        } else {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                this.writeByte(c);
                c = stringCharacterIterator.next();
            }
        }
    }

    public void writeChars(String string) throws IOException {
        if (this.bitpos == 0) {
            this.out.writeChars(string);
            this.bitswritten += (long)string.length() << 4;
        } else {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                this.writeChar(c);
                c = stringCharacterIterator.next();
            }
        }
    }

    public void writeCharsLE(String string) throws IOException {
        if (this.bitpos == 0) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                this.out.writeChar(Character.reverseBytes(c));
                this.bitswritten += 16L;
                c = stringCharacterIterator.next();
            }
        } else {
            throw new IOException("Can't write little-endian values unless on a byte boundry with a byte-multiple width");
        }
    }

    public void writeUTF(String string) throws IOException {
        throw new UnsupportedOperationException();
    }
}

