/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;

public class ColorFormat {
    private ChannelOrder channelOrder;
    private int[] channelBits;

    public ColorFormat(ChannelOrder channelOrder, int ... nArray) {
        if (channelOrder == null) {
            throw new IllegalArgumentException("Invalid channel order");
        }
        if (nArray.length != channelOrder.name().length()) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        this.channelOrder = channelOrder;
        this.channelBits = nArray;
    }

    public ColorFormat(String string) {
        String string2 = string.replaceAll("[^A-Za-z]", "").toUpperCase();
        this.channelOrder = ChannelOrder.valueOf(string2);
        if (this.channelOrder == null) {
            throw new IllegalArgumentException("Invalid channel order");
        }
        this.channelBits = new int[this.channelOrder.name().length()];
        String[] stringArray = string.replaceAll("[^0-9]", " ").trim().split("\\s+");
        if (stringArray.length == 1 && stringArray[0].length() == 0) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        if (stringArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.channelBits[i] = Integer.parseInt(stringArray[i]);
        }
    }

    public ColorFormat(int n, String string) {
        int n2;
        String string2 = string.replaceAll("[^A-Za-z]", "").toUpperCase();
        this.channelOrder = ChannelOrder.valueOf(string2);
        if (this.channelOrder == null) {
            throw new IllegalArgumentException("Invalid channel order");
        }
        this.channelBits = new int[this.channelOrder.name().length()];
        String[] stringArray = string.replaceAll("[^0-9]", " ").trim().split("\\s+");
        if (stringArray.length == 1 && stringArray[0].length() == 0) {
            stringArray = new String[]{};
        }
        if (stringArray.length > this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.channelBits[n2] = Integer.parseInt(stringArray[n2]);
            n -= this.channelBits[n2];
        }
        if (stringArray.length < this.channelBits.length) {
            int n3;
            n2 = this.channelBits.length - stringArray.length;
            int n4 = n / n2;
            for (n3 = stringArray.length; n3 < this.channelBits.length; ++n3) {
                this.channelBits[n3] = n4;
                n -= n4;
            }
            if (n > 0) {
                n3 = string2.indexOf(71);
                if (n3 >= 0) {
                    int n5 = n3;
                    this.channelBits[n5] = this.channelBits[n5] + n;
                } else {
                    n3 = string2.indexOf(72);
                    if (n3 >= 0) {
                        int n6 = n3;
                        this.channelBits[n6] = this.channelBits[n6] + n;
                    } else {
                        n3 = string2.indexOf(75);
                        if (n3 >= 0) {
                            int n7 = n3;
                            this.channelBits[n7] = this.channelBits[n7] + n;
                        } else {
                            n3 = string2.indexOf(89);
                            if (n3 >= 0) {
                                int n8 = n3;
                                this.channelBits[n8] = this.channelBits[n8] + n;
                            } else {
                                int n9 = this.channelBits.length / 2;
                                this.channelBits[n9] = this.channelBits[n9] + n;
                            }
                        }
                    }
                }
            }
        }
    }

    public ChannelOrder channelOrder() {
        return this.channelOrder;
    }

    public int channelCount() {
        return this.channelBits.length;
    }

    public int channelWidth(int n) {
        return this.channelBits[n];
    }

    public boolean equals(Object object) {
        if (object instanceof ColorFormat) {
            ColorFormat colorFormat = (ColorFormat)object;
            if (this.channelOrder != colorFormat.channelOrder) {
                return false;
            }
            if (this.channelBits.length != colorFormat.channelBits.length) {
                return false;
            }
            for (int i = 0; i < this.channelBits.length; ++i) {
                if (this.channelBits[i] == colorFormat.channelBits[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.channelOrder.hashCode() ^ Arrays.hashCode(this.channelBits);
    }

    public String toString() {
        String string = this.channelOrder.name().toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.channelBits.length; ++i) {
            stringBuffer.append(string.charAt(i));
            stringBuffer.append(this.channelBits[i]);
        }
        return stringBuffer.toString();
    }

    public float[] toFloatArray(Number[] numberArray) {
        if (numberArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        float[] fArray = new float[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            fArray[i] = numberArray[i].floatValue() / BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).floatValue();
        }
        return fArray;
    }

    public float[] toFloatArray(long[] lArray) {
        if (lArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        float[] fArray = new float[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            fArray[i] = (float)lArray[i] / BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).floatValue();
        }
        return fArray;
    }

    public float[] toFloatArray(int[] nArray) {
        if (nArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = (float)nArray[i] / BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).floatValue();
        }
        return fArray;
    }

    public BigInteger[] toBigIntArray(float[] fArray) {
        if (fArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        MathContext mathContext = MathContext.DECIMAL128;
        BigInteger[] bigIntegerArray = new BigInteger[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            BigInteger bigInteger = BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE);
            bigIntegerArray[i] = BigDecimal.valueOf(fArray[i]).multiply(new BigDecimal(bigInteger, mathContext), mathContext).toBigInteger();
        }
        return bigIntegerArray;
    }

    public long[] toLongArray(float[] fArray) {
        if (fArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        long[] lArray = new long[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            lArray[i] = (long)((double)fArray[i] * BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).doubleValue());
        }
        return lArray;
    }

    public int[] toIntArray(float[] fArray) {
        if (fArray.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = (int)((double)fArray[i] * BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).doubleValue());
        }
        return nArray;
    }

    public float[] toRGBAFloatArray(float[] fArray) {
        String string = this.channelOrder.name().toUpperCase();
        switch (this.channelOrder) {
            case ARGB: 
            case ARBG: 
            case AGRB: 
            case AGBR: 
            case ABRG: 
            case ABGR: 
            case RAGB: 
            case RABG: 
            case RGAB: 
            case RGBA: 
            case RBAG: 
            case RBGA: 
            case GARB: 
            case GABR: 
            case GRAB: 
            case GRBA: 
            case GBAR: 
            case GBRA: 
            case BARG: 
            case BAGR: 
            case BRAG: 
            case BRGA: 
            case BGAR: 
            case BGRA: {
                return new float[]{fArray[string.indexOf(82)], fArray[string.indexOf(71)], fArray[string.indexOf(66)], fArray[string.indexOf(65)]};
            }
            case RGB: 
            case RBG: 
            case GRB: 
            case GBR: 
            case BRG: 
            case BGR: {
                return new float[]{fArray[string.indexOf(82)], fArray[string.indexOf(71)], fArray[string.indexOf(66)], 1.0f};
            }
            case AY: 
            case YA: {
                return new float[]{fArray[string.indexOf(89)], fArray[string.indexOf(89)], fArray[string.indexOf(89)], fArray[string.indexOf(65)]};
            }
            case Y: {
                return new float[]{fArray[string.indexOf(89)], fArray[string.indexOf(89)], fArray[string.indexOf(89)], 1.0f};
            }
            case A: {
                return new float[]{0.0f, 0.0f, 0.0f, fArray[string.indexOf(65)]};
            }
            case AHSV: 
            case AHVS: 
            case ASHV: 
            case ASVH: 
            case AVHS: 
            case AVSH: 
            case HASV: 
            case HAVS: 
            case HSAV: 
            case HSVA: 
            case HVAS: 
            case HVSA: 
            case SAHV: 
            case SAVH: 
            case SHAV: 
            case SHVA: 
            case SVAH: 
            case SVHA: 
            case VAHS: 
            case VASH: 
            case VHAS: 
            case VHSA: 
            case VSAH: 
            case VSHA: {
                int n = Color.HSBtoRGB(fArray[string.indexOf(72)], fArray[string.indexOf(83)], fArray[string.indexOf(86)]);
                return new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f, fArray[string.indexOf(65)]};
            }
            case HSV: 
            case HVS: 
            case SHV: 
            case SVH: 
            case VHS: 
            case VSH: {
                int n = Color.HSBtoRGB(fArray[string.indexOf(72)], fArray[string.indexOf(83)], fArray[string.indexOf(86)]);
                return new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f, 1.0f};
            }
            case AHSL: 
            case AHLS: 
            case ASHL: 
            case ASLH: 
            case ALHS: 
            case ALSH: 
            case HASL: 
            case HALS: 
            case HSAL: 
            case HSLA: 
            case HLAS: 
            case HLSA: 
            case SAHL: 
            case SALH: 
            case SHAL: 
            case SHLA: 
            case SLAH: 
            case SLHA: 
            case LAHS: 
            case LASH: 
            case LHAS: 
            case LHSA: 
            case LSAH: 
            case LSHA: {
                float f = fArray[string.indexOf(72)];
                float f2 = fArray[string.indexOf(83)];
                float f3 = fArray[string.indexOf(76)];
                float f4 = f;
                float f5 = (f3 + (f2 *= f3 <= 1.0f ? f3 : 2.0f - (f3 *= 2.0f))) / 2.0f;
                float f6 = f3 + f2 == 0.0f ? 0.0f : 2.0f * f2 / (f3 + f2);
                int n = Color.HSBtoRGB(f4, f6, f5);
                return new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f, fArray[string.indexOf(65)]};
            }
            case HSL: 
            case HLS: 
            case SHL: 
            case SLH: 
            case LHS: 
            case LSH: {
                float f = fArray[string.indexOf(72)];
                float f7 = fArray[string.indexOf(83)];
                float f8 = fArray[string.indexOf(76)];
                float f9 = f;
                float f10 = (f8 + (f7 *= f8 <= 1.0f ? f8 : 2.0f - (f8 *= 2.0f))) / 2.0f;
                float f11 = f8 + f7 == 0.0f ? 0.0f : 2.0f * f7 / (f8 + f7);
                int n = Color.HSBtoRGB(f9, f11, f10);
                return new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f, 1.0f};
            }
            case CMYK: 
            case CMKY: 
            case CYMK: 
            case CYKM: 
            case CKMY: 
            case CKYM: 
            case MCYK: 
            case MCKY: 
            case MYCK: 
            case MYKC: 
            case MKCY: 
            case MKYC: 
            case YCMK: 
            case YCKM: 
            case YMCK: 
            case YMKC: 
            case YKCM: 
            case YKMC: 
            case KCMY: 
            case KCYM: 
            case KMCY: 
            case KMYC: 
            case KYCM: 
            case KYMC: {
                float f = fArray[string.indexOf(75)];
                float f12 = f + fArray[string.indexOf(67)] * (1.0f - f);
                float f13 = f + fArray[string.indexOf(77)] * (1.0f - f);
                float f14 = f + fArray[string.indexOf(89)] * (1.0f - f);
                return new float[]{1.0f - f12, 1.0f - f13, 1.0f - f14, 1.0f};
            }
            case CMY: 
            case CYM: 
            case MCY: 
            case MYC: 
            case YCM: 
            case YMC: {
                return new float[]{1.0f - fArray[string.indexOf(67)], 1.0f - fArray[string.indexOf(77)], 1.0f - fArray[string.indexOf(89)], 1.0f};
            }
            case YIQ: 
            case YQI: 
            case IYQ: 
            case IQY: 
            case QYI: 
            case QIY: {
                double[] dArray = ColorFormat.YIQtoRGB(fArray[string.indexOf(89)], fArray[string.indexOf(73)], fArray[string.indexOf(81)]);
                return new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2], 1.0f};
            }
            case YUV: 
            case YVU: 
            case UYV: 
            case UVY: 
            case VYU: 
            case VUY: {
                double[] dArray = ColorFormat.YUVtoRGB(fArray[string.indexOf(89)], fArray[string.indexOf(85)], fArray[string.indexOf(86)]);
                return new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2], 1.0f};
            }
            case XYZ: 
            case XZY: 
            case YXZ: 
            case YZX: 
            case ZXY: 
            case ZYX: {
                double[] dArray = ColorFormat.XYZtosRGB(fArray[string.indexOf(88)], fArray[string.indexOf(89)], fArray[string.indexOf(90)]);
                return new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2], 1.0f};
            }
        }
        throw new IllegalArgumentException("Invalid channel order");
    }

    public float[] fromRGBAFloatArray(float[] fArray) {
        String string = this.channelOrder.name().toUpperCase();
        switch (this.channelOrder) {
            case ARGB: 
            case ARBG: 
            case AGRB: 
            case AGBR: 
            case ABRG: 
            case ABGR: 
            case RAGB: 
            case RABG: 
            case RGAB: 
            case RGBA: 
            case RBAG: 
            case RBGA: 
            case GARB: 
            case GABR: 
            case GRAB: 
            case GRBA: 
            case GBAR: 
            case GBRA: 
            case BARG: 
            case BAGR: 
            case BRAG: 
            case BRGA: 
            case BGAR: 
            case BGRA: {
                float[] fArray2 = new float[4];
                fArray2[string.indexOf((int)82)] = fArray[0];
                fArray2[string.indexOf((int)71)] = fArray[1];
                fArray2[string.indexOf((int)66)] = fArray[2];
                fArray2[string.indexOf((int)65)] = fArray[3];
                return fArray2;
            }
            case RGB: 
            case RBG: 
            case GRB: 
            case GBR: 
            case BRG: 
            case BGR: {
                float[] fArray3 = new float[3];
                fArray3[string.indexOf((int)82)] = fArray[0];
                fArray3[string.indexOf((int)71)] = fArray[1];
                fArray3[string.indexOf((int)66)] = fArray[2];
                return fArray3;
            }
            case AY: 
            case YA: {
                float[] fArray4 = new float[2];
                fArray4[string.indexOf((int)89)] = 0.3f * fArray[0] + 0.59f * fArray[1] + 0.11f * fArray[2];
                fArray4[string.indexOf((int)65)] = fArray[3];
                return fArray4;
            }
            case Y: {
                float[] fArray5 = new float[1];
                fArray5[string.indexOf((int)89)] = 0.3f * fArray[0] + 0.59f * fArray[1] + 0.11f * fArray[2];
                return fArray5;
            }
            case A: {
                float[] fArray6 = new float[1];
                fArray6[string.indexOf((int)65)] = fArray[3];
                return fArray6;
            }
            case AHSV: 
            case AHVS: 
            case ASHV: 
            case ASVH: 
            case AVHS: 
            case AVSH: 
            case HASV: 
            case HAVS: 
            case HSAV: 
            case HSVA: 
            case HVAS: 
            case HVSA: 
            case SAHV: 
            case SAVH: 
            case SHAV: 
            case SHVA: 
            case SVAH: 
            case SVHA: 
            case VAHS: 
            case VASH: 
            case VHAS: 
            case VHSA: 
            case VSAH: 
            case VSHA: {
                float[] fArray7 = new float[4];
                float[] fArray8 = Color.RGBtoHSB((int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f), null);
                fArray7[string.indexOf((int)72)] = fArray8[0];
                fArray7[string.indexOf((int)83)] = fArray8[1];
                fArray7[string.indexOf((int)86)] = fArray8[2];
                fArray7[string.indexOf((int)65)] = fArray[3];
                return fArray7;
            }
            case HSV: 
            case HVS: 
            case SHV: 
            case SVH: 
            case VHS: 
            case VSH: {
                float[] fArray9 = new float[3];
                float[] fArray10 = Color.RGBtoHSB((int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f), null);
                fArray9[string.indexOf((int)72)] = fArray10[0];
                fArray9[string.indexOf((int)83)] = fArray10[1];
                fArray9[string.indexOf((int)86)] = fArray10[2];
                return fArray9;
            }
            case AHSL: 
            case AHLS: 
            case ASHL: 
            case ASLH: 
            case ALHS: 
            case ALSH: 
            case HASL: 
            case HALS: 
            case HSAL: 
            case HSLA: 
            case HLAS: 
            case HLSA: 
            case SAHL: 
            case SALH: 
            case SHAL: 
            case SHLA: 
            case SLAH: 
            case SLHA: 
            case LAHS: 
            case LASH: 
            case LHAS: 
            case LHSA: 
            case LSAH: 
            case LSHA: {
                float[] fArray11 = new float[4];
                float[] fArray12 = Color.RGBtoHSB((int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f), null);
                float f = fArray12[0];
                float f2 = (2.0f - fArray12[1]) * fArray12[2];
                float f3 = fArray12[1] * fArray12[2];
                if (f2 != 0.0f) {
                    f3 /= f2 <= 1.0f ? f2 : 2.0f - f2;
                }
                fArray11[string.indexOf((int)72)] = f;
                fArray11[string.indexOf((int)83)] = f3;
                fArray11[string.indexOf((int)76)] = f2 /= 2.0f;
                fArray11[string.indexOf((int)65)] = fArray[3];
                return fArray11;
            }
            case HSL: 
            case HLS: 
            case SHL: 
            case SLH: 
            case LHS: 
            case LSH: {
                float[] fArray13 = new float[3];
                float[] fArray14 = Color.RGBtoHSB((int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f), null);
                float f = fArray14[0];
                float f4 = (2.0f - fArray14[1]) * fArray14[2];
                float f5 = fArray14[1] * fArray14[2];
                if (f4 != 0.0f) {
                    f5 /= f4 <= 1.0f ? f4 : 2.0f - f4;
                }
                fArray13[string.indexOf((int)72)] = f;
                fArray13[string.indexOf((int)83)] = f5;
                fArray13[string.indexOf((int)76)] = f4 /= 2.0f;
                return fArray13;
            }
            case CMYK: 
            case CMKY: 
            case CYMK: 
            case CYKM: 
            case CKMY: 
            case CKYM: 
            case MCYK: 
            case MCKY: 
            case MYCK: 
            case MYKC: 
            case MKCY: 
            case MKYC: 
            case YCMK: 
            case YCKM: 
            case YMCK: 
            case YMKC: 
            case YKCM: 
            case YKMC: 
            case KCMY: 
            case KCYM: 
            case KMCY: 
            case KMYC: 
            case KYCM: 
            case KYMC: {
                float[] fArray15 = new float[4];
                float f = 1.0f - fArray[0];
                float f6 = 1.0f - fArray[1];
                float f7 = 1.0f - fArray[2];
                float f8 = Math.min(f, Math.min(f6, f7));
                fArray15[string.indexOf((int)67)] = 1.0f - f8 == 0.0f ? 0.0f : (f - f8) / (1.0f - f8);
                fArray15[string.indexOf((int)77)] = 1.0f - f8 == 0.0f ? 0.0f : (f6 - f8) / (1.0f - f8);
                fArray15[string.indexOf((int)89)] = 1.0f - f8 == 0.0f ? 0.0f : (f7 - f8) / (1.0f - f8);
                fArray15[string.indexOf((int)75)] = f8;
                return fArray15;
            }
            case CMY: 
            case CYM: 
            case MCY: 
            case MYC: 
            case YCM: 
            case YMC: {
                float[] fArray16 = new float[3];
                fArray16[string.indexOf((int)67)] = 1.0f - fArray[0];
                fArray16[string.indexOf((int)77)] = 1.0f - fArray[1];
                fArray16[string.indexOf((int)89)] = 1.0f - fArray[2];
                return fArray16;
            }
            case YIQ: 
            case YQI: 
            case IYQ: 
            case IQY: 
            case QYI: 
            case QIY: {
                float[] fArray17 = new float[3];
                double[] dArray = ColorFormat.RGBtoYIQ(fArray[0], fArray[1], fArray[2]);
                fArray17[string.indexOf((int)89)] = (float)dArray[0];
                fArray17[string.indexOf((int)73)] = (float)dArray[1];
                fArray17[string.indexOf((int)81)] = (float)dArray[2];
                return fArray17;
            }
            case YUV: 
            case YVU: 
            case UYV: 
            case UVY: 
            case VYU: 
            case VUY: {
                float[] fArray18 = new float[3];
                double[] dArray = ColorFormat.RGBtoYUV(fArray[0], fArray[1], fArray[2]);
                fArray18[string.indexOf((int)89)] = (float)dArray[0];
                fArray18[string.indexOf((int)85)] = (float)dArray[1];
                fArray18[string.indexOf((int)86)] = (float)dArray[2];
                return fArray18;
            }
            case XYZ: 
            case XZY: 
            case YXZ: 
            case YZX: 
            case ZXY: 
            case ZYX: {
                float[] fArray19 = new float[3];
                double[] dArray = ColorFormat.sRGBtoXYZ(fArray[0], fArray[1], fArray[2]);
                fArray19[string.indexOf((int)88)] = (float)dArray[0];
                fArray19[string.indexOf((int)89)] = (float)dArray[1];
                fArray19[string.indexOf((int)90)] = (float)dArray[2];
                return fArray19;
            }
        }
        throw new IllegalArgumentException("Invalid channel order");
    }

    private static final double[] RGBtoYIQ(double d, double d2, double d3) {
        double d4 = 0.3 * d + 0.59 * d2 + 0.11 * d3;
        double d5 = 0.599 * d - 0.2773 * d2 - 0.3217 * d3;
        double d6 = 0.213 * d - 0.5251 * d2 + 0.3121 * d3;
        return new double[]{d4, d5, d6};
    }

    private static final double[] YIQtoRGB(double d, double d2, double d3) {
        double d4 = d + 0.9469 * d2 + 0.6236 * d3;
        double d5 = d - 0.2748 * d2 - 0.6357 * d3;
        double d6 = d - 1.1086 * d2 + 1.709 * d3;
        return new double[]{d4, d5, d6};
    }

    private static final double[] RGBtoYUV(double d, double d2, double d3) {
        double d4 = 0.299 * d + 0.587 * d2 + 0.114 * d3;
        double d5 = -0.14713 * d - 0.28886 * d2 + 0.436 * d3;
        double d6 = 0.615 * d - 0.51499 * d2 - 0.10001 * d3;
        return new double[]{d4, d5, d6};
    }

    private static final double[] YUVtoRGB(double d, double d2, double d3) {
        double d4 = d + 1.13983 * d3;
        double d5 = d - 0.39465 * d2 - 0.5806 * d3;
        double d6 = d + 2.03211 * d2;
        return new double[]{d4, d5, d6};
    }

    private static final double[] XYZtosRGB(double d, double d2, double d3) {
        double d4 = 3.241 * d - 1.5374 * d2 - 0.4986 * d3;
        double d5 = -0.9692 * d + 1.876 * d2 + 0.0416 * d3;
        double d6 = 0.0556 * d - 0.204 * d2 + 1.057 * d3;
        double d7 = d4 <= 0.0031308 ? 12.92 * d4 : 1.055 * Math.pow(d4, 0.4166666666666667) - 0.055;
        double d8 = d5 <= 0.0031308 ? 12.92 * d5 : 1.055 * Math.pow(d5, 0.4166666666666667) - 0.055;
        double d9 = d6 <= 0.0031308 ? 12.92 * d6 : 1.055 * Math.pow(d6, 0.4166666666666667) - 0.055;
        return new double[]{d7, d8, d9};
    }

    private static final double[] sRGBtoXYZ(double d, double d2, double d3) {
        double d4 = d <= 0.04045 ? d / 12.92 : Math.pow((d + 0.055) / 1.055, 2.4);
        double d5 = d2 <= 0.04045 ? d2 / 12.92 : Math.pow((d2 + 0.055) / 1.055, 2.4);
        double d6 = d3 <= 0.04045 ? d3 / 12.92 : Math.pow((d3 + 0.055) / 1.055, 2.4);
        double d7 = 0.4124 * d4 + 0.3576 * d5 + 0.1805 * d6;
        double d8 = 0.2126 * d4 + 0.7152 * d5 + 0.0722 * d6;
        double d9 = 0.0193 * d4 + 0.1192 * d5 + 0.9505 * d6;
        return new double[]{d7, d8, d9};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelOrder {
        ARGB,
        ARBG,
        AGRB,
        AGBR,
        ABRG,
        ABGR,
        RAGB,
        RABG,
        RGAB,
        RGBA,
        RBAG,
        RBGA,
        GARB,
        GABR,
        GRAB,
        GRBA,
        GBAR,
        GBRA,
        BARG,
        BAGR,
        BRAG,
        BRGA,
        BGAR,
        BGRA,
        RGB,
        RBG,
        GRB,
        GBR,
        BRG,
        BGR,
        AY,
        YA,
        Y,
        A,
        AHSV,
        AHVS,
        ASHV,
        ASVH,
        AVHS,
        AVSH,
        HASV,
        HAVS,
        HSAV,
        HSVA,
        HVAS,
        HVSA,
        SAHV,
        SAVH,
        SHAV,
        SHVA,
        SVAH,
        SVHA,
        VAHS,
        VASH,
        VHAS,
        VHSA,
        VSAH,
        VSHA,
        HSV,
        HVS,
        SHV,
        SVH,
        VHS,
        VSH,
        AHSL,
        AHLS,
        ASHL,
        ASLH,
        ALHS,
        ALSH,
        HASL,
        HALS,
        HSAL,
        HSLA,
        HLAS,
        HLSA,
        SAHL,
        SALH,
        SHAL,
        SHLA,
        SLAH,
        SLHA,
        LAHS,
        LASH,
        LHAS,
        LHSA,
        LSAH,
        LSHA,
        HSL,
        HLS,
        SHL,
        SLH,
        LHS,
        LSH,
        CMYK,
        CMKY,
        CYMK,
        CYKM,
        CKMY,
        CKYM,
        MCYK,
        MCKY,
        MYCK,
        MYKC,
        MKCY,
        MKYC,
        YCMK,
        YCKM,
        YMCK,
        YMKC,
        YKCM,
        YKMC,
        KCMY,
        KCYM,
        KMCY,
        KMYC,
        KYCM,
        KYMC,
        CMY,
        CYM,
        MCY,
        MYC,
        YCM,
        YMC,
        YIQ,
        YQI,
        IYQ,
        IQY,
        QYI,
        QIY,
        YUV,
        YVU,
        UYV,
        UVY,
        VYU,
        VUY,
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX;

    }
}

