/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class DFExpressionLexer {
    private static final int LOOKAHEAD_LIMIT = 65536;
    private Reader reader;
    private Vector<String> buffer;
    private String lastToken;

    public DFExpressionLexer(Reader reader) {
        this.reader = reader;
        this.buffer = new Vector();
        this.lastToken = null;
    }

    private String internalGetNextToken() throws IOException {
        String string;
        int n = this.reader.read();
        while (Character.isWhitespace(n)) {
            n = this.reader.read();
        }
        if (n < 0) {
            return null;
        }
        if (n == 34 || n == 39 || n == 96) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Character.toChars(n));
            while ((n2 = this.reader.read()) >= 0) {
                stringBuffer.append(Character.toChars(n2));
                if (n2 != n) continue;
                break;
            }
            return stringBuffer.toString();
        }
        if (Character.isDigit(n) || Character.isLetter(n) || n == 95) {
            int n3;
            this.reader.mark(65536);
            int n4 = 0;
            while ((n3 = this.reader.read()) >= 0 && (Character.isDigit(n3) || Character.isLetter(n3) || n3 == 95)) {
                ++n4;
            }
            this.reader.reset();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Character.toChars(n));
            while (n4-- > 0) {
                stringBuffer.append(Character.toChars(this.reader.read()));
            }
            return stringBuffer.toString();
        }
        this.reader.mark(65536);
        int n5 = this.reader.read();
        int n6 = this.reader.read();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Character.toChars(n));
        if (n5 >= 0) {
            stringBuffer.append(Character.toChars(n5));
        }
        if (n6 >= 0) {
            stringBuffer.append(Character.toChars(n6));
        }
        if ((string = stringBuffer.toString()).equals(">>>") || string.equals("<=>")) {
            return string;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(Character.toChars(n));
        if (n5 >= 0) {
            stringBuffer.append(Character.toChars(n5));
        }
        if ((string = stringBuffer.toString()).equals("!!") || string.equals("<<") || string.equals(">>") || string.equals("<=") || string.equals(">=") || string.equals("==") || string.equals("!=") || string.equals("<>") || string.equals("&&") || string.equals("^^") || string.equals("||")) {
            this.reader.reset();
            this.reader.read();
            return string;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(Character.toChars(n));
        string = stringBuffer.toString();
        this.reader.reset();
        return string;
    }

    public String lookToken(int n) throws IOException {
        if (n < 1) {
            return this.lastToken;
        }
        while (n > this.buffer.size()) {
            String string = this.internalGetNextToken();
            if (string == null) {
                return null;
            }
            this.buffer.add(string);
        }
        return this.buffer.get(n - 1);
    }

    public String getToken() throws IOException {
        if (this.buffer.isEmpty()) {
            this.lastToken = this.internalGetNextToken();
            return this.lastToken;
        }
        this.lastToken = this.buffer.remove(0);
        return this.lastToken;
    }
}

