/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.DFBinaryExpression;
import com.kreative.openxion.binpack.DFConstantExpression;
import com.kreative.openxion.binpack.DFExpression;
import com.kreative.openxion.binpack.DFExpressionLexer;
import com.kreative.openxion.binpack.DFFieldExpression;
import com.kreative.openxion.binpack.DFLengthExpression;
import com.kreative.openxion.binpack.DFPositionExpression;
import com.kreative.openxion.binpack.DFRemainingExpression;
import com.kreative.openxion.binpack.DFTernaryExpression;
import com.kreative.openxion.binpack.DFUnaryExpression;
import java.io.IOException;
import java.io.StringReader;

public class DFExpressionParser {
    private DFExpressionLexer lexer;

    public DFExpressionParser(DFExpressionLexer dFExpressionLexer) {
        this.lexer = dFExpressionLexer;
    }

    public DFExpression parse() throws IOException {
        DFExpression dFExpression = this.parseExpression();
        String string = this.lexer.getToken();
        if (string != null) {
            throw new RuntimeException("Parse error: expected end of expression but found " + string);
        }
        return dFExpression;
    }

    private int parseInt(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            int n = 0;
            for (char c : string.substring(1, string.length() - 1).toCharArray()) {
                n <<= 8;
                n |= c & 0xFF;
            }
            return n;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return (int)Long.parseLong(string.substring(2).trim(), 16);
        }
        if (string.startsWith("0o") || string.startsWith("0O")) {
            return (int)Long.parseLong(string.substring(2).trim(), 8);
        }
        if (string.startsWith("0b") || string.startsWith("0B")) {
            return (int)Long.parseLong(string.substring(2).trim(), 2);
        }
        if (string.startsWith("0") && string.length() > 1) {
            return (int)Long.parseLong(string.substring(1).trim(), 8);
        }
        return (int)Long.parseLong(string);
    }

    private DFExpression parseFactor() throws IOException {
        String string = this.lexer.getToken();
        if (string == null) {
            throw new RuntimeException("Parse error: expected factor but found end of expression");
        }
        if (string.equals("!!")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.BOOLEAN_IDENTITY, this.parseFactor());
        }
        if (string.equals("!")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.BOOLEAN_NOT, this.parseFactor());
        }
        if (string.equals("~")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.BITWISE_NOT, this.parseFactor());
        }
        if (string.equals("+")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.IDENTITY, this.parseFactor());
        }
        if (string.equals("-")) {
            return new DFUnaryExpression(DFUnaryExpression.Operation.NEGATE, this.parseFactor());
        }
        if (string.equals("(")) {
            DFExpression dFExpression = this.parseExpression();
            string = this.lexer.getToken();
            if (string == null || !string.equals(")")) {
                throw new RuntimeException("Parse error: expected ) but found " + (string == null ? "end of expression" : string));
            }
            return dFExpression;
        }
        if (string.equals("#") || string.equalsIgnoreCase("length")) {
            return new DFLengthExpression();
        }
        if (string.equals("@") || string.equalsIgnoreCase("position")) {
            return new DFPositionExpression();
        }
        if (string.equals("*") || string.equalsIgnoreCase("remaining")) {
            return new DFRemainingExpression();
        }
        if (string.startsWith("'") || string.startsWith("\"") || Character.isDigit(string.charAt(0))) {
            return new DFConstantExpression(this.parseInt(string));
        }
        if (string.startsWith("`") || string.startsWith("_") || Character.isLetter(string.charAt(0))) {
            if (string.startsWith("`") && string.endsWith("`")) {
                string = string.substring(1, string.length() - 1);
            }
            DFFieldExpression dFFieldExpression = new DFFieldExpression(string);
            while (".".equals(this.lexer.lookToken(1))) {
                this.lexer.getToken();
                string = this.lexer.getToken();
                if (string == null || !string.startsWith("`") && !string.startsWith("_") && !Character.isLetter(string.charAt(0))) {
                    throw new RuntimeException("Parse error: expected field name but found " + (string == null ? "end of expression" : string));
                }
                if (string.startsWith("`") && string.endsWith("`")) {
                    string = string.substring(1, string.length() - 1);
                }
                dFFieldExpression = new DFFieldExpression(dFFieldExpression, string);
            }
            return dFFieldExpression;
        }
        throw new RuntimeException("Parse error: expected factor but found " + string);
    }

    private DFExpression parseMultiplicationExpression() throws IOException {
        String string;
        DFExpression dFExpression = this.parseFactor();
        while ((string = this.lexer.lookToken(1)) != null) {
            if (string.equals("*")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.MULTIPLY, dFExpression, this.parseFactor());
                continue;
            }
            if (string.equals("/")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.DIVIDE, dFExpression, this.parseFactor());
                continue;
            }
            if (!string.equals("%")) break;
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.MOD, dFExpression, this.parseFactor());
        }
        return dFExpression;
    }

    private DFExpression parseAdditionExpression() throws IOException {
        String string;
        DFExpression dFExpression = this.parseMultiplicationExpression();
        while ((string = this.lexer.lookToken(1)) != null) {
            if (string.equals("+")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.ADD, dFExpression, this.parseMultiplicationExpression());
                continue;
            }
            if (!string.equals("-")) break;
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.SUBTRACT, dFExpression, this.parseMultiplicationExpression());
        }
        return dFExpression;
    }

    private DFExpression parseShiftExpression() throws IOException {
        String string;
        DFExpression dFExpression = this.parseAdditionExpression();
        while ((string = this.lexer.lookToken(1)) != null) {
            if (string.equals("<<")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.SHIFT_LEFT, dFExpression, this.parseAdditionExpression());
                continue;
            }
            if (string.equals(">>")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.SHIFT_RIGHT, dFExpression, this.parseAdditionExpression());
                continue;
            }
            if (!string.equals(">>>")) break;
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.UNSIGNED_SHIFT_RIGHT, dFExpression, this.parseAdditionExpression());
        }
        return dFExpression;
    }

    private DFExpression parseBitAndExpression() throws IOException {
        DFExpression dFExpression = this.parseShiftExpression();
        while ("&".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.BITWISE_AND, dFExpression, this.parseShiftExpression());
        }
        return dFExpression;
    }

    private DFExpression parseBitXorExpression() throws IOException {
        DFExpression dFExpression = this.parseBitAndExpression();
        while ("^".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.BITWISE_XOR, dFExpression, this.parseBitAndExpression());
        }
        return dFExpression;
    }

    private DFExpression parseBitOrExpression() throws IOException {
        DFExpression dFExpression = this.parseBitXorExpression();
        while ("|".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.BITWISE_OR, dFExpression, this.parseBitXorExpression());
        }
        return dFExpression;
    }

    private DFExpression parseComparisonExpression() throws IOException {
        String string;
        DFExpression dFExpression = this.parseBitOrExpression();
        while ((string = this.lexer.lookToken(1)) != null) {
            if (string.equals("<=")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.LESS_OR_EQUAL, dFExpression, this.parseBitOrExpression());
                continue;
            }
            if (string.equals(">=")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.GREATER_OR_EQUAL, dFExpression, this.parseBitOrExpression());
                continue;
            }
            if (string.equals("<")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.LESS_THAN, dFExpression, this.parseBitOrExpression());
                continue;
            }
            if (!string.equals(">")) break;
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.GREATER_THAN, dFExpression, this.parseBitOrExpression());
        }
        return dFExpression;
    }

    private DFExpression parseEqualityExpression() throws IOException {
        String string;
        DFExpression dFExpression = this.parseComparisonExpression();
        while ((string = this.lexer.lookToken(1)) != null) {
            if (string.equals("==") || string.equals("=")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.EQUAL, dFExpression, this.parseComparisonExpression());
                continue;
            }
            if (string.equals("!=") || string.equals("<>")) {
                this.lexer.getToken();
                dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.NOT_EQUAL, dFExpression, this.parseComparisonExpression());
                continue;
            }
            if (!string.equals("<=>")) break;
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.COMPARE, dFExpression, this.parseComparisonExpression());
        }
        return dFExpression;
    }

    private DFExpression parseAndExpression() throws IOException {
        DFExpression dFExpression = this.parseEqualityExpression();
        while ("&&".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.BOOLEAN_AND, dFExpression, this.parseEqualityExpression());
        }
        return dFExpression;
    }

    private DFExpression parseXorExpression() throws IOException {
        DFExpression dFExpression = this.parseAndExpression();
        while ("^^".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.BOOLEAN_XOR, dFExpression, this.parseAndExpression());
        }
        return dFExpression;
    }

    private DFExpression parseOrExpression() throws IOException {
        DFExpression dFExpression = this.parseXorExpression();
        while ("||".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            dFExpression = new DFBinaryExpression(DFBinaryExpression.Operation.BOOLEAN_OR, dFExpression, this.parseXorExpression());
        }
        return dFExpression;
    }

    private DFExpression parseExpression() throws IOException {
        DFExpression dFExpression = this.parseOrExpression();
        if ("?".equals(this.lexer.lookToken(1))) {
            this.lexer.getToken();
            DFExpression dFExpression2 = this.parseExpression();
            String string = this.lexer.getToken();
            if (string == null || !string.equals(":")) {
                throw new RuntimeException("Parse error: expected : but found " + (string == null ? "end of expression" : string));
            }
            DFExpression dFExpression3 = this.parseExpression();
            dFExpression = new DFTernaryExpression(DFTernaryExpression.Operation.CONDITIONAL, dFExpression, dFExpression2, dFExpression3);
        }
        return dFExpression;
    }

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            try {
                System.out.println(new DFExpressionParser(new DFExpressionLexer(new StringReader(string))).parse().evaluate());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }
}

