/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.BitInputStream;
import com.kreative.openxion.binpack.BitOutputStream;
import com.kreative.openxion.binpack.DFExpression;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFTernaryExpression
implements DFExpression {
    private Operation op;
    private DFExpression det;
    private DFExpression left;
    private DFExpression right;

    public DFTernaryExpression(Operation operation, DFExpression dFExpression, DFExpression dFExpression2, DFExpression dFExpression3) {
        this.op = operation;
        this.det = dFExpression;
        this.left = dFExpression2;
        this.right = dFExpression3;
    }

    @Override
    public int evaluate() {
        int n = this.det.evaluate();
        switch (this.op) {
            case CONDITIONAL: {
                return n != 0 ? this.left.evaluate() : this.right.evaluate();
            }
            case BETWEEN_INCLUSIVE: {
                return this.left.evaluate() <= n && n <= this.right.evaluate() ? 1 : 0;
            }
            case BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate() <= n && n < this.right.evaluate() ? 1 : 0;
            }
            case BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate() < n && n <= this.right.evaluate() ? 1 : 0;
            }
            case BETWEEN_EXCLUSIVE: {
                return this.left.evaluate() < n && n < this.right.evaluate() ? 1 : 0;
            }
            case NOT_BETWEEN_INCLUSIVE: {
                return this.left.evaluate() <= n && n <= this.right.evaluate() ? 0 : 1;
            }
            case NOT_BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate() <= n && n < this.right.evaluate() ? 0 : 1;
            }
            case NOT_BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate() < n && n <= this.right.evaluate() ? 0 : 1;
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.left.evaluate() < n && n < this.right.evaluate() ? 0 : 1;
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> map, BitInputStream bitInputStream, long l) {
        int n = this.det.evaluate(map, bitInputStream, l);
        switch (this.op) {
            case CONDITIONAL: {
                return n != 0 ? this.left.evaluate(map, bitInputStream, l) : this.right.evaluate(map, bitInputStream, l);
            }
            case BETWEEN_INCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) <= n && n <= this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) <= n && n < this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) < n && n <= this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) < n && n < this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case NOT_BETWEEN_INCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) <= n && n <= this.right.evaluate(map, bitInputStream, l) ? 0 : 1;
            }
            case NOT_BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) <= n && n < this.right.evaluate(map, bitInputStream, l) ? 0 : 1;
            }
            case NOT_BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) < n && n <= this.right.evaluate(map, bitInputStream, l) ? 0 : 1;
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(map, bitInputStream, l) < n && n < this.right.evaluate(map, bitInputStream, l) ? 0 : 1;
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> map, BitOutputStream bitOutputStream) {
        int n = this.det.evaluate(map, bitOutputStream);
        switch (this.op) {
            case CONDITIONAL: {
                return n != 0 ? this.left.evaluate(map, bitOutputStream) : this.right.evaluate(map, bitOutputStream);
            }
            case BETWEEN_INCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) <= n && n <= this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) <= n && n < this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) < n && n <= this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) < n && n < this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case NOT_BETWEEN_INCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) <= n && n <= this.right.evaluate(map, bitOutputStream) ? 0 : 1;
            }
            case NOT_BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) <= n && n < this.right.evaluate(map, bitOutputStream) ? 0 : 1;
            }
            case NOT_BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) < n && n <= this.right.evaluate(map, bitOutputStream) ? 0 : 1;
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(map, bitOutputStream) < n && n < this.right.evaluate(map, bitOutputStream) ? 0 : 1;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.det.toString());
        switch (this.op) {
            case CONDITIONAL: {
                stringBuffer.append("?");
                break;
            }
            default: {
                stringBuffer.append("<" + this.op.name().toLowerCase() + ">");
            }
        }
        stringBuffer.append(this.left.toString());
        stringBuffer.append(":");
        stringBuffer.append(this.right.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        CONDITIONAL,
        BETWEEN_INCLUSIVE,
        BETWEEN_LEFT_INCLUSIVE,
        BETWEEN_RIGHT_INCLUSIVE,
        BETWEEN_EXCLUSIVE,
        NOT_BETWEEN_INCLUSIVE,
        NOT_BETWEEN_LEFT_INCLUSIVE,
        NOT_BETWEEN_RIGHT_INCLUSIVE,
        NOT_BETWEEN_EXCLUSIVE;

    }
}

