/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.ElaborationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType {
    BOOLEAN('T', 8, null, true, true, false, false, true),
    ENUM('E', 8, ElaborationType.KV_UNSIGNED, true, true, true, false, true),
    BITFIELD('J', 8, ElaborationType.KV_SIGNED, true, true, true, false, true),
    BINT('B', 32, null, true, true, false, false, true),
    OINT('O', 32, null, true, true, false, false, true),
    HINT('H', 32, null, true, true, false, false, true),
    UINT('U', 32, null, true, true, false, false, true),
    SINT('I', 32, null, true, true, false, false, true),
    UFIXED('R', 32, null, true, true, false, false, true),
    SFIXED('Q', 32, null, true, true, false, false, true),
    FLOAT('F', 32, ElaborationType.FP_FORMAT, true, true, true, false, true),
    COMPLEX('K', 32, ElaborationType.FP_FORMAT, true, true, true, false, true),
    CHAR('C', 8, ElaborationType.TEXT_ENCODING, true, true, true, false, true),
    PSTRING('P', 8, ElaborationType.TEXT_ENCODING, true, true, true, false, true),
    CSTRING('S', 8, ElaborationType.TEXT_ENCODING, true, false, true, false, true),
    DATE('D', 32, ElaborationType.DATE_FORMAT, true, true, true, false, true),
    COLOR('X', 32, ElaborationType.COLOR_FORMAT, true, true, true, false, true),
    FILLER('Z', 8, null, true, false, false, false, false),
    MAGIC('M', 32, ElaborationType.VALUE, true, true, true, false, false),
    ALIGN('A', 32, null, true, false, false, false, false),
    BINARY('*', 0, null, false, false, false, true, true),
    STRUCT('$', 0, ElaborationType.STRUCT, false, false, true, false, true),
    OFFSET('@', 0, null, false, false, false, true, false);

    private char charValue;
    private int defaultSize;
    private ElaborationType elaborationType;
    private boolean usesSize;
    private boolean usesEndianness;
    private boolean usesElaboration;
    private boolean usesCustomCount;
    private boolean returns;

    private DataType(char c, int n2, ElaborationType elaborationType, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.charValue = Character.toUpperCase(c);
        this.defaultSize = n2;
        this.elaborationType = elaborationType;
        this.usesSize = bl;
        this.usesEndianness = bl2;
        this.usesElaboration = bl3;
        this.usesCustomCount = bl4;
        this.returns = bl5;
    }

    public char charValue() {
        return this.charValue;
    }

    public int defaultSize() {
        return this.defaultSize;
    }

    public ElaborationType elaborationType() {
        return this.elaborationType;
    }

    public boolean usesSize() {
        return this.usesSize;
    }

    public boolean usesEndianness() {
        return this.usesEndianness;
    }

    public boolean usesElaboration() {
        return this.usesElaboration;
    }

    public boolean usesCustomCount() {
        return this.usesCustomCount;
    }

    public boolean returns() {
        return this.returns;
    }

    public char toChar() {
        return this.charValue;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public String toShortString() {
        return Character.toString(this.charValue);
    }

    public static DataType fromChar(char c) {
        c = Character.toUpperCase(c);
        for (DataType dataType : DataType.values()) {
            if (dataType.charValue != c) continue;
            return dataType;
        }
        return null;
    }

    public static DataType fromString(String string) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.name().equalsIgnoreCase(string)) continue;
            return dataType;
        }
        return null;
    }

    public static DataType fromShortString(String string) {
        if (string.length() == 1) {
            char c = Character.toUpperCase(string.charAt(0));
            for (DataType dataType : DataType.values()) {
                if (dataType.charValue != c) continue;
                return dataType;
            }
        }
        return null;
    }
}

