/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class FPUtilities {
    private FPUtilities() {
    }

    public static int optimalSignWidth(int n) {
        return n > 0 ? 1 : 0;
    }

    public static int optimalExponentWidth(int n) {
        if (n < 2) {
            return 0;
        }
        if (n < 4) {
            return 1;
        }
        if (n < 6) {
            return 2;
        }
        if (n < 8) {
            return 3;
        }
        if (n < 12) {
            return 4;
        }
        if (n < 20) {
            return 5;
        }
        if (n < 24) {
            return 6;
        }
        if (n < 32) {
            return 7;
        }
        if (n < 48) {
            return 8;
        }
        if (n < 56) {
            return 9;
        }
        if (n < 64) {
            return 10;
        }
        if (n < 80) {
            return 11;
        }
        if (n < 96) {
            return 12;
        }
        if (n < 112) {
            return 13;
        }
        if (n < 128) {
            return 14;
        }
        if (n < 160) {
            return 15;
        }
        if (n < 192) {
            return 16;
        }
        if (n < 224) {
            return 17;
        }
        if (n < 256) {
            return 18;
        }
        if (n < 320) {
            return 19;
        }
        if (n < 384) {
            return 20;
        }
        if (n < 448) {
            return 21;
        }
        if (n < 512) {
            return 22;
        }
        return 23;
    }

    public static int optimalMantissaWidth(int n) {
        return n > 2 ? n - FPUtilities.optimalExponentWidth(n) - 1 : 0;
    }

    public static int optimalBias(int n) {
        return (1 << n - 1) - 1;
    }

    public static BigInteger[] splitFloat(BigInteger bigInteger, int n, int n2, int n3) {
        BigInteger bigInteger2 = bigInteger.shiftRight(n2 + n3).and(BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE));
        BigInteger bigInteger3 = bigInteger.shiftRight(n3).and(BigInteger.ONE.shiftLeft(n2).subtract(BigInteger.ONE));
        BigInteger bigInteger4 = bigInteger.and(BigInteger.ONE.shiftLeft(n3).subtract(BigInteger.ONE));
        return new BigInteger[]{bigInteger2, bigInteger3, bigInteger4};
    }

    public static BigInteger joinFloat(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, int n3) {
        return bigInteger.and(BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE)).shiftLeft(n2 + n3).or(bigInteger2.and(BigInteger.ONE.shiftLeft(n2).subtract(BigInteger.ONE)).shiftLeft(n3)).or(bigInteger3.and(BigInteger.ONE.shiftLeft(n3).subtract(BigInteger.ONE)));
    }

    public static Number decodeFloat(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, int n3, int n4, MathContext mathContext) {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) == 0) {
            if (bigInteger3.compareTo(BigInteger.ZERO) == 0) {
                boolean bl = bigInteger.compareTo(BigInteger.ZERO) != 0;
                return bl ? -0.0 : 0.0;
            }
            boolean bl = bigInteger.compareTo(BigInteger.ZERO) != 0;
            int n5 = n4 + n3 - 1;
            BigDecimal bigDecimal = new BigDecimal(bigInteger3);
            if (n5 < 0) {
                BigDecimal bigDecimal2 = BigDecimal.valueOf(2L).pow(-n5);
                return bl ? bigDecimal.multiply(bigDecimal2, mathContext).negate() : bigDecimal.multiply(bigDecimal2, mathContext);
            }
            BigDecimal bigDecimal3 = BigDecimal.valueOf(2L).pow(n5);
            return bl ? bigDecimal.divide(bigDecimal3, mathContext).negate() : bigDecimal.divide(bigDecimal3, mathContext);
        }
        if (bigInteger2.compareTo(BigInteger.ONE.shiftLeft(n2).subtract(BigInteger.ONE)) == 0) {
            if (bigInteger3.compareTo(BigInteger.ZERO) == 0) {
                boolean bl = bigInteger.compareTo(BigInteger.ZERO) != 0;
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            boolean bl = bigInteger.compareTo(BigInteger.ZERO) != 0;
            boolean bl2 = bigInteger3.testBit(n3 - 1);
            BigInteger bigInteger4 = bigInteger3.clearBit(n3 - 1);
            long l = 0x7FF0000000000000L;
            if (bl) {
                l |= Long.MIN_VALUE;
            }
            if (bl2) {
                l |= 0x8000000000000L;
            }
            return Double.longBitsToDouble(l |= bigInteger4.longValue() & 0x7FFFFFFFFFFFFL);
        }
        boolean bl = bigInteger.compareTo(BigInteger.ZERO) != 0;
        int n6 = n4 + n3 - bigInteger2.intValue();
        BigDecimal bigDecimal = new BigDecimal(bigInteger3.setBit(n3));
        if (n6 < 0) {
            BigDecimal bigDecimal4 = BigDecimal.valueOf(2L).pow(-n6);
            return bl ? bigDecimal.multiply(bigDecimal4, mathContext).negate() : bigDecimal.multiply(bigDecimal4, mathContext);
        }
        BigDecimal bigDecimal5 = BigDecimal.valueOf(2L).pow(n6);
        return bl ? bigDecimal.divide(bigDecimal5, mathContext).negate() : bigDecimal.divide(bigDecimal5, mathContext);
    }

    public static BigInteger[] encodeFloat(Number number, int n, int n2, int n3, int n4, MathContext mathContext) {
        if (n < 0 || n > 1 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                return FPUtilities.encodeZero(false, n, n2, n3);
            }
            return FPUtilities.encodeFiniteNonZero(bigDecimal, n, n2, n3, n4, mathContext);
        }
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
                return FPUtilities.encodeZero(false, n, n2, n3);
            }
            return FPUtilities.encodeFiniteNonZero(new BigDecimal(bigInteger), n, n2, n3, n4, mathContext);
        }
        if (number instanceof Double) {
            double d = number.doubleValue();
            if (Double.isNaN(d)) {
                long l = Double.doubleToRawLongBits(d);
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                boolean bl2 = (l & 0x8000000000000L) != 0L;
                long l2 = l & 0x7FFFFFFFFFFFFL;
                return FPUtilities.encodeNaN(bl, bl2, l2, n, n2, n3);
            }
            if (Double.isInfinite(d)) {
                return FPUtilities.encodeInfinity(d < 0.0, n, n2, n3);
            }
            if (d == 0.0) {
                long l = Double.doubleToRawLongBits(d);
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                return FPUtilities.encodeZero(bl, n, n2, n3);
            }
            return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(d), n, n2, n3, n4, mathContext);
        }
        if (number instanceof Float) {
            float f = number.floatValue();
            if (Float.isNaN(f)) {
                int n5 = Float.floatToRawIntBits(f);
                boolean bl = (n5 & Integer.MIN_VALUE) != 0;
                boolean bl3 = (n5 & 0x400000) != 0;
                int n6 = n5 & 0x3FFFFF;
                return FPUtilities.encodeNaN(bl, bl3, n6, n, n2, n3);
            }
            if (Float.isInfinite(f)) {
                return FPUtilities.encodeInfinity(f < 0.0f, n, n2, n3);
            }
            if (f == 0.0f) {
                int n7 = Float.floatToRawIntBits(f);
                boolean bl = (n7 & Integer.MIN_VALUE) != 0;
                return FPUtilities.encodeZero(bl, n, n2, n3);
            }
            return FPUtilities.encodeFiniteNonZero(new BigDecimal(Float.toString(f)), n, n2, n3, n4, mathContext);
        }
        if (number instanceof Long) {
            long l = number.longValue();
            if (l == 0L) {
                return FPUtilities.encodeZero(false, n, n2, n3);
            }
            return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(l), n, n2, n3, n4, mathContext);
        }
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            int n8 = number.intValue();
            if (n8 == 0) {
                return FPUtilities.encodeZero(false, n, n2, n3);
            }
            return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(n8), n, n2, n3, n4, mathContext);
        }
        double d = number.doubleValue();
        if (Double.isNaN(d)) {
            long l = Double.doubleToRawLongBits(d);
            boolean bl = (l & Long.MIN_VALUE) != 0L;
            boolean bl4 = (l & 0x8000000000000L) != 0L;
            long l3 = l & 0x7FFFFFFFFFFFFL;
            return FPUtilities.encodeNaN(bl, bl4, l3, n, n2, n3);
        }
        if (Double.isInfinite(d)) {
            return FPUtilities.encodeInfinity(d < 0.0, n, n2, n3);
        }
        if (d == 0.0) {
            long l = Double.doubleToRawLongBits(d);
            boolean bl = (l & Long.MIN_VALUE) != 0L;
            return FPUtilities.encodeZero(bl, n, n2, n3);
        }
        return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(d), n, n2, n3, n4, mathContext);
    }

    private static BigInteger[] encodeNaN(boolean bl, boolean bl2, long l, int n, int n2, int n3) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        bigInteger = bl2 ? bigInteger.setBit(n3 - 1) : bigInteger.clearBit(n3 - 1);
        return new BigInteger[]{bl ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ONE.negate(), bigInteger};
    }

    private static BigInteger[] encodeInfinity(boolean bl, int n, int n2, int n3) {
        return new BigInteger[]{bl ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ONE.negate(), BigInteger.ZERO};
    }

    private static BigInteger[] encodeZero(boolean bl, int n, int n2, int n3) {
        return new BigInteger[]{bl ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO};
    }

    private static BigInteger[] encodeFiniteNonZero(BigDecimal bigDecimal, int n, int n2, int n3, int n4, MathContext mathContext) {
        BigInteger bigInteger;
        boolean bl = bigDecimal.compareTo(BigDecimal.ZERO) < 0;
        bigDecimal = bigDecimal.abs();
        int n5 = FPUtilities.ilog2(bigDecimal, mathContext) + n4;
        while (true) {
            BigDecimal bigDecimal2;
            int n6;
            if (n5 >= (1 << n2) - 1) {
                return new BigInteger[]{bl ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ONE.negate(), BigInteger.ZERO};
            }
            if (n5 <= 0) {
                n6 = n4 + n3 - 1;
                if (n6 < 0) {
                    bigDecimal2 = BigDecimal.valueOf(2L).pow(-n6);
                    bigInteger = bigDecimal.divide(bigDecimal2, mathContext).setScale(0, mathContext.getRoundingMode()).toBigIntegerExact();
                } else {
                    bigDecimal2 = BigDecimal.valueOf(2L).pow(n6);
                    bigInteger = bigDecimal.multiply(bigDecimal2, mathContext).setScale(0, mathContext.getRoundingMode()).toBigIntegerExact();
                }
                if (bigInteger.testBit(n3)) {
                    ++n5;
                    continue;
                }
                return new BigInteger[]{bl ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ZERO, bigInteger};
            }
            n6 = n4 + n3 - n5;
            if (n6 < 0) {
                bigDecimal2 = BigDecimal.valueOf(2L).pow(-n6);
                bigInteger = bigDecimal.divide(bigDecimal2, mathContext).setScale(0, mathContext.getRoundingMode()).toBigIntegerExact();
            } else {
                bigDecimal2 = BigDecimal.valueOf(2L).pow(n6);
                bigInteger = bigDecimal.multiply(bigDecimal2, mathContext).setScale(0, mathContext.getRoundingMode()).toBigIntegerExact();
            }
            if (bigInteger.testBit(n3)) break;
            if (bigInteger.testBit(n3 + 1)) {
                ++n5;
                continue;
            }
            --n5;
        }
        return new BigInteger[]{bl ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.valueOf(n5), bigInteger};
    }

    private static int ilog2(BigDecimal bigDecimal, MathContext mathContext) {
        int n = (int)((((long)bigDecimal.precision() - (long)bigDecimal.scale() - 1L) * 100000L + (long)(bigDecimal.unscaledValue().toString().charAt(0) - 48) * 10000L) / 30103L);
        n += 3;
        while (true) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(2L).pow(Math.abs(n));
            if (n < 0) {
                bigDecimal2 = BigDecimal.ONE.divide(bigDecimal2, mathContext);
            }
            if (bigDecimal2.compareTo(bigDecimal) <= 0) {
                return n;
            }
            --n;
        }
    }
}

