/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.format;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.ast.XNOperator;
import com.kreative.openxion.ast.XNOperatorPrecedence;
import com.kreative.openxion.format.ExpressionFormatStringComponent;
import com.kreative.openxion.format.FSBinaryExpression;
import com.kreative.openxion.format.FSExpression;
import com.kreative.openxion.format.FSLiteralExpression;
import com.kreative.openxion.format.FSParameterExpression;
import com.kreative.openxion.format.FSUnaryExpression;
import com.kreative.openxion.format.FormatString;
import com.kreative.openxion.format.FormatStringComponent;
import com.kreative.openxion.format.Formatter;
import com.kreative.openxion.format.LiteralFormatStringComponent;
import com.kreative.openxion.format.ParameterFormatStringComponent;
import com.kreative.openxion.format.TrimmingFormatter;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMString;
import java.math.BigDecimal;

public class FSParser {
    private XNContext ctx;
    private String text;
    private int pos;

    public FSParser(XNContext xNContext, String string) {
        this.ctx = xNContext;
        this.text = string;
        this.pos = 0;
    }

    public FormatString parseFormatString() {
        FormatString formatString = new FormatString();
        while (this.pos < this.text.length()) {
            formatString.add(this.parseFormatStringComponent());
        }
        return formatString;
    }

    private FormatStringComponent parseFormatStringComponent() {
        if (this.text.charAt(this.pos) == '^') {
            ++this.pos;
            if (this.pos < this.text.length()) {
                if (Character.isDigit(this.text.charAt(this.pos))) {
                    return this.parseParameterFormatStringComponent();
                }
                switch (this.text.charAt(this.pos)) {
                    case '{': {
                        ++this.pos;
                        return this.parseExpressionFormatStringComponent();
                    }
                    case '}': {
                        ++this.pos;
                        return new LiteralFormatStringComponent("}");
                    }
                    case '|': {
                        ++this.pos;
                        return new LiteralFormatStringComponent("|");
                    }
                    case '^': {
                        ++this.pos;
                        return new LiteralFormatStringComponent("^");
                    }
                }
                return new LiteralFormatStringComponent("^");
            }
            return new LiteralFormatStringComponent("^");
        }
        return this.parseLiteralFormatStringComponent();
    }

    private LiteralFormatStringComponent parseLiteralFormatStringComponent() {
        int n = this.pos;
        this.pos = this.text.indexOf(94, this.pos);
        if (this.pos < 0) {
            this.pos = this.text.length();
        }
        return new LiteralFormatStringComponent(this.text.substring(n, this.pos));
    }

    private ParameterFormatStringComponent parseParameterFormatStringComponent() {
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        String string = "";
        String string2 = " ";
        Formatter formatter = Formatter.StringFormatter;
        while (this.pos < this.text.length() && Character.isDigit(this.text.charAt(this.pos))) {
            n *= 10;
            n += Character.getNumericValue(this.text.charAt(this.pos));
            ++this.pos;
        }
        while (this.pos + 1 < this.text.length() && (this.text.charAt(this.pos) == 'l' || this.text.charAt(this.pos) == 'r' || (this.text.charAt(this.pos) == 'n' || this.text.charAt(this.pos) == 'm') && Character.isDigit(this.text.charAt(this.pos + 1)))) {
            switch (this.text.charAt(this.pos)) {
                case 'l': {
                    if (!bl) {
                        bl = true;
                        string = "";
                        string2 = "";
                    }
                    string = string + Character.toString(this.text.charAt(this.pos + 1));
                    this.pos += 2;
                    break;
                }
                case 'r': {
                    if (!bl) {
                        bl = true;
                        string = "";
                        string2 = "";
                    }
                    string2 = string2 + Character.toString(this.text.charAt(this.pos + 1));
                    this.pos += 2;
                    break;
                }
                case 'n': {
                    ++this.pos;
                    n2 = 0;
                    while (this.pos < this.text.length() && Character.isDigit(this.text.charAt(this.pos))) {
                        n2 *= 10;
                        n2 += Character.getNumericValue(this.text.charAt(this.pos));
                        ++this.pos;
                    }
                    break;
                }
                case 'm': {
                    ++this.pos;
                    n3 = 0;
                    while (this.pos < this.text.length() && Character.isDigit(this.text.charAt(this.pos))) {
                        n3 *= 10;
                        n3 += Character.getNumericValue(this.text.charAt(this.pos));
                        ++this.pos;
                    }
                    break;
                }
            }
        }
        if (this.pos < this.text.length() && Character.isLetter(this.text.charAt(this.pos))) {
            formatter = Formatter.forTypeSpecifier(this.text.charAt(this.pos));
            ++this.pos;
        }
        if (this.pos < this.text.length() && this.text.charAt(this.pos) == '~') {
            ++this.pos;
        }
        return new ParameterFormatStringComponent(n, new TrimmingFormatter(n2, n3, string, string2, formatter));
    }

    private ExpressionFormatStringComponent parseExpressionFormatStringComponent() {
        FSExpression fSExpression = this.parseExpression();
        ExpressionFormatStringComponent expressionFormatStringComponent = new ExpressionFormatStringComponent(fSExpression);
        while (this.pos < this.text.length() && Character.isWhitespace(this.text.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos < this.text.length() && this.text.charAt(this.pos) == '?') {
            ++this.pos;
        }
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '}') {
            FormatString formatString = new FormatString();
            while (this.pos < this.text.length() && this.text.charAt(this.pos) != '|' && this.text.charAt(this.pos) != '}') {
                formatString.add(this.parseFormatStringSubcomponent());
            }
            if (this.pos < this.text.length() && this.text.charAt(this.pos) == '|') {
                ++this.pos;
            }
            expressionFormatStringComponent.add(formatString);
        }
        if (this.pos < this.text.length() && this.text.charAt(this.pos) == '}') {
            ++this.pos;
        }
        return expressionFormatStringComponent;
    }

    private FormatStringComponent parseFormatStringSubcomponent() {
        if (this.text.charAt(this.pos) == '^') {
            ++this.pos;
            if (this.pos < this.text.length()) {
                if (Character.isDigit(this.text.charAt(this.pos))) {
                    return this.parseParameterFormatStringComponent();
                }
                switch (this.text.charAt(this.pos)) {
                    case '{': {
                        ++this.pos;
                        return this.parseExpressionFormatStringComponent();
                    }
                    case '}': {
                        ++this.pos;
                        return new LiteralFormatStringComponent("}");
                    }
                    case '|': {
                        ++this.pos;
                        return new LiteralFormatStringComponent("|");
                    }
                    case '^': {
                        ++this.pos;
                        return new LiteralFormatStringComponent("^");
                    }
                }
                return new LiteralFormatStringComponent("^");
            }
            return new LiteralFormatStringComponent("^");
        }
        return this.parseLiteralFormatStringSubcomponent();
    }

    private LiteralFormatStringComponent parseLiteralFormatStringSubcomponent() {
        int n;
        int n2;
        int n3 = this.pos;
        int n4 = this.text.indexOf(94, this.pos);
        if (n4 < 0) {
            n4 = this.text.length();
        }
        if ((n2 = this.text.indexOf(124, this.pos)) < 0) {
            n2 = this.text.length();
        }
        if ((n = this.text.indexOf(125, this.pos)) < 0) {
            n = this.text.length();
        }
        this.pos = Math.min(n4, Math.min(n2, n));
        return new LiteralFormatStringComponent(this.text.substring(n3, this.pos));
    }

    private void skipWhitespace() {
        while (this.pos < this.text.length() && Character.isWhitespace(this.text.charAt(this.pos))) {
            ++this.pos;
        }
    }

    private XNOperator lookOperator(boolean bl) {
        String string = this.text.substring(this.pos);
        if (string.startsWith("&&&&")) {
            return XNOperator.BIT_AND;
        }
        if (string.startsWith("^^^^")) {
            return XNOperator.BIT_XOR;
        }
        if (string.startsWith("||||")) {
            return XNOperator.BIT_OR;
        }
        if (string.startsWith("~")) {
            return XNOperator.BIT_NOT;
        }
        if (string.startsWith("%%")) {
            return XNOperator.MOD;
        }
        if (string.startsWith("\\\\")) {
            return XNOperator.DIV;
        }
        if (string.startsWith("\\")) {
            return XNOperator.QUOT;
        }
        if (string.startsWith("^")) {
            return XNOperator.EXPONENT;
        }
        if (string.startsWith("-")) {
            return bl ? XNOperator.UNARY_SUBTRACT : XNOperator.SUBTRACT;
        }
        if (string.startsWith("::")) {
            return XNOperator.LIST_APPEND;
        }
        if (string.startsWith(":")) {
            return XNOperator.LIST_APPEND;
        }
        if (string.startsWith("@@")) {
            return XNOperator.LIST_CONCAT;
        }
        if (string.startsWith("@")) {
            return XNOperator.LIST_CONCAT;
        }
        if (string.startsWith("!==")) {
            return XNOperator.NOT_STRICT_EQUAL;
        }
        if (string.startsWith("!=")) {
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("!")) {
            return XNOperator.NOT;
        }
        if (string.startsWith("**")) {
            return XNOperator.EXPONENT;
        }
        if (string.startsWith("*")) {
            return XNOperator.MULTIPLY;
        }
        if (string.startsWith("/")) {
            return XNOperator.DIVIDE;
        }
        if (string.startsWith("\u00b7")) {
            return XNOperator.MULTIPLY;
        }
        if (string.startsWith("\u00d7")) {
            return XNOperator.MULTIPLY;
        }
        if (string.startsWith("\u00f7")) {
            return XNOperator.DIVIDE;
        }
        if (string.startsWith("\u2212")) {
            return bl ? XNOperator.UNARY_SUBTRACT : XNOperator.SUBTRACT;
        }
        if (string.startsWith("\u2260\u2260\u2260")) {
            return XNOperator.NOT_STRICT_EQUAL;
        }
        if (string.startsWith("\u2260\u2260")) {
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("\u2260")) {
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("\u2264")) {
            return XNOperator.LE_NUM;
        }
        if (string.startsWith("\u2265")) {
            return XNOperator.GE_NUM;
        }
        if (string.startsWith("&&&")) {
            return XNOperator.SHORT_AND;
        }
        if (string.startsWith("&&")) {
            return XNOperator.STR_CONCAT_SPACE;
        }
        if (string.startsWith("&")) {
            return XNOperator.STR_CONCAT;
        }
        if (string.startsWith("%")) {
            return XNOperator.REM;
        }
        if (string.startsWith("+")) {
            return XNOperator.ADD;
        }
        if (string.startsWith("<=>")) {
            return XNOperator.CMP_NUM;
        }
        if (string.startsWith("<<")) {
            return XNOperator.SHIFT_LEFT;
        }
        if (string.startsWith("<=")) {
            return XNOperator.LE_NUM;
        }
        if (string.startsWith("<>")) {
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("<")) {
            return XNOperator.LT_NUM;
        }
        if (string.startsWith("===")) {
            return XNOperator.STRICT_EQUAL;
        }
        if (string.startsWith("==")) {
            return XNOperator.EQUAL;
        }
        if (string.startsWith("=<")) {
            return XNOperator.LE_NUM;
        }
        if (string.startsWith("=>")) {
            return XNOperator.GE_NUM;
        }
        if (string.startsWith("=")) {
            return XNOperator.EQUAL;
        }
        if (string.startsWith(">>>")) {
            return XNOperator.SHIFT_RIGHT_UNSIGNED;
        }
        if (string.startsWith(">>")) {
            return XNOperator.SHIFT_RIGHT_SIGNED;
        }
        if (string.startsWith(">=")) {
            return XNOperator.GE_NUM;
        }
        if (string.startsWith(">")) {
            return XNOperator.GT_NUM;
        }
        if (string.startsWith("|||")) {
            return XNOperator.SHORT_OR;
        }
        if (string.startsWith("||")) {
            return XNOperator.STR_CONCAT;
        }
        return XNOperator.NULL;
    }

    private XNOperator parseOperator(boolean bl) {
        String string = this.text.substring(this.pos);
        if (string.startsWith("&&&&")) {
            this.pos += 4;
            return XNOperator.BIT_AND;
        }
        if (string.startsWith("^^^^")) {
            this.pos += 4;
            return XNOperator.BIT_XOR;
        }
        if (string.startsWith("||||")) {
            this.pos += 4;
            return XNOperator.BIT_OR;
        }
        if (string.startsWith("~")) {
            ++this.pos;
            return XNOperator.BIT_NOT;
        }
        if (string.startsWith("%%")) {
            this.pos += 2;
            return XNOperator.MOD;
        }
        if (string.startsWith("\\\\")) {
            this.pos += 2;
            return XNOperator.DIV;
        }
        if (string.startsWith("\\")) {
            ++this.pos;
            return XNOperator.QUOT;
        }
        if (string.startsWith("^")) {
            ++this.pos;
            return XNOperator.EXPONENT;
        }
        if (string.startsWith("-")) {
            ++this.pos;
            return bl ? XNOperator.UNARY_SUBTRACT : XNOperator.SUBTRACT;
        }
        if (string.startsWith("::")) {
            this.pos += 2;
            return XNOperator.LIST_APPEND;
        }
        if (string.startsWith(":")) {
            ++this.pos;
            return XNOperator.LIST_APPEND;
        }
        if (string.startsWith("@@")) {
            this.pos += 2;
            return XNOperator.LIST_CONCAT;
        }
        if (string.startsWith("@")) {
            ++this.pos;
            return XNOperator.LIST_CONCAT;
        }
        if (string.startsWith("!==")) {
            this.pos += 3;
            return XNOperator.NOT_STRICT_EQUAL;
        }
        if (string.startsWith("!=")) {
            this.pos += 2;
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("!")) {
            ++this.pos;
            return XNOperator.NOT;
        }
        if (string.startsWith("**")) {
            this.pos += 2;
            return XNOperator.EXPONENT;
        }
        if (string.startsWith("*")) {
            ++this.pos;
            return XNOperator.MULTIPLY;
        }
        if (string.startsWith("/")) {
            ++this.pos;
            return XNOperator.DIVIDE;
        }
        if (string.startsWith("\u00b7")) {
            ++this.pos;
            return XNOperator.MULTIPLY;
        }
        if (string.startsWith("\u00d7")) {
            ++this.pos;
            return XNOperator.MULTIPLY;
        }
        if (string.startsWith("\u00f7")) {
            ++this.pos;
            return XNOperator.DIVIDE;
        }
        if (string.startsWith("\u2212")) {
            ++this.pos;
            return bl ? XNOperator.UNARY_SUBTRACT : XNOperator.SUBTRACT;
        }
        if (string.startsWith("\u2260\u2260\u2260")) {
            this.pos += 3;
            return XNOperator.NOT_STRICT_EQUAL;
        }
        if (string.startsWith("\u2260\u2260")) {
            this.pos += 2;
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("\u2260")) {
            ++this.pos;
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("\u2264")) {
            ++this.pos;
            return XNOperator.LE_NUM;
        }
        if (string.startsWith("\u2265")) {
            ++this.pos;
            return XNOperator.GE_NUM;
        }
        if (string.startsWith("&&&")) {
            this.pos += 3;
            return XNOperator.SHORT_AND;
        }
        if (string.startsWith("&&")) {
            this.pos += 2;
            return XNOperator.STR_CONCAT_SPACE;
        }
        if (string.startsWith("&")) {
            ++this.pos;
            return XNOperator.STR_CONCAT;
        }
        if (string.startsWith("%")) {
            ++this.pos;
            return XNOperator.REM;
        }
        if (string.startsWith("+")) {
            ++this.pos;
            return XNOperator.ADD;
        }
        if (string.startsWith("<=>")) {
            this.pos += 3;
            return XNOperator.CMP_NUM;
        }
        if (string.startsWith("<<")) {
            this.pos += 2;
            return XNOperator.SHIFT_LEFT;
        }
        if (string.startsWith("<=")) {
            this.pos += 2;
            return XNOperator.LE_NUM;
        }
        if (string.startsWith("<>")) {
            this.pos += 2;
            return XNOperator.NOT_EQUAL;
        }
        if (string.startsWith("<")) {
            ++this.pos;
            return XNOperator.LT_NUM;
        }
        if (string.startsWith("===")) {
            this.pos += 3;
            return XNOperator.STRICT_EQUAL;
        }
        if (string.startsWith("==")) {
            this.pos += 2;
            return XNOperator.EQUAL;
        }
        if (string.startsWith("=<")) {
            this.pos += 2;
            return XNOperator.LE_NUM;
        }
        if (string.startsWith("=>")) {
            this.pos += 2;
            return XNOperator.GE_NUM;
        }
        if (string.startsWith("=")) {
            ++this.pos;
            return XNOperator.EQUAL;
        }
        if (string.startsWith(">>>")) {
            this.pos += 3;
            return XNOperator.SHIFT_RIGHT_UNSIGNED;
        }
        if (string.startsWith(">>")) {
            this.pos += 2;
            return XNOperator.SHIFT_RIGHT_SIGNED;
        }
        if (string.startsWith(">=")) {
            this.pos += 2;
            return XNOperator.GE_NUM;
        }
        if (string.startsWith(">")) {
            ++this.pos;
            return XNOperator.GT_NUM;
        }
        if (string.startsWith("|||")) {
            this.pos += 3;
            return XNOperator.SHORT_OR;
        }
        if (string.startsWith("||")) {
            this.pos += 2;
            return XNOperator.STR_CONCAT;
        }
        return XNOperator.NULL;
    }

    private FSExpression parseFactor() {
        this.skipWhitespace();
        if (this.pos < this.text.length()) {
            if (this.lookOperator(true).precedence() == XNOperatorPrecedence.UNARY) {
                XNOperator xNOperator = this.parseOperator(true);
                FSExpression fSExpression = this.parseFactor();
                return new FSUnaryExpression(xNOperator, fSExpression);
            }
            if (this.text.charAt(this.pos) == '(') {
                ++this.pos;
                FSExpression fSExpression = this.parseExpression();
                this.skipWhitespace();
                if (this.pos < this.text.length() && this.text.charAt(this.pos) == ')') {
                    ++this.pos;
                }
                return fSExpression;
            }
            if (this.text.charAt(this.pos) == '\"') {
                int n = this.pos++;
                while (this.pos < this.text.length() && this.text.charAt(this.pos) != '\n' && this.text.charAt(this.pos) != '\r' && this.text.charAt(this.pos) != '\u2028' && this.text.charAt(this.pos) != '\u2029') {
                    if (this.text.charAt(this.pos) == '\"') {
                        ++this.pos;
                        break;
                    }
                    if (this.text.charAt(this.pos) == '\\') {
                        this.pos += 2;
                        continue;
                    }
                    ++this.pos;
                }
                return new FSLiteralExpression(new XOMString(XIONUtil.unquote(this.text.substring(n, this.pos), this.ctx.getTextEncoding())));
            }
            if (Character.isDigit(this.text.charAt(this.pos)) || this.text.charAt(this.pos) == '.') {
                StringBuffer stringBuffer = new StringBuffer();
                while (Character.isDigit(this.text.charAt(this.pos)) || this.text.charAt(this.pos) == '.' && stringBuffer.indexOf(".") < 0) {
                    stringBuffer.append(this.text.charAt(this.pos));
                    ++this.pos;
                }
                return new FSLiteralExpression(new XOMNumber(new BigDecimal(stringBuffer.toString())));
            }
            if (this.text.charAt(this.pos) == '^' && this.pos + 1 < this.text.length() && Character.isDigit(this.text.charAt(this.pos + 1))) {
                ++this.pos;
                int n = 0;
                while (this.pos < this.text.length() && Character.isDigit(this.text.charAt(this.pos))) {
                    n *= 10;
                    n += Character.getNumericValue(this.text.charAt(this.pos));
                    ++this.pos;
                }
                if (this.pos < this.text.length() && this.text.charAt(this.pos) == '~') {
                    ++this.pos;
                }
                return new FSParameterExpression(n);
            }
            int n = this.pos++;
            while (this.pos < this.text.length() && (Character.isLetterOrDigit(this.text.charAt(this.pos)) || this.text.charAt(this.pos) == '_' || this.text.charAt(this.pos) == '.' || this.text.charAt(this.pos) == '\'')) {
                ++this.pos;
            }
            return new FSLiteralExpression(new XOMString(this.text.substring(n, this.pos)));
        }
        return new FSLiteralExpression(XOMEmpty.EMPTY);
    }

    private FSExpression parseExpExp() {
        FSExpression fSExpression = this.parseFactor();
        this.skipWhitespace();
        if (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.EXPONENT) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpExp();
            return new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
        }
        return fSExpression;
    }

    private FSExpression parseExpMul() {
        FSExpression fSExpression = this.parseExpExp();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.MULTIPLY) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpExp();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpAdd() {
        FSExpression fSExpression = this.parseExpMul();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.ADD) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpMul();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpShift() {
        FSExpression fSExpression = this.parseExpAdd();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.SHIFT) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpAdd();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpBitAnd() {
        FSExpression fSExpression = this.parseExpShift();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.BIT_AND) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpShift();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpBitXor() {
        FSExpression fSExpression = this.parseExpBitAnd();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.BIT_XOR) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpBitAnd();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpBitOr() {
        FSExpression fSExpression = this.parseExpBitXor();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.BIT_OR) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpBitXor();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpStrConcat() {
        FSExpression fSExpression = this.parseExpBitOr();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.STR_CONCAT) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpBitOr();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpListConcat() {
        FSExpression fSExpression = this.parseExpStrConcat();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.LIST_CONCAT) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpStrConcat();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpRel() {
        FSExpression fSExpression = this.parseExpListConcat();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.RELATION) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpListConcat();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpEqual() {
        FSExpression fSExpression = this.parseExpRel();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.EQUAL) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpRel();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpAnd() {
        FSExpression fSExpression = this.parseExpEqual();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.AND) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpEqual();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }

    private FSExpression parseExpression() {
        FSExpression fSExpression = this.parseExpAnd();
        this.skipWhitespace();
        while (this.pos < this.text.length() && this.text.charAt(this.pos) != '?' && this.text.charAt(this.pos) != '}' && this.lookOperator(false).precedence() == XNOperatorPrecedence.OR) {
            XNOperator xNOperator = this.parseOperator(false);
            FSExpression fSExpression2 = this.parseExpAnd();
            fSExpression = new FSBinaryExpression(fSExpression, xNOperator, fSExpression2);
            this.skipWhitespace();
        }
        return fSExpression;
    }
}

