/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.format;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.math.BaseConvert;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMDate;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.type.XOMBinaryType;
import com.kreative.openxion.xom.type.XOMComplexType;
import com.kreative.openxion.xom.type.XOMDateType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMNumberType;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.List;

public abstract class Formatter {
    public static final Formatter StringFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            return xOMVariant.toTextString(xNContext);
        }
    };
    public static final Formatter ListFormatter = new Formatter(){

        @Override
        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            return this.formatList(xNContext, xOMVariant.toPrimitiveList(xNContext));
        }

        private String formatList(XNContext xNContext, List<? extends XOMVariant> list) {
            StringBuffer stringBuffer = new StringBuffer();
            for (XOMVariant xOMVariant : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                if (xOMVariant instanceof XOMList) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.formatList(xNContext, xOMVariant.toPrimitiveList(xNContext)));
                    stringBuffer.append(")");
                    continue;
                }
                stringBuffer.append(xOMVariant.toTextString(xNContext));
            }
            return stringBuffer.toString();
        }
    };
    public static final Formatter IntegerFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            return xOMInteger.toTextString(xNContext);
        }
    };
    public static final Formatter LocalIntegerFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            if (xOMInteger.isUndefined()) {
                return xOMInteger.toTextString(xNContext);
            }
            return NumberFormat.getIntegerInstance().format(xOMInteger.toLong());
        }
    };
    public static final Formatter NumberFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            return xOMNumber.toTextString(xNContext);
        }
    };
    public static final Formatter LocalNumberFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            if (xOMNumber.isUndefined()) {
                return xOMNumber.toTextString(xNContext);
            }
            return NumberFormat.getNumberInstance().format(xOMNumber.toDouble());
        }
    };
    public static final Formatter OctalFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            return BaseConvert.bc(xOMNumber.toBigDecimal(), 8, xNContext.getMathContext());
        }
    };
    public static final Formatter UCHexFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            return BaseConvert.bc(xOMNumber.toBigDecimal(), 16, xNContext.getMathContext()).toUpperCase();
        }
    };
    public static final Formatter LCHexFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            return BaseConvert.bc(xOMNumber.toBigDecimal(), 16, xNContext.getMathContext()).toLowerCase();
        }
    };
    public static final Formatter ComplexFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            return xOMComplex.toTextString(xNContext);
        }
    };
    public static final Formatter LocalComplexFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
            if (xOMComplex.isUndefined()) {
                return xOMComplex.toTextString(xNContext);
            }
            if (xOMComplex.isReal()) {
                return NumberFormat.getNumberInstance().format(xOMComplex.toDoubles()[0]);
            }
            double[] dArray = xOMComplex.toDoubles();
            if (dArray[1] < 0.0) {
                return NumberFormat.getNumberInstance().format(dArray[0]) + NumberFormat.getNumberInstance().format(dArray[1]) + "i";
            }
            return NumberFormat.getNumberInstance().format(dArray[0]) + "+" + NumberFormat.getNumberInstance().format(dArray[1]) + "i";
        }
    };
    public static final Formatter DateFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMDate xOMDate = (XOMDate)XOMDateType.instance.makeInstanceFrom(xNContext, xOMVariant);
            return xOMDate.dateEquivalent().toTextString(xNContext);
        }
    };
    public static final Formatter LocalDateFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMDate xOMDate = (XOMDate)XOMDateType.instance.makeInstanceFrom(xNContext, xOMVariant);
            return DateFormat.getDateInstance().format(xOMDate.toDate());
        }
    };
    public static final Formatter TimeFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMDate xOMDate = (XOMDate)XOMDateType.instance.makeInstanceFrom(xNContext, xOMVariant);
            return xOMDate.timeEquivalent().toTextString(xNContext);
        }
    };
    public static final Formatter LocalTimeFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMDate xOMDate = (XOMDate)XOMDateType.instance.makeInstanceFrom(xNContext, xOMVariant);
            return DateFormat.getTimeInstance().format(xOMDate.toDate());
        }
    };
    public static final Formatter BinaryFormatter = new Formatter(){

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMBinary xOMBinary = (XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant);
            return xOMBinary.toTextString(xNContext);
        }
    };
    public static final Formatter LocalBinaryFormatter = new Formatter(){
        private final String[] LOOKUP_HEX = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};

        public String format(XNContext xNContext, XOMVariant xOMVariant) {
            XOMBinary xOMBinary = (XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant);
            StringBuffer stringBuffer = new StringBuffer();
            for (byte by : xOMBinary.toByteArray()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.LOOKUP_HEX[by & 0xFF]);
            }
            return stringBuffer.toString();
        }
    };

    public abstract String format(XNContext var1, XOMVariant var2);

    public static final Formatter forTypeSpecifier(char c) {
        switch (c) {
            case 's': {
                return StringFormatter;
            }
            case 'S': {
                return StringFormatter;
            }
            case 'l': {
                return StringFormatter;
            }
            case 'L': {
                return ListFormatter;
            }
            case 'i': {
                return IntegerFormatter;
            }
            case 'I': {
                return LocalIntegerFormatter;
            }
            case 'n': {
                return NumberFormatter;
            }
            case 'N': {
                return LocalNumberFormatter;
            }
            case 'o': {
                return OctalFormatter;
            }
            case 'O': {
                return OctalFormatter;
            }
            case 'h': {
                return LCHexFormatter;
            }
            case 'H': {
                return UCHexFormatter;
            }
            case 'c': {
                return ComplexFormatter;
            }
            case 'C': {
                return LocalComplexFormatter;
            }
            case 'd': {
                return DateFormatter;
            }
            case 'D': {
                return LocalDateFormatter;
            }
            case 't': {
                return TimeFormatter;
            }
            case 'T': {
                return LocalTimeFormatter;
            }
            case 'b': {
                return BinaryFormatter;
            }
            case 'B': {
                return LocalBinaryFormatter;
            }
        }
        return StringFormatter;
    }
}

