/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.format;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.format.Formatter;
import com.kreative.openxion.xom.XOMVariant;

public class TrimmingFormatter
extends Formatter {
    private int minLength;
    private int maxLength;
    private String leftPad;
    private String rightPad;
    private Formatter formatter;

    public TrimmingFormatter(Formatter formatter) {
        this(0, Integer.MAX_VALUE, null, " ", formatter);
    }

    public TrimmingFormatter(int n, Formatter formatter) {
        this(n, n, null, " ", formatter);
    }

    public TrimmingFormatter(int n, int n2, Formatter formatter) {
        this(n, n2, null, " ", formatter);
    }

    public TrimmingFormatter(int n, int n2, String string, String string2, Formatter formatter) {
        this.minLength = n < 0 ? 0 : n;
        this.maxLength = n2 < n ? n : n2;
        String string3 = this.leftPad = string == null || string.length() == 0 ? null : string;
        this.rightPad = string2 == null || string2.length() == 0 ? (string == null || string.length() == 0 ? " " : null) : string2;
        this.formatter = formatter;
    }

    public String format(XNContext xNContext, XOMVariant xOMVariant) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formatter.format(xNContext, xOMVariant));
        if (this.rightPad != null) {
            if (this.leftPad == null) {
                if (stringBuffer.length() < this.minLength) {
                    while (stringBuffer.length() < this.minLength) {
                        stringBuffer.append(this.rightPad);
                    }
                    stringBuffer.delete(this.minLength, stringBuffer.length());
                } else if (stringBuffer.length() > this.maxLength) {
                    stringBuffer.delete(this.maxLength, stringBuffer.length());
                }
            } else if (stringBuffer.length() < this.minLength) {
                while (stringBuffer.length() < this.minLength) {
                    stringBuffer.insert(0, this.leftPad);
                    stringBuffer.append(this.rightPad);
                }
                stringBuffer.delete(0, (stringBuffer.length() - this.minLength) / 2);
                stringBuffer.delete(this.minLength, stringBuffer.length());
            } else if (stringBuffer.length() > this.maxLength) {
                stringBuffer.delete(0, (stringBuffer.length() - this.maxLength) / 2);
                stringBuffer.delete(this.maxLength, stringBuffer.length());
            }
        } else if (stringBuffer.length() < this.minLength) {
            while (stringBuffer.length() < this.minLength) {
                stringBuffer.insert(0, this.leftPad);
            }
            stringBuffer.delete(0, stringBuffer.length() - this.minLength);
        } else if (stringBuffer.length() > this.maxLength) {
            stringBuffer.delete(0, stringBuffer.length() - this.maxLength);
        }
        return stringBuffer.toString();
    }
}

