/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.io.XNIOStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URLConnection;

public class XNURLConnectionIOStream
implements XNIOStream {
    private URLConnection conn;
    private DataInputStream in;
    private DataOutputStream out;

    public XNURLConnectionIOStream(URLConnection uRLConnection) {
        this.conn = uRLConnection;
        this.in = null;
        this.out = null;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public DataInputStream in() throws IOException {
        if (this.in == null) {
            this.in = new DataInputStream(this.conn.getInputStream());
        }
        return this.in;
    }

    public DataOutputStream out() throws IOException {
        if (this.out == null) {
            this.out = new DataOutputStream(this.conn.getOutputStream());
        }
        return this.out;
    }

    public long getFilePointer() throws IOException {
        throw new IOException("URLs do not support the at keyword");
    }

    public long length() throws IOException {
        return this.conn.getContentLength();
    }

    public int lookahead() throws IOException {
        if (this.in().markSupported()) {
            this.in().mark(16);
            int n = this.in().read();
            this.in().reset();
            return n;
        }
        return -1;
    }

    public int read() throws IOException {
        return this.in().read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.in().read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in().read(byArray, n, n2);
    }

    public boolean readBoolean() throws IOException {
        return this.in().readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in().readByte();
    }

    public char readChar() throws IOException {
        return this.in().readChar();
    }

    public double readDouble() throws IOException {
        return this.in().readDouble();
    }

    public float readFloat() throws IOException {
        return this.in().readFloat();
    }

    public void readFully(byte[] byArray) throws IOException, EOFException {
        this.in().readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException, EOFException {
        this.in().readFully(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.in().readInt();
    }

    public String readLine() throws IOException {
        return this.in().readLine();
    }

    public long readLong() throws IOException {
        return this.in().readLong();
    }

    public short readShort() throws IOException {
        return this.in().readShort();
    }

    public String readUTF() throws IOException {
        return this.in().readUTF();
    }

    public int readUnsignedByte() throws IOException {
        return this.in().readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in().readUnsignedShort();
    }

    public void seek(long l) throws IOException {
        throw new IOException("URLs do not support the at keyword");
    }

    public void setLength(long l) throws IOException {
        throw new IOException("URLs do not support truncation");
    }

    public int skipBytes(int n) throws IOException {
        return this.in().skipBytes(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.out().write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out().write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.out().write(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.out().writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.out().writeByte(n);
    }

    public void writeBytes(String string) throws IOException {
        this.out().writeBytes(string);
    }

    public void writeChar(int n) throws IOException {
        this.out().writeChar(n);
    }

    public void writeChars(String string) throws IOException {
        this.out().writeChars(string);
    }

    public void writeDouble(double d) throws IOException {
        this.out().writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.out().writeFloat(f);
    }

    public void writeInt(int n) throws IOException {
        this.out().writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.out().writeLong(l);
    }

    public void writeShort(int n) throws IOException {
        this.out().writeShort(n);
    }

    public void writeUTF(String string) throws IOException {
        this.out().writeUTF(string);
    }
}

