/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.tr;

import com.kreative.openxion.tr.Deletor;
import com.kreative.openxion.tr.Matchor;
import com.kreative.openxion.tr.Squeezor;
import com.kreative.openxion.tr.TrCachedCharacterSet;
import com.kreative.openxion.tr.TrCharacterSet;
import com.kreative.openxion.tr.TrCollectionCharacterSet;
import com.kreative.openxion.tr.TrComplementCharacterSet;
import com.kreative.openxion.tr.TrRangeCharacterSet;
import com.kreative.openxion.tr.TrSingleCharacterSet;
import com.kreative.openxion.tr.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrPattern {
    private static Map<String, TrPattern> patterns = new HashMap<String, TrPattern>();
    private static Map<String, TrPattern> cpatterns = new HashMap<String, TrPattern>();
    private TrCharacterSet set;
    private String pattern;
    private static final Pattern RANGE_PATTERN = Pattern.compile("^([^-])-(.)", 32);

    public static TrPattern compile(String string, boolean bl) {
        Map<String, TrPattern> map;
        Map<String, TrPattern> map2 = map = bl ? cpatterns : patterns;
        if (map.containsKey(string)) {
            return map.get(string);
        }
        TrPattern trPattern = new TrPattern(string, bl);
        map.put(string, trPattern);
        return trPattern;
    }

    public static Translator translator(TrPattern trPattern, TrPattern trPattern2) {
        return new Translator(trPattern.set, trPattern2.set);
    }

    public Deletor deletor() {
        return new Deletor(this.set);
    }

    public Squeezor squeezor() {
        return new Squeezor(this.set);
    }

    public Matchor matchor() {
        return new Matchor(this.set);
    }

    private TrPattern(String string, boolean bl) {
        ArrayList<TrCharacterSet> arrayList = new ArrayList<TrCharacterSet>();
        int n = 0;
        Matcher matcher = null;
        while (n < string.length()) {
            int n2;
            matcher = RANGE_PATTERN.matcher(string.substring(n));
            if (matcher.find() && matcher.start() == 0) {
                n += matcher.end();
                arrayList.add(new TrRangeCharacterSet(matcher.group(1).codePointAt(0), matcher.group(2).codePointAt(0) + 1));
                continue;
            }
            if ((n2 = string.codePointAt(n++)) >= 65536) {
                ++n;
            }
            arrayList.add(new TrSingleCharacterSet(n2));
        }
        this.set = new TrCollectionCharacterSet(arrayList);
        if (bl) {
            this.set = new TrComplementCharacterSet(this.set);
        }
        this.set = new TrCachedCharacterSet(this.set);
        this.pattern = string;
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof TrPattern) {
            TrPattern trPattern = (TrPattern)object;
            return this.pattern.equals(trPattern.pattern);
        }
        return false;
    }
}

