/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

import com.kreative.openxion.util.HalfFloat;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BinaryNumericChunkType {
    TINYINT(1, false),
    SHORTINT(2, false),
    MEDIUMINT(4, false),
    LONGINT(8, false),
    HALFFLOAT(2, true),
    SINGLEFLOAT(4, true),
    DOUBLEFLOAT(8, true);

    private int length;
    private boolean isFloat;

    private BinaryNumericChunkType(int n2, boolean bl) {
        this.length = n2;
        this.isFloat = bl;
    }

    public int length() {
        return this.length;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    private long getBits(byte[] byArray, boolean bl) {
        long l = 0L;
        if (bl) {
            for (int i = byArray.length - 1; i >= 0; --i) {
                l <<= 8;
                l |= (long)(byArray[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                l <<= 8;
                l |= (long)(byArray[i] & 0xFF);
            }
        }
        return l;
    }

    public BigInteger bigIntegerValueOf(byte[] byArray, boolean bl, boolean bl2) {
        long l = this.getBits(byArray, bl2);
        if (this.isFloat) {
            switch (this.length) {
                case 2: {
                    return BigInteger.valueOf((long)HalfFloat.intBitsToHalfFloat((int)l).floatValue());
                }
                case 4: {
                    return BigInteger.valueOf((long)Float.intBitsToFloat((int)l));
                }
                case 8: {
                    return BigInteger.valueOf((long)Double.longBitsToDouble(l));
                }
            }
            return BigInteger.ZERO;
        }
        if (bl) {
            if (l < 0L) {
                BigInteger bigInteger = BigInteger.valueOf(Long.MIN_VALUE).abs();
                return bigInteger.add(bigInteger).add(BigInteger.valueOf(l));
            }
            return BigInteger.valueOf(l);
        }
        switch (this.length) {
            case 1: {
                return BigInteger.valueOf((byte)l);
            }
            case 2: {
                return BigInteger.valueOf((short)l);
            }
            case 4: {
                return BigInteger.valueOf((int)l);
            }
            case 8: {
                return BigInteger.valueOf(l);
            }
        }
        return BigInteger.ZERO;
    }

    public BigDecimal bigDecimalValueOf(byte[] byArray, boolean bl, boolean bl2) {
        long l = this.getBits(byArray, bl2);
        if (this.isFloat) {
            switch (this.length) {
                case 2: {
                    return BigDecimal.valueOf(HalfFloat.intBitsToHalfFloat((int)l).floatValue());
                }
                case 4: {
                    return BigDecimal.valueOf(Float.intBitsToFloat((int)l));
                }
                case 8: {
                    return BigDecimal.valueOf(Double.longBitsToDouble(l));
                }
            }
            return BigDecimal.ZERO;
        }
        if (bl) {
            if (l < 0L) {
                BigDecimal bigDecimal = BigDecimal.valueOf(Long.MIN_VALUE).abs();
                return bigDecimal.add(bigDecimal).add(BigDecimal.valueOf(l));
            }
            return BigDecimal.valueOf(l);
        }
        switch (this.length) {
            case 1: {
                return BigDecimal.valueOf((byte)l);
            }
            case 2: {
                return BigDecimal.valueOf((short)l);
            }
            case 4: {
                return BigDecimal.valueOf((int)l);
            }
            case 8: {
                return BigDecimal.valueOf(l);
            }
        }
        return BigDecimal.ZERO;
    }

    private byte[] putBits(long l, boolean bl) {
        byte[] byArray = new byte[this.length];
        if (bl) {
            for (int i = 0; i < this.length; ++i) {
                byArray[i] = (byte)l;
                l >>>= 8;
            }
        } else {
            for (int i = this.length - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>>= 8;
            }
        }
        return byArray;
    }

    public byte[] byteArrayValueOf(int n, boolean bl) {
        long l;
        if (this.isFloat) {
            switch (this.length) {
                case 2: {
                    l = HalfFloat.halfFloatToRawIntBits(new HalfFloat(n));
                    break;
                }
                case 4: {
                    l = Float.floatToRawIntBits(n);
                    break;
                }
                case 8: {
                    l = Double.doubleToRawLongBits(n);
                    break;
                }
                default: {
                    l = 0L;
                    break;
                }
            }
        } else {
            l = n;
        }
        return this.putBits(l, bl);
    }

    public byte[] byteArrayValueOf(long l, boolean bl) {
        long l2;
        if (this.isFloat) {
            switch (this.length) {
                case 2: {
                    l2 = HalfFloat.halfFloatToRawIntBits(new HalfFloat(l));
                    break;
                }
                case 4: {
                    l2 = Float.floatToRawIntBits(l);
                    break;
                }
                case 8: {
                    l2 = Double.doubleToRawLongBits(l);
                    break;
                }
                default: {
                    l2 = 0L;
                    break;
                }
            }
        } else {
            l2 = l;
        }
        return this.putBits(l2, bl);
    }

    public byte[] byteArrayValueOf(float f, boolean bl) {
        long l;
        if (this.isFloat) {
            switch (this.length) {
                case 2: {
                    l = HalfFloat.halfFloatToRawIntBits(new HalfFloat(f));
                    break;
                }
                case 4: {
                    l = Float.floatToRawIntBits(f);
                    break;
                }
                case 8: {
                    l = Double.doubleToRawLongBits(f);
                    break;
                }
                default: {
                    l = 0L;
                    break;
                }
            }
        } else {
            l = (long)f;
        }
        return this.putBits(l, bl);
    }

    public byte[] byteArrayValueOf(double d, boolean bl) {
        long l;
        if (this.isFloat) {
            switch (this.length) {
                case 2: {
                    l = HalfFloat.halfFloatToRawIntBits(new HalfFloat(d));
                    break;
                }
                case 4: {
                    l = Float.floatToRawIntBits((float)d);
                    break;
                }
                case 8: {
                    l = Double.doubleToRawLongBits(d);
                    break;
                }
                default: {
                    l = 0L;
                    break;
                }
            }
        } else {
            l = (long)d;
        }
        return this.putBits(l, bl);
    }

    public String toString() {
        return this.name().toLowerCase().replace("int", "Int").replace("float", "Float");
    }

    public String toPluralString() {
        return this.name().toLowerCase().replace("int", "Int").replace("float", "Float") + "s";
    }
}

