/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.util;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNInterpreter;
import com.kreative.openxion.XNLexer;
import com.kreative.openxion.XNParser;
import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNDictionaryExpression;
import com.kreative.openxion.ast.XNExpression;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.ast.XNVariantDescriptor;
import com.kreative.openxion.xom.XOMVariable;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMDictionary;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMString;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIONUtil {
    public static final int INDEX_ANY = Integer.MIN_VALUE;
    public static final int INDEX_MIDDLE = -2147483647;
    public static final int INDEX_PREVIOUS = -2147483646;
    public static final int INDEX_CURRENT = -2147483645;
    public static final int INDEX_NEXT = -2147483644;
    public static final int INDEX_RECENT = -2147483643;
    private static final Random indexRand = new Random();
    private static final String REGEX_MATCH_CHARS = "\\.()[]{}*+?^$|";
    private static final String REGEX_REPLACE_CHARS = "\\$";
    private static final String[] LOOKUP_HEX = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static String osString = null;
    private static String unString = null;
    private static String ufnString = null;

    private XIONUtil() {
    }

    public static String toTitleCase(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = ' ';
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (!Character.isLetter(c)) {
                stringBuffer.append(Character.toTitleCase(c2));
            } else {
                stringBuffer.append(Character.toLowerCase(c2));
            }
            c = c2;
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static String reverseString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.last();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = stringCharacterIterator.previous();
        }
        return stringBuffer.toString();
    }

    public static String normalizeVarName(String string) {
        return string == null ? "" : string.toLowerCase().trim().replaceAll(" +", " ");
    }

    public static XOMVariant parseDescriptor(XNContext xNContext, String string) {
        try {
            XNLexer xNLexer = new XNLexer(string, new StringReader(string));
            XNParser xNParser = new XNParser(xNContext, xNLexer);
            if (xNParser.lookListExpression(1, null)) {
                XNExpression xNExpression = xNParser.getListExpression(null);
                if (xNExpression instanceof XNVariantDescriptor) {
                    if (xNParser.getToken().isEOF()) {
                        return new XNInterpreter(xNContext).evaluateExpression(xNExpression);
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XOMVariable parseVariableName(XNContext xNContext, String string) {
        try {
            XNLexer xNLexer = new XNLexer(string, new StringReader(string));
            XNToken xNToken = xNLexer.getToken();
            XNToken xNToken2 = xNLexer.getToken();
            if (xNToken.kind == 3 && xNToken2.isEOF()) {
                return new XOMVariable(xNContext.getVariableMap(xNToken.image), xNToken.image);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean canParseDictionary(XNContext xNContext, String string) {
        try {
            XNLexer xNLexer = new XNLexer(string, new StringReader(string));
            XNParser xNParser = new XNParser(xNContext, xNLexer);
            if (xNParser.lookListExpression(1, null)) {
                XNExpression xNExpression = xNParser.getListExpression(null);
                if (xNExpression instanceof XNDictionaryExpression) {
                    return xNParser.getToken().isEOF();
                }
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static XOMDictionary parseDictionary(XNContext xNContext, String string) {
        try {
            XNLexer xNLexer = new XNLexer(string, new StringReader(string));
            XNParser xNParser = new XNParser(xNContext, xNLexer);
            if (xNParser.lookListExpression(1, null)) {
                XNExpression xNExpression = xNParser.getListExpression(null);
                if (xNExpression instanceof XNDictionaryExpression) {
                    if (xNParser.getToken().isEOF()) {
                        return (XOMDictionary)new XNInterpreter(xNContext).evaluateExpression(xNExpression);
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string.length() / 10 + 2);
        stringBuffer.append('\"');
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\u0007': {
                    stringBuffer.append("\\a");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\u000b': {
                    stringBuffer.append("\\v");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\u000e': {
                    stringBuffer.append("\\o");
                    break;
                }
                case '\u000f': {
                    stringBuffer.append("\\i");
                    break;
                }
                case '\u001a': {
                    stringBuffer.append("\\z");
                    break;
                }
                case '\u001b': {
                    stringBuffer.append("\\e");
                    break;
                }
                case '\u007f': {
                    stringBuffer.append("\\d");
                    break;
                }
                case '\u2028': {
                    stringBuffer.append("\\u2028");
                    break;
                }
                case '\u2029': {
                    stringBuffer.append("\\u2029");
                    break;
                }
                default: {
                    if (Character.getType(c) == 15) {
                        String string2 = "0000" + Integer.toHexString(c).toUpperCase();
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unquote(String string, String string2) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                c = stringCharacterIterator.next();
                switch (c) {
                    case '\\': {
                        stringBuffer.append("\\");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("'");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("\"");
                        break;
                    }
                    case ' ': {
                        stringBuffer.append(" ");
                        break;
                    }
                    case '0': {
                        stringBuffer.append("\u0000");
                        break;
                    }
                    case 'a': {
                        stringBuffer.append("\u0007");
                        break;
                    }
                    case 'b': {
                        stringBuffer.append("\b");
                        break;
                    }
                    case 'd': {
                        stringBuffer.append("\u007f");
                        break;
                    }
                    case 'e': {
                        stringBuffer.append("\u001b");
                        break;
                    }
                    case 'f': {
                        stringBuffer.append("\f");
                        break;
                    }
                    case 'i': {
                        stringBuffer.append("\u000f");
                        break;
                    }
                    case 'l': {
                        stringBuffer.append("\r\n");
                        break;
                    }
                    case 'n': {
                        stringBuffer.append("\n");
                        break;
                    }
                    case 'o': {
                        stringBuffer.append("\u000e");
                        break;
                    }
                    case 'r': {
                        stringBuffer.append("\r");
                        break;
                    }
                    case 't': {
                        stringBuffer.append("\t");
                        break;
                    }
                    case 'v': {
                        stringBuffer.append("\u000b");
                        break;
                    }
                    case 'z': {
                        stringBuffer.append("\u001a");
                        break;
                    }
                    case 'C': {
                        stringBuffer.append("\ufff0");
                        break;
                    }
                    case 'R': {
                        stringBuffer.append("\ufff1");
                        break;
                    }
                    case 'P': {
                        stringBuffer.append("\ufff2");
                        break;
                    }
                    case 'S': {
                        stringBuffer.append("\ufff3");
                        break;
                    }
                    case 'E': {
                        stringBuffer.append("\uffff");
                        break;
                    }
                    case 'x': {
                        char c2;
                        char c3;
                        char c4 = stringCharacterIterator.next();
                        char c5 = stringCharacterIterator.next();
                        char c6 = c4 >= '0' && c4 <= '9' ? c4 - 48 : (c4 >= 'A' && c4 <= 'F' ? c4 - 65 + 10 : (c3 = c4 >= 'a' && c4 <= 'f' ? c4 - 97 + 10 : (char)'\uffffffff'));
                        char c7 = c5 >= '0' && c5 <= '9' ? c5 - 48 : (c5 >= 'A' && c5 <= 'F' ? c5 - 65 + 10 : (c2 = c5 >= 'a' && c5 <= 'f' ? c5 - 97 + 10 : (char)'\uffffffff'));
                        if (c3 < '\u0000' || c2 < '\u0000') {
                            stringBuffer.append("\\x");
                            if (c4 != '\uffff') {
                                stringBuffer.append(c4);
                            }
                            if (c5 == '\uffff') break;
                            stringBuffer.append(c5);
                            break;
                        }
                        try {
                            byte[] byArray = new byte[]{(byte)(c3 << 4 | c2)};
                            String string3 = new String(byArray, string2);
                            stringBuffer.append(string3);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            stringBuffer.append((char)(c3 << 4 | c2));
                        }
                        break;
                    }
                    case 'u': {
                        int n12;
                        int n2;
                        int n3;
                        int n4;
                        char c4 = stringCharacterIterator.next();
                        char c5 = stringCharacterIterator.next();
                        char c3 = stringCharacterIterator.next();
                        char c2 = stringCharacterIterator.next();
                        int n5 = c4 >= '0' && c4 <= '9' ? c4 - 48 : (c4 >= 'A' && c4 <= 'F' ? c4 - 65 + 10 : (n4 = c4 >= 'a' && c4 <= 'f' ? c4 - 97 + 10 : -1));
                        int n6 = c5 >= '0' && c5 <= '9' ? c5 - 48 : (c5 >= 'A' && c5 <= 'F' ? c5 - 65 + 10 : (n3 = c5 >= 'a' && c5 <= 'f' ? c5 - 97 + 10 : -1));
                        int n7 = c3 >= '0' && c3 <= '9' ? c3 - 48 : (c3 >= 'A' && c3 <= 'F' ? c3 - 65 + 10 : (n2 = c3 >= 'a' && c3 <= 'f' ? c3 - 97 + 10 : -1));
                        int n8 = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'F' ? c2 - 65 + 10 : (n12 = c2 >= 'a' && c2 <= 'f' ? c2 - 97 + 10 : -1));
                        if (n4 < 0 || n3 < 0 || n2 < 0 || n12 < 0) {
                            stringBuffer.append("\\u");
                            if (c4 != '\uffff') {
                                stringBuffer.append(c4);
                            }
                            if (c5 != '\uffff') {
                                stringBuffer.append(c5);
                            }
                            if (c3 != '\uffff') {
                                stringBuffer.append(c3);
                            }
                            if (c2 == '\uffff') break;
                            stringBuffer.append(c2);
                            break;
                        }
                        stringBuffer.append((char)(n4 << 12 | n3 << 8 | n2 << 4 | n12));
                        break;
                    }
                    case 'w': {
                        int n;
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n2;
                        char c4 = stringCharacterIterator.next();
                        char c5 = stringCharacterIterator.next();
                        char c3 = stringCharacterIterator.next();
                        char c2 = stringCharacterIterator.next();
                        char c8 = stringCharacterIterator.next();
                        char c9 = stringCharacterIterator.next();
                        int n13 = c4 >= '0' && c4 <= '9' ? c4 - 48 : (c4 >= 'A' && c4 <= 'F' ? c4 - 65 + 10 : (n2 = c4 >= 'a' && c4 <= 'f' ? c4 - 97 + 10 : -1));
                        int n14 = c5 >= '0' && c5 <= '9' ? c5 - 48 : (c5 >= 'A' && c5 <= 'F' ? c5 - 65 + 10 : (n12 = c5 >= 'a' && c5 <= 'f' ? c5 - 97 + 10 : -1));
                        int n15 = c3 >= '0' && c3 <= '9' ? c3 - 48 : (c3 >= 'A' && c3 <= 'F' ? c3 - 65 + 10 : (n11 = c3 >= 'a' && c3 <= 'f' ? c3 - 97 + 10 : -1));
                        int n16 = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'F' ? c2 - 65 + 10 : (n10 = c2 >= 'a' && c2 <= 'f' ? c2 - 97 + 10 : -1));
                        int n17 = c8 >= '0' && c8 <= '9' ? c8 - 48 : (c8 >= 'A' && c8 <= 'F' ? c8 - 65 + 10 : (n9 = c8 >= 'a' && c8 <= 'f' ? c8 - 97 + 10 : -1));
                        int n18 = c9 >= '0' && c9 <= '9' ? c9 - 48 : (c9 >= 'A' && c9 <= 'F' ? c9 - 65 + 10 : (n = c9 >= 'a' && c9 <= 'f' ? c9 - 97 + 10 : -1));
                        if (n2 < 0 || n12 < 0 || n11 < 0 || n10 < 0 || n9 < 0 || n < 0) {
                            stringBuffer.append("\\w");
                            if (c4 != '\uffff') {
                                stringBuffer.append(c4);
                            }
                            if (c5 != '\uffff') {
                                stringBuffer.append(c5);
                            }
                            if (c3 != '\uffff') {
                                stringBuffer.append(c3);
                            }
                            if (c2 != '\uffff') {
                                stringBuffer.append(c2);
                            }
                            if (c8 != '\uffff') {
                                stringBuffer.append(c8);
                            }
                            if (c9 == '\uffff') break;
                            stringBuffer.append(c9);
                            break;
                        }
                        int n19 = n2 << 20 | n12 << 16 | n11 << 12 | n10 << 8 | n9 << 4 | n;
                        stringBuffer.append(Character.toChars(n19));
                        break;
                    }
                    case '\uffff': {
                        stringBuffer.append("\\");
                        break;
                    }
                    default: {
                        stringBuffer.append("\\" + c);
                        break;
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static int[] index(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 - n + 1 > 0 ? n + indexRand.nextInt(n2 - n + 1) : n;
        int n8 = n + (n2 - n + 1) / 2;
        if (n5 < 0) {
            switch (n5) {
                case -2147483648: {
                    n5 = n7;
                    break;
                }
                case -2147483647: {
                    n5 = n8;
                    break;
                }
                case -2147483646: {
                    n5 = n3 - 1;
                    if (n5 >= n) break;
                    n5 = n2;
                    break;
                }
                case -2147483645: {
                    n5 = n3;
                    break;
                }
                case -2147483644: {
                    n5 = n3 + 1;
                    if (n5 <= n2) break;
                    n5 = n;
                    break;
                }
                case -2147483643: {
                    n5 = n4;
                    break;
                }
                default: {
                    n5 += n2 + 1;
                }
            }
        }
        if (n6 < 0) {
            switch (n6) {
                case -2147483648: {
                    n6 = n7;
                    break;
                }
                case -2147483647: {
                    n6 = n8;
                    break;
                }
                case -2147483646: {
                    n6 = n3 - 1;
                    if (n6 >= n) break;
                    n6 = n2;
                    break;
                }
                case -2147483645: {
                    n6 = n3;
                    break;
                }
                case -2147483644: {
                    n6 = n3 + 1;
                    if (n6 <= n2) break;
                    n6 = n;
                    break;
                }
                case -2147483643: {
                    n6 = n4;
                    break;
                }
                default: {
                    n6 += n2 + 1;
                }
            }
        }
        return new int[]{n5, n6};
    }

    public static int[] index(int n, int n2, int n3, int n4) {
        int n5 = n2 - n + 1 > 0 ? n + indexRand.nextInt(n2 - n + 1) : n;
        int n6 = n + (n2 - n + 1) / 2;
        if (n3 < 0) {
            switch (n3) {
                case -2147483648: {
                    n3 = n5;
                    break;
                }
                case -2147483647: {
                    n3 = n6;
                    break;
                }
                default: {
                    n3 += n2 + 1;
                }
            }
        }
        if (n4 < 0) {
            switch (n4) {
                case -2147483648: {
                    n4 = n5;
                    break;
                }
                case -2147483647: {
                    n4 = n6;
                    break;
                }
                default: {
                    n4 += n2 + 1;
                }
            }
        }
        return new int[]{n3, n4};
    }

    public static Random getRandom() {
        return indexRand;
    }

    public static String makeRegexForExactMatch(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (REGEX_MATCH_CHARS.contains("" + c)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static String makeRegexForExactReplace(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (REGEX_REPLACE_CHARS.contains("" + c)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static byte[] binarySubstring(byte[] byArray, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray, n, byArray.length - n);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] binarySubstring(byte[] byArray, int n, int n2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray, n, n2 - n);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] binaryConcat(byte[] byArray, byte[] byArray2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] binaryConcat(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray3);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean binaryEndsWith(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        int n = byArray.length - byArray2.length;
        for (int i = 0; n < byArray.length && i < byArray2.length; ++n, ++i) {
            if (byArray[n] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static String binaryToString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (byte by : byArray) {
            stringBuffer.append(LOOKUP_HEX[by & 0xFF]);
        }
        return stringBuffer.toString();
    }

    public static String urlQueryEncode(XNContext xNContext, Map<String, XOMVariant> map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Map.Entry<String, XOMVariant> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append('&');
            }
            String string2 = entry.getKey();
            try {
                string2 = URLEncoder.encode(string2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = URLEncoder.encode(string2);
            }
            XOMVariant xOMVariant = entry.getValue();
            if (xOMVariant instanceof XOMList) {
                boolean bl2 = true;
                for (XOMVariant xOMVariant2 : ((XOMList)xOMVariant).toVariantList(xNContext)) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuffer.append('&');
                    }
                    String string3 = xOMVariant2.toTextString(xNContext);
                    try {
                        string3 = URLEncoder.encode(string3, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string3 = URLEncoder.encode(string3);
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append("[]");
                    stringBuffer.append('=');
                    stringBuffer.append(string3);
                }
                continue;
            }
            String string4 = xOMVariant.toTextString(xNContext);
            try {
                string4 = URLEncoder.encode(string4, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string4 = URLEncoder.encode(string4);
            }
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public static Map<String, XOMVariant> urlQueryDecode(XNContext xNContext, String string, String string2) {
        String[] stringArray = string.split("&");
        TreeMap<String, XOMVariant> treeMap = new TreeMap<String, XOMVariant>();
        for (String string3 : stringArray) {
            String[] stringArray2 = string3.split("=", 2);
            String string4 = stringArray2.length > 0 ? stringArray2[0] : "";
            String string5 = stringArray2.length > 1 ? stringArray2[1] : "";
            try {
                string4 = URLDecoder.decode(string4, string2);
                string5 = URLDecoder.decode(string5, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string4 = URLDecoder.decode(string4);
                string5 = URLDecoder.decode(string5);
            }
            if (string4.length() <= 0) continue;
            if (string4.endsWith("[]")) {
                if (treeMap.containsKey(string4 = string4.substring(0, string4.length() - 2))) {
                    if (treeMap.get(string4) instanceof XOMList) {
                        Vector<? extends XOMVariant> vector = new Vector<XOMVariant>();
                        vector.addAll(((XOMList)treeMap.get(string4)).toVariantList(xNContext));
                        vector.add(new XOMString(string5));
                        treeMap.put(string4, new XOMList(vector));
                        continue;
                    }
                    treeMap.put(string4, new XOMList((XOMVariant)treeMap.get(string4), new XOMString(string5)));
                    continue;
                }
                treeMap.put(string4, new XOMString(string5));
                continue;
            }
            treeMap.put(string4, new XOMString(string5));
        }
        return treeMap;
    }

    public static File getAuxiliaryFile(File file, String string) {
        String string2 = file.getAbsolutePath();
        int n = 0;
        if (string2.endsWith(".xn")) {
            string2 = string2.substring(0, string2.length() - 3);
            n = 0;
        } else if (string2.endsWith(".Xn")) {
            string2 = string2.substring(0, string2.length() - 3);
            n = 1;
        } else if (string2.endsWith(".XN")) {
            string2 = string2.substring(0, string2.length() - 3);
            n = 2;
        } else if (string2.endsWith(".xN")) {
            string2 = string2.substring(0, string2.length() - 3);
            n = 3;
        }
        if (!string.startsWith(".")) {
            string2 = string2 + ".";
        }
        switch (n) {
            case 0: {
                string2 = string2 + string.toLowerCase();
                break;
            }
            case 1: {
                string2 = string2 + XIONUtil.toTitleCase(string);
                break;
            }
            case 2: {
                string2 = string2 + string.toUpperCase();
                break;
            }
            case 3: {
                string2 = string2 + XIONUtil.reverseString(XIONUtil.toTitleCase(XIONUtil.reverseString(string)));
            }
        }
        return new File(string2);
    }

    public static File getMessageFile(File file) {
        return XIONUtil.getAuxiliaryFile(file, "xnm");
    }

    public static File getTranslatedMessageFile(File file) {
        String string;
        try {
            string = System.getProperty("user.language");
        }
        catch (Exception exception) {
            string = "en";
        }
        return XIONUtil.getAuxiliaryFile(file, "xnm." + string + ".xnm");
    }

    public static File getLocalMessageFile(File file) {
        String string;
        String string2;
        try {
            string2 = System.getProperty("user.language");
            string = System.getProperty("user.country");
        }
        catch (Exception exception) {
            string2 = "en";
            string = "US";
        }
        return XIONUtil.getAuxiliaryFile(file, "xnm." + string2 + "." + string + ".xnm");
    }

    public static Map<String, String> getMessagesFromMessageFile(File file, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Scanner scanner = new Scanner(file, string);
            block2: while (scanner.hasNextLine()) {
                String string2 = scanner.nextLine().trim();
                if (string2.length() <= 0 || string2.startsWith("#")) continue;
                while (scanner.hasNextLine()) {
                    String string3 = scanner.nextLine().trim();
                    if (string3.length() <= 0 || string3.startsWith("#")) continue;
                    hashMap.put(XIONUtil.unquote(string2, string), XIONUtil.unquote(string3, string));
                    continue block2;
                }
            }
            scanner.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashMap;
    }

    public static Map<String, String> getMessagesForScriptFile(File file, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(XIONUtil.getMessagesFromMessageFile(XIONUtil.getMessageFile(file), string));
        hashMap.putAll(XIONUtil.getMessagesFromMessageFile(XIONUtil.getTranslatedMessageFile(file), string));
        hashMap.putAll(XIONUtil.getMessagesFromMessageFile(XIONUtil.getLocalMessageFile(file), string));
        return hashMap;
    }

    public static boolean isMacOS() {
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        return osString.contains("MAC OS");
    }

    public static boolean isWindows() {
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        return osString.contains("WINDOWS");
    }

    public static String getUserName(XNContext xNContext, XNModifier xNModifier) {
        if (xNModifier == XNModifier.SHORT || xNModifier == XNModifier.ABBREVIATED) {
            if (unString != null) {
                return unString;
            }
            try {
                unString = System.getProperty("user.name");
                return unString;
            }
            catch (Exception exception) {
                unString = null;
                return "";
            }
        }
        if (ufnString != null) {
            return ufnString;
        }
        if (XIONUtil.isWindows()) {
            try {
                String string = XIONUtil.captureProcessOutput("net user " + System.getProperty("user.name"));
                String string2 = XIONUtil.captureProcessOutput("net user " + System.getProperty("user.name") + " /domain");
                Pattern pattern = Pattern.compile("[Ff]ull [Nn]ame\\s+(.*)");
                Matcher matcher = pattern.matcher(string);
                Matcher matcher2 = pattern.matcher(string2);
                if (matcher.find()) {
                    ufnString = matcher.group(1).trim();
                    return ufnString;
                }
                if (matcher2.find()) {
                    ufnString = matcher2.group(1).trim();
                    return ufnString;
                }
                ufnString = null;
                return "";
            }
            catch (Exception exception) {
                ufnString = null;
                return "";
            }
        }
        try {
            String[] stringArray = XIONUtil.captureProcessOutput(new String[]{"id", "-P"}).split(":");
            if (stringArray.length > 7) {
                ufnString = stringArray[7];
                return ufnString;
            }
            ufnString = null;
            return "";
        }
        catch (Exception exception) {
            ufnString = null;
            return "";
        }
    }

    public static String getApplicationPaths(XNContext xNContext) {
        String string = xNContext.getApplicationPaths();
        if (string != null) {
            return string;
        }
        String string2 = xNContext.getLineEnding();
        try {
            String string3;
            if (osString == null) {
                try {
                    osString = System.getProperty("os.name").toUpperCase();
                }
                catch (Exception exception) {
                    osString = "";
                }
            }
            if ((string3 = System.getProperty("user.home")).endsWith("/") || string3.endsWith("\\")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (osString.contains("MAC OS")) {
                return "/Applications/" + string2 + "/Applications/Utilities/" + string2 + "/Applications (Mac OS 9)/" + string2 + string3 + "/Applications/" + string2 + "/Developer/Applications/" + string2 + "/Developer/Applications/Utilities/" + string2 + "/bin/" + string2 + "/sbin/" + string2 + "/usr/bin/" + string2 + "/usr/sbin/" + string2 + "/usr/local/bin/" + string2 + "/usr/local/sbin/" + string2 + "/usr/shared/bin/" + string2 + "/usr/shared/sbin/" + string2 + "/opt/bin/" + string2 + "/opt/sbin/" + string2 + "/opt/local/bin/" + string2 + "/opt/local/sbin/" + string2 + "/opt/shared/bin/" + string2 + "/opt/shared/sbin/" + string2;
            }
            if (osString.contains("WINDOWS")) {
                return "C:\\Program Files\\" + string2 + "C:\\Windows\\" + string2 + "C:\\Windows\\System32\\" + string2;
            }
            return "/bin/" + string2 + "/sbin/" + string2 + "/usr/bin/" + string2 + "/usr/sbin/" + string2 + "/usr/local/bin/" + string2 + "/usr/local/sbin/" + string2 + "/usr/shared/bin/" + string2 + "/usr/shared/sbin/" + string2 + "/opt/bin/" + string2 + "/opt/sbin/" + string2 + "/opt/local/bin/" + string2 + "/opt/local/sbin/" + string2 + "/opt/shared/bin/" + string2 + "/opt/shared/sbin/" + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getDocumentPaths(XNContext xNContext) {
        String string = xNContext.getDocumentPaths();
        if (string != null) {
            return string;
        }
        String string2 = xNContext.getLineEnding();
        try {
            String string3;
            if (osString == null) {
                try {
                    osString = System.getProperty("os.name").toUpperCase();
                }
                catch (Exception exception) {
                    osString = "";
                }
            }
            if ((string3 = System.getProperty("user.home")).endsWith("/") || string3.endsWith("\\")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (osString.contains("MAC OS")) {
                return string3 + "/Desktop/" + string2 + string3 + "/Documents/" + string2 + string3 + "/Downloads/" + string2 + string3 + "/Pictures/" + string2 + string3 + "/Music/" + string2 + string3 + "/Movies/" + string2 + string3 + "/Public/" + string2 + string3 + "/Sites/" + string2 + string3 + "/" + string2;
            }
            if (osString.contains("WINDOWS")) {
                return string3 + "\\Desktop\\" + string2 + string3 + "\\My Documents\\" + string2 + string3 + "\\My Photos\\" + string2 + string3 + "\\My Music\\" + string2 + string3 + "\\My Videos\\" + string2 + string3 + "\\" + string2;
            }
            return string3 + "/" + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getIncludePaths(XNContext xNContext) {
        String string = xNContext.getIncludePaths();
        if (string != null) {
            return string;
        }
        String string2 = xNContext.getLineEnding();
        try {
            String string3 = System.getProperty("user.dir");
            return string3 + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static File locateApplication(XNContext xNContext, String string, boolean bl) {
        String[] stringArray;
        try {
            if (string.contains(System.getProperty("file.separator"))) {
                return new File(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        String[] stringArray2 = osString.contains("MAC OS") ? new String[]{"", ".app"} : (osString.contains("WINDOWS") ? new String[]{"", ".exe", ".com", ".bat"} : new String[]{"", ".sh"});
        for (String string2 : stringArray = XIONUtil.getApplicationPaths(xNContext).split("(\r|\n|\u2028|\u2029)+")) {
            for (String string3 : stringArray2) {
                File file = new File(string2, string + string3);
                if (file == null || !file.exists()) continue;
                return file;
            }
        }
        if (bl) {
            return xNContext.getUI().answerFile("Where is " + string + "?", new String[0], 0, 0);
        }
        return null;
    }

    public static File locateApplicationOrDocument(XNContext xNContext, String string, boolean bl) {
        String[] stringArray;
        try {
            if (string.contains(System.getProperty("file.separator"))) {
                return new File(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        String[] stringArray2 = osString.contains("MAC OS") ? new String[]{"", ".app"} : (osString.contains("WINDOWS") ? new String[]{"", ".exe", ".com", ".bat"} : new String[]{"", ".sh"});
        String[] stringArray3 = stringArray = XIONUtil.getApplicationPaths(xNContext).split("(\r|\n|\u2028|\u2029)+");
        int n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray3[i];
            for (String string3 : stringArray2) {
                File file = new File(string2, string + string3);
                if (file == null || !file.exists()) continue;
                return file;
            }
        }
        for (String string4 : stringArray3 = XIONUtil.getDocumentPaths(xNContext).split("(\r|\n|\u2028|\u2029)+")) {
            File file = new File(string4, string);
            if (file == null || !file.exists()) continue;
            return file;
        }
        if (bl) {
            return xNContext.getUI().answerFile("Where is " + string + "?", new String[0], 0, 0);
        }
        return null;
    }

    public static File locateDocument(XNContext xNContext, String string, boolean bl) {
        String[] stringArray;
        try {
            if (string.contains(System.getProperty("file.separator"))) {
                return new File(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string2 : stringArray = XIONUtil.getDocumentPaths(xNContext).split("(\r|\n|\u2028|\u2029)+")) {
            File file = new File(string2, string);
            if (file == null || !file.exists()) continue;
            return file;
        }
        if (bl) {
            return xNContext.getUI().answerFile("Where is " + string + "?", new String[0], 0, 0);
        }
        return null;
    }

    public static File locateInclude(XNContext xNContext, String string, boolean bl) {
        String[] stringArray;
        try {
            if (string.contains(System.getProperty("file.separator"))) {
                return new File(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray2 = new String[]{"", ".xn"};
        for (String string2 : stringArray = XIONUtil.getIncludePaths(xNContext).split("(\r|\n|\u2028|\u2029)+")) {
            for (String string3 : stringArray2) {
                File file = new File(string2, string + string3);
                if (file == null || !file.exists()) continue;
                return file;
            }
        }
        if (bl) {
            return xNContext.getUI().answerFile("Where is " + string + "?", new String[0], 0, 0);
        }
        return null;
    }

    public static void launch(File file) throws IOException {
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        if (osString.contains("MAC OS")) {
            Runtime.getRuntime().exec(new String[]{"open", file.getAbsolutePath()});
        } else if (osString.contains("WINDOWS")) {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"X\"", file.getAbsolutePath()});
        } else {
            Runtime.getRuntime().exec(new String[]{file.getAbsolutePath()});
        }
    }

    public static void launch(File file, File file2) throws IOException {
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        if (osString.contains("MAC OS")) {
            Runtime.getRuntime().exec(new String[]{"open", "-a", file.getAbsolutePath(), file2.getAbsolutePath()});
        } else if (osString.contains("WINDOWS")) {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"X\"", file.getAbsolutePath(), file2.getAbsolutePath()});
        } else {
            Runtime.getRuntime().exec(new String[]{file.getAbsolutePath(), file2.getAbsolutePath()});
        }
    }

    public static void unlaunch(File file) throws IOException {
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        if (!osString.contains("MAC OS")) {
            throw new IOException("Inter-process communication not supported");
        }
        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"" + file.getAbsolutePath() + "\" to quit"});
    }

    public static void unlaunch(File file, File file2) throws IOException {
        if (osString == null) {
            try {
                osString = System.getProperty("os.name").toUpperCase();
            }
            catch (Exception exception) {
                osString = "";
            }
        }
        if (!osString.contains("MAC OS")) {
            throw new IOException("Inter-process communication not supported");
        }
        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"" + file.getAbsolutePath() + "\" to close (every document whose path is \"" + file2.getAbsolutePath() + "\")"});
    }

    public static String captureProcessOutput(String string) throws IOException {
        return XIONUtil.captureProcessOutput(Runtime.getRuntime().exec(string));
    }

    public static String captureProcessOutput(String[] stringArray) throws IOException {
        return XIONUtil.captureProcessOutput(Runtime.getRuntime().exec(stringArray));
    }

    public static String captureProcessOutput(Process process) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ((InputStream)bufferedInputStream).close();
        byteArrayOutputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }
}

