/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNInterpreter;
import com.kreative.openxion.ast.XNExpression;
import com.kreative.openxion.ast.XNVariableScope;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMDate;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMDateType;
import com.kreative.openxion.xom.type.XOMNumberType;
import com.kreative.openxion.xom.type.XOMStringType;
import java.math.BigDecimal;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMComparator
implements Comparator<XOMVariant> {
    public static final int ORDER_ASCENDING = 0;
    public static final int ORDER_DESCENDING = 1;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_INTERNATIONAL = 1;
    public static final int TYPE_NUMERIC = 2;
    public static final int TYPE_DATETIME = 3;
    private Collator coll = Collator.getInstance();
    private XNInterpreter interp;
    private XNContext ctx;
    private int order;
    private int type;
    private XNExpression filter;
    private IdentityHashMap<XOMVariant, Object> map;

    public XOMComparator(XNContext xNContext) {
        this(xNContext, 0, 0, null);
    }

    public XOMComparator(XNContext xNContext, int n) {
        this(xNContext, 0, n, null);
    }

    public XOMComparator(XNContext xNContext, int n, int n2) {
        this(xNContext, n, n2, null);
    }

    public XOMComparator(XNContext xNContext, XNExpression xNExpression) {
        this(xNContext, 0, 0, xNExpression);
    }

    public XOMComparator(XNContext xNContext, int n, XNExpression xNExpression) {
        this(xNContext, 0, n, xNExpression);
    }

    public XOMComparator(XNContext xNContext, int n, int n2, XNExpression xNExpression) {
        this.coll.setStrength(0);
        this.coll.setDecomposition(1);
        this.interp = new XNInterpreter(xNContext);
        this.ctx = xNContext;
        this.order = n;
        this.type = n2;
        this.filter = xNExpression;
        this.map = new IdentityHashMap();
    }

    public int getSortOrder() {
        return this.order;
    }

    public int getSortType() {
        return this.type;
    }

    public XNExpression getSortFilter() {
        return this.filter;
    }

    public Object getKey(XOMVariant xOMVariant) {
        if (this.map.containsKey(xOMVariant)) {
            return this.map.get(xOMVariant);
        }
        if (this.filter != null && this.interp != null) {
            this.ctx.setVariableScope("each", XNVariableScope.LOCAL);
            this.ctx.getVariableMap("each").declareVariable(this.ctx, "each", XOMStringType.instance, xOMVariant);
            xOMVariant = this.interp.evaluateExpression(this.filter);
        }
        switch (this.type) {
            case 0: {
                try {
                    String string = ((XOMString)XOMStringType.instance.makeInstanceFrom(this.ctx, xOMVariant)).toTextString(this.ctx);
                    this.map.put(xOMVariant, string);
                    return string;
                }
                catch (Exception exception) {
                    String string = xOMVariant.toTextString(this.ctx);
                    this.map.put(xOMVariant, string);
                    return string;
                }
            }
            case 1: {
                try {
                    CollationKey collationKey = this.coll.getCollationKey(((XOMString)XOMStringType.instance.makeInstanceFrom(this.ctx, xOMVariant)).toTextString(this.ctx));
                    this.map.put(xOMVariant, collationKey);
                    return collationKey;
                }
                catch (Exception exception) {
                    String string = xOMVariant.toTextString(this.ctx);
                    this.map.put(xOMVariant, string);
                    return string;
                }
            }
            case 2: {
                try {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(this.ctx, xOMVariant, false);
                    Number number = xOMNumber.isUndefined() ? Double.valueOf(xOMNumber.toDouble()) : xOMNumber.toBigDecimal();
                    this.map.put(xOMVariant, number);
                    return number;
                }
                catch (Exception exception) {
                    String string = xOMVariant.toTextString(this.ctx);
                    this.map.put(xOMVariant, string);
                    return string;
                }
            }
            case 3: {
                try {
                    GregorianCalendar gregorianCalendar = ((XOMDate)XOMDateType.instance.makeInstanceFrom(this.ctx, xOMVariant)).toCalendar();
                    this.map.put(xOMVariant, gregorianCalendar);
                    return gregorianCalendar;
                }
                catch (Exception exception) {
                    String string = xOMVariant.toTextString(this.ctx);
                    this.map.put(xOMVariant, string);
                    return string;
                }
            }
        }
        String string = xOMVariant.toTextString(this.ctx);
        this.map.put(xOMVariant, string);
        return string;
    }

    @Override
    public int compare(XOMVariant xOMVariant, XOMVariant xOMVariant2) {
        int n;
        Object object = this.getKey(xOMVariant);
        Object object2 = this.getKey(xOMVariant2);
        if (object instanceof CollationKey && object2 instanceof CollationKey) {
            n = ((CollationKey)object).compareTo((CollationKey)object2);
        } else if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
            n = ((BigDecimal)object).compareTo((BigDecimal)object2);
        } else if ((object instanceof BigDecimal || object instanceof Double) && (object2 instanceof BigDecimal || object2 instanceof Double)) {
            double d = object instanceof BigDecimal ? ((BigDecimal)object).doubleValue() : ((Double)object).doubleValue();
            double d2 = object2 instanceof BigDecimal ? ((BigDecimal)object2).doubleValue() : ((Double)object2).doubleValue();
            n = Double.compare(d, d2);
        } else {
            n = object instanceof Calendar && object2 instanceof Calendar ? ((Calendar)object).compareTo((Calendar)object2) : (object instanceof String && object2 instanceof String ? ((String)object).compareToIgnoreCase((String)object2) : xOMVariant.toTextString(this.ctx).compareToIgnoreCase(xOMVariant2.toTextString(this.ctx)));
        }
        switch (this.order) {
            case 0: {
                return n;
            }
            case 1: {
                return -n;
            }
        }
        return n;
    }
}

