/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.xom.XOMComparator;
import com.kreative.openxion.xom.XOMVariableMap;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.inst.XOMDictionary;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMStringType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XOMVariable
extends XOMVariant {
    private static final long serialVersionUID = 1L;
    private XOMVariableMap vm;
    private String name;

    public XOMVariable(XOMVariableMap xOMVariableMap, String string) {
        this.vm = xOMVariableMap;
        this.name = string;
    }

    @Override
    public final XOMVariant asValue(XNContext xNContext) {
        if (this.vm.isVariableDeclared(xNContext, this.name)) {
            return this.vm.getVariable(xNContext, this.name).asValue(xNContext);
        }
        return new XOMString(this.name);
    }

    @Override
    public final XOMVariant asPrimitive(XNContext xNContext) {
        if (this.vm.isVariableDeclared(xNContext, this.name)) {
            return this.vm.getVariable(xNContext, this.name).asPrimitive(xNContext);
        }
        return new XOMString(this.name);
    }

    @Override
    public final XOMVariant asContainer(XNContext xNContext, boolean bl) {
        if (!this.vm.isVariableDeclared(xNContext, this.name)) {
            this.vm.declareVariable(xNContext, this.name, XOMStringType.instance, XOMEmpty.EMPTY);
        }
        return this;
    }

    @Override
    public final XOMVariable asVariable(XNContext xNContext, boolean bl) {
        if (!this.vm.isVariableDeclared(xNContext, this.name)) {
            this.vm.declareVariable(xNContext, this.name, XOMStringType.instance, XOMEmpty.EMPTY);
        }
        return this;
    }

    @Override
    public final boolean canGetParent(XNContext xNContext) {
        return this.getContents(xNContext).canGetParent(xNContext);
    }

    @Override
    public final XOMVariant getParent(XNContext xNContext) {
        return this.getContents(xNContext).getParent(xNContext);
    }

    @Override
    public final boolean canDelete(XNContext xNContext) {
        return this.getContents(xNContext).canDelete(xNContext);
    }

    @Override
    public final void delete(XNContext xNContext) {
        this.getContents(xNContext).delete(xNContext);
    }

    @Override
    public final boolean canGetContents(XNContext xNContext) {
        return true;
    }

    @Override
    public final XOMVariant getContents(XNContext xNContext) {
        if (this.vm.isVariableDeclared(xNContext, this.name)) {
            return this.vm.getVariable(xNContext, this.name);
        }
        return XOMEmpty.EMPTY;
    }

    @Override
    public final boolean canPutContents(XNContext xNContext) {
        return true;
    }

    @Override
    public final void putIntoContents(XNContext xNContext, XOMVariant xOMVariant) {
        this.vm.setVariable(xNContext, this.name, xOMVariant.asPrimitive(xNContext));
    }

    @Override
    public final void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant) {
        this.vm.prependVariable(xNContext, this.name, xOMVariant.asPrimitive(xNContext));
    }

    @Override
    public final void putAfterContents(XNContext xNContext, XOMVariant xOMVariant) {
        this.vm.appendVariable(xNContext, this.name, xOMVariant.asPrimitive(xNContext));
    }

    @Override
    public final void putIntoContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        throw new XNScriptError("Can't understand this");
    }

    @Override
    public final void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        throw new XNScriptError("Can't understand this");
    }

    @Override
    public final void putAfterContents(XNContext xNContext, XOMVariant xOMVariant, String string, XOMVariant xOMVariant2) {
        throw new XNScriptError("Can't understand this");
    }

    @Override
    public final boolean canSortContents(XNContext xNContext) {
        return true;
    }

    @Override
    public final void sortContents(XNContext xNContext, XOMComparator xOMComparator) {
        XOMVariant xOMVariant = this.vm.getVariable(xNContext, this.name);
        if (xOMVariant != null) {
            Object object;
            Vector<? extends XOMVariant> vector = new Vector<XOMVariant>();
            if (xOMVariant instanceof XOMList) {
                vector.addAll(xOMVariant.toPrimitiveList(xNContext));
            } else if (xOMVariant instanceof XOMDictionary) {
                for (String string : ((XOMDictionary)xOMVariant).toMap().keySet()) {
                    vector.add(new XOMString(string));
                }
            } else if (xOMVariant instanceof XOMBinary) {
                for (String string : (Object)((XOMBinary)xOMVariant).toByteArray()) {
                    vector.add(new XOMBinary(new byte[]{(byte)string}));
                }
            } else {
                for (String string : xOMVariant.toTextString(xNContext).split("\r\n|\r|\n|\u2028|\u2029")) {
                    vector.add(new XOMString(string));
                }
            }
            Collections.sort(vector, xOMComparator);
            if (xOMVariant instanceof XOMList) {
                this.vm.setVariable(xNContext, this.name, new XOMList(vector));
            } else if (xOMVariant instanceof XOMDictionary) {
                object = ((XOMDictionary)xOMVariant).toMap();
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (XOMVariant xOMVariant2 : vector) {
                    linkedHashMap.put(xOMVariant2.toTextString(xNContext), object.get(xOMVariant2.toTextString(xNContext)));
                }
                this.vm.setVariable(xNContext, this.name, new XOMDictionary(linkedHashMap));
            } else if (xOMVariant instanceof XOMBinary) {
                object = new byte[vector.size()];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = ((XOMBinary)vector.get(i)).toByteArray()[0];
                }
                this.vm.setVariable(xNContext, this.name, new XOMBinary((byte[])object));
            } else {
                object = xNContext.getLineEnding();
                StringBuffer stringBuffer = new StringBuffer();
                for (XOMVariant xOMVariant3 : vector) {
                    stringBuffer.append(xOMVariant3.toTextString(xNContext));
                    stringBuffer.append((String)object);
                }
                if (stringBuffer.length() >= ((String)object).length()) {
                    stringBuffer.delete(stringBuffer.length() - ((String)object).length(), stringBuffer.length());
                }
                this.vm.setVariable(xNContext, this.name, new XOMString(stringBuffer.toString()));
            }
        }
    }

    @Override
    public final boolean canGetProperty(XNContext xNContext, String string) {
        return this.getContents(xNContext).canGetProperty(xNContext, string);
    }

    @Override
    public final XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        return this.getContents(xNContext).getProperty(xNContext, xNModifier, string);
    }

    @Override
    public final boolean canSetProperty(XNContext xNContext, String string) {
        return this.getContents(xNContext).canSetProperty(xNContext, string);
    }

    @Override
    public final void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
        this.getContents(xNContext).setProperty(xNContext, string, xOMVariant);
    }

    @Override
    public final String toLanguageString() {
        return this.name;
    }

    @Override
    public final String toTextString(XNContext xNContext) {
        if (this.vm.isVariableDeclared(xNContext, this.name)) {
            return this.vm.getVariable(xNContext, this.name).toTextString(xNContext);
        }
        return this.name;
    }

    @Override
    public final List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        if (this.vm.isVariableDeclared(xNContext, this.name)) {
            return this.vm.getVariable(xNContext, this.name).toVariantList(xNContext);
        }
        return Arrays.asList(new XOMString(this.name));
    }

    @Override
    public final List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        if (this.vm.isVariableDeclared(xNContext, this.name)) {
            return this.vm.getVariable(xNContext, this.name).toPrimitiveList(xNContext);
        }
        return Arrays.asList(new XOMString(this.name));
    }

    @Override
    public final int hashCode() {
        return this.vm.hashCode() ^ this.name.toLowerCase().hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof XOMVariable) {
            XOMVariable xOMVariable = (XOMVariable)object;
            return this.vm.equals(xOMVariable.vm) && this.name.equalsIgnoreCase(xOMVariable.name);
        }
        return false;
    }
}

