/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.xom.XOMComparator;
import com.kreative.openxion.xom.XOMContainer;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMString;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMClipboard
extends XOMContainer
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    public static final XOMClipboard CLIPBOARD = new XOMClipboard();

    private XOMClipboard() {
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void setClipboardString(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), this);
    }

    private String getClipboardString() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                return (String)clipboard.getData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "";
            }
        }
        return "";
    }

    @Override
    public boolean canGetContents(XNContext xNContext) {
        return xNContext.allow(XNSecurityKey.CLIPBOARD_READ, "Operation", "Read");
    }

    @Override
    public XOMVariant getContents(XNContext xNContext) {
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_READ, "Operation", "Read")) {
            throw new XNScriptError("Security settings do not allow clipboard access");
        }
        return new XOMString(this.getClipboardString());
    }

    @Override
    public boolean canPutContents(XNContext xNContext) {
        return xNContext.allow(XNSecurityKey.CLIPBOARD_WRITE, "Operation", "Write");
    }

    @Override
    public void putIntoContents(XNContext xNContext, XOMVariant xOMVariant) {
        String string = xOMVariant.toTextString(xNContext);
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_WRITE, "Operation", "Write", "Value", string)) {
            throw new XNScriptError("Security settings do not allow clipboard access");
        }
        this.setClipboardString(string);
    }

    @Override
    public void putBeforeContents(XNContext xNContext, XOMVariant xOMVariant) {
        String string = xOMVariant.toTextString(xNContext);
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_WRITE, "Operation", "Write", "Value", string)) {
            throw new XNScriptError("Security settings do not allow clipboard access");
        }
        this.setClipboardString(string + this.getClipboardString());
    }

    @Override
    public void putAfterContents(XNContext xNContext, XOMVariant xOMVariant) {
        String string = xOMVariant.toTextString(xNContext);
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_WRITE, "Operation", "Write", "Value", string)) {
            throw new XNScriptError("Security settings do not allow clipboard access");
        }
        this.setClipboardString(this.getClipboardString() + string);
    }

    @Override
    public boolean canSortContents(XNContext xNContext) {
        return xNContext.allow(XNSecurityKey.CLIPBOARD_WRITE, "Operation", "Sort");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sortContents(XNContext xNContext, XOMComparator xOMComparator) {
        void xOMVariant;
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_WRITE, "Operation", "Sort")) {
            throw new XNScriptError("Security settings do not allow clipboard access");
        }
        Vector<XOMString> vector = new Vector<XOMString>();
        String[] stringArray = this.getClipboardString().split("\r\n|\r|\n|\u2028|\u2029");
        Object stringBuffer = stringArray;
        int n = ((String[])stringBuffer).length;
        boolean bl = false;
        while (xOMVariant < n) {
            String string = stringBuffer[xOMVariant];
            vector.add(new XOMString(string));
            ++xOMVariant;
        }
        Collections.sort(vector, xOMComparator);
        stringBuffer = new StringBuffer();
        for (XOMVariant xOMVariant2 : vector) {
            ((StringBuffer)stringBuffer).append(xOMVariant2.toTextString(xNContext) + xNContext.getLineEnding());
        }
        if (((StringBuffer)stringBuffer).length() > 0 && ((StringBuffer)stringBuffer).substring(((StringBuffer)stringBuffer).length() - xNContext.getLineEnding().length()).equals(xNContext.getLineEnding())) {
            ((StringBuffer)stringBuffer).delete(((StringBuffer)stringBuffer).length() - xNContext.getLineEnding().length(), ((StringBuffer)stringBuffer).length());
        }
        this.setClipboardString(((StringBuffer)stringBuffer).toString());
    }

    @Override
    public String toLanguageString() {
        return "the clipboard";
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_READ, "Operation", "Read")) {
            return "the clipboard";
        }
        return this.getClipboardString();
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        if (!xNContext.allow(XNSecurityKey.CLIPBOARD_READ, "Operation", "Read")) {
            return Arrays.asList(this);
        }
        return Arrays.asList(new XOMString(this.getClipboardString()));
    }

    @Override
    public int hashCode() {
        return -1094643093;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof XOMClipboard;
    }
}

