/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMComplex
extends XOMValue {
    private static final long serialVersionUID = 1L;
    public static final XOMComplex ZERO = new XOMComplex(BigDecimal.ZERO, BigDecimal.ZERO);
    public static final XOMComplex ONE = new XOMComplex(BigDecimal.ONE, BigDecimal.ZERO);
    public static final XOMComplex TEN = new XOMComplex(BigDecimal.TEN, BigDecimal.ZERO);
    public static final XOMComplex PI = new XOMComplex(XOMNumber.BIGDECIMAL_PI, BigDecimal.ZERO);
    public static final XOMComplex E = new XOMComplex(XOMNumber.BIGDECIMAL_E, BigDecimal.ZERO);
    public static final XOMComplex PHI = new XOMComplex(XOMNumber.BIGDECIMAL_PHI, BigDecimal.ZERO);
    public static final XOMComplex POSITIVE_INFINITY = new XOMComplex(false, 1.0, 0.0);
    public static final XOMComplex NEGATIVE_INFINITY = new XOMComplex(false, -1.0, 0.0);
    public static final XOMComplex NaN = new XOMComplex(true, 0.0, 0.0);
    public static final XOMComplex I = new XOMComplex(BigDecimal.ZERO, BigDecimal.ONE);
    private BigDecimal realPart;
    private BigDecimal imaginaryPart;
    private boolean undefined;
    public static final int QUADRANT_NaN = -1;
    public static final int QUADRANT_ZERO = 0;
    public static final int QUADRANT_POSITIVE_REAL = 1;
    public static final int QUADRANT_NEGATIVE_REAL = 2;
    public static final int QUADRANT_POSITIVE_IMAGINARY = 4;
    public static final int QUADRANT_NEGATIVE_IMAGINARY = 8;
    public static final int QUADRANT_I = 5;
    public static final int QUADRANT_II = 6;
    public static final int QUADRANT_III = 10;
    public static final int QUADRANT_IV = 9;

    public XOMComplex(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this.realPart = bigDecimal;
        this.imaginaryPart = bigDecimal2;
        this.undefined = false;
    }

    public XOMComplex(BigInteger bigInteger, BigInteger bigInteger2) {
        this.realPart = new BigDecimal(bigInteger);
        this.imaginaryPart = new BigDecimal(bigInteger2);
        this.undefined = false;
    }

    public XOMComplex(XOMNumber xOMNumber, XOMNumber xOMNumber2) {
        if (xOMNumber.isNaN() || xOMNumber2.isNaN()) {
            this.realPart = BigDecimal.ZERO;
            this.imaginaryPart = BigDecimal.ZERO;
            this.undefined = true;
        } else if (xOMNumber.isInfinite() || xOMNumber2.isInfinite()) {
            this.realPart = xOMNumber.signum().toBigDecimal();
            this.imaginaryPart = xOMNumber2.signum().toBigDecimal();
            this.undefined = true;
        } else {
            this.realPart = xOMNumber.toBigDecimal();
            this.imaginaryPart = xOMNumber2.toBigDecimal();
            this.undefined = false;
        }
    }

    public XOMComplex(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            this.realPart = BigDecimal.ZERO;
            this.imaginaryPart = BigDecimal.ZERO;
            this.undefined = true;
        } else if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            this.realPart = BigDecimal.valueOf(Math.signum(d));
            this.imaginaryPart = BigDecimal.valueOf(Math.signum(d2));
            this.undefined = true;
        } else {
            this.realPart = BigDecimal.valueOf(d);
            this.imaginaryPart = BigDecimal.valueOf(d2);
            this.undefined = false;
        }
    }

    public XOMComplex(float f, float f2) {
        if (Float.isNaN(f) || Float.isNaN(f2)) {
            this.realPart = BigDecimal.ZERO;
            this.imaginaryPart = BigDecimal.ZERO;
            this.undefined = true;
        } else if (Float.isInfinite(f) || Float.isInfinite(f2)) {
            this.realPart = BigDecimal.valueOf(Math.signum(f));
            this.imaginaryPart = BigDecimal.valueOf(Math.signum(f2));
            this.undefined = true;
        } else {
            this.realPart = BigDecimal.valueOf(f);
            this.imaginaryPart = BigDecimal.valueOf(f2);
            this.undefined = false;
        }
    }

    public XOMComplex(long l, long l2) {
        this.realPart = BigDecimal.valueOf(l);
        this.imaginaryPart = BigDecimal.valueOf(l2);
        this.undefined = false;
    }

    public XOMComplex(int n, int n2) {
        this.realPart = BigDecimal.valueOf(n);
        this.imaginaryPart = BigDecimal.valueOf(n2);
        this.undefined = false;
    }

    public XOMComplex(short s, short s2) {
        this.realPart = BigDecimal.valueOf(s);
        this.imaginaryPart = BigDecimal.valueOf(s2);
        this.undefined = false;
    }

    public XOMComplex(byte by, byte by2) {
        this.realPart = BigDecimal.valueOf(by);
        this.imaginaryPart = BigDecimal.valueOf(by2);
        this.undefined = false;
    }

    public static XOMComplex makeInfinity(double d, double d2) {
        return new XOMComplex(false, d, d2);
    }

    private XOMComplex(boolean bl, double d, double d2) {
        this.realPart = bl ? BigDecimal.ZERO : BigDecimal.valueOf(d);
        this.imaginaryPart = bl ? BigDecimal.ZERO : BigDecimal.valueOf(d2);
        this.undefined = true;
    }

    public boolean isUndefined() {
        return this.realPart == null || this.imaginaryPart == null || this.undefined;
    }

    public boolean isNaN() {
        return this.realPart == null || this.imaginaryPart == null || this.undefined && this.realPart.compareTo(BigDecimal.ZERO) == 0 && this.imaginaryPart.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isInfinite() {
        return this.realPart != null && this.imaginaryPart != null && this.undefined && (this.realPart.compareTo(BigDecimal.ZERO) != 0 || this.imaginaryPart.compareTo(BigDecimal.ZERO) != 0);
    }

    public boolean isReal() {
        return this.realPart != null && this.imaginaryPart != null && !this.undefined && this.imaginaryPart.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isZero() {
        return this.realPart != null && this.imaginaryPart != null && !this.undefined && this.realPart.compareTo(BigDecimal.ZERO) == 0 && this.imaginaryPart.compareTo(BigDecimal.ZERO) == 0;
    }

    public int getQuadrant() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return -1;
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return -1;
            }
            return (n < 0 ? 2 : (n > 0 ? 1 : 0)) | (n2 < 0 ? 8 : (n2 > 0 ? 4 : 0));
        }
        int n = this.realPart.compareTo(BigDecimal.ZERO);
        int n3 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
        return (n < 0 ? 2 : (n > 0 ? 1 : 0)) | (n3 < 0 ? 8 : (n3 > 0 ? 4 : 0));
    }

    public int getOppositeQuadrant() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return -1;
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return -1;
            }
            return (n < 0 ? 1 : (n > 0 ? 2 : 0)) | (n2 < 0 ? 4 : (n2 > 0 ? 8 : 0));
        }
        int n = this.realPart.compareTo(BigDecimal.ZERO);
        int n3 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
        return (n < 0 ? 1 : (n > 0 ? 2 : 0)) | (n3 < 0 ? 4 : (n3 > 0 ? 8 : 0));
    }

    public XOMComplex negate() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return NaN;
            }
            return new XOMComplex(n < 0 ? Double.POSITIVE_INFINITY : (n > 0 ? Double.NEGATIVE_INFINITY : 0.0), n2 < 0 ? Double.POSITIVE_INFINITY : (n2 > 0 ? Double.NEGATIVE_INFINITY : 0.0));
        }
        return new XOMComplex(this.realPart.negate(), this.imaginaryPart.negate());
    }

    public XOMComplex conj() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return NaN;
            }
            return new XOMComplex(n < 0 ? Double.NEGATIVE_INFINITY : (n > 0 ? Double.POSITIVE_INFINITY : 0.0), n2 < 0 ? Double.POSITIVE_INFINITY : (n2 > 0 ? Double.NEGATIVE_INFINITY : 0.0));
        }
        return new XOMComplex(this.realPart, this.imaginaryPart.negate());
    }

    public XOMComplex ceil() {
        return this.round(RoundingMode.CEILING);
    }

    public XOMComplex floor() {
        return this.round(RoundingMode.FLOOR);
    }

    public XOMComplex round() {
        return this.round(RoundingMode.HALF_UP);
    }

    public XOMComplex aug() {
        return this.round(RoundingMode.UP);
    }

    public XOMComplex trunc() {
        return this.round(RoundingMode.DOWN);
    }

    public XOMComplex rint() {
        return this.round(RoundingMode.HALF_EVEN);
    }

    public XOMComplex round(RoundingMode roundingMode) {
        if (this.realPart == null || this.imaginaryPart == null || this.undefined) {
            return this;
        }
        return new XOMComplex(this.realPart.divide(BigDecimal.ONE, 0, roundingMode), this.imaginaryPart.divide(BigDecimal.ONE, 0, roundingMode));
    }

    public XOMComplex frac() {
        if (this.realPart == null || this.imaginaryPart == null || this.undefined) {
            return NaN;
        }
        return new XOMComplex(this.realPart.subtract(this.realPart.divide(BigDecimal.ONE, 0, RoundingMode.DOWN)), this.imaginaryPart.subtract(this.imaginaryPart.divide(BigDecimal.ONE, 0, RoundingMode.DOWN)));
    }

    public XOMNumber Re() {
        if (this.realPart == null) {
            return XOMNumber.NaN;
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return XOMNumber.NEGATIVE_INFINITY;
            }
            if (n > 0) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(this.realPart);
    }

    public XOMNumber Im() {
        if (this.imaginaryPart == null) {
            return XOMNumber.NaN;
        }
        if (this.undefined) {
            int n = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n < 0) {
                return XOMNumber.NEGATIVE_INFINITY;
            }
            if (n > 0) {
                return XOMNumber.POSITIVE_INFINITY;
            }
            return XOMNumber.NaN;
        }
        return new XOMNumber(this.imaginaryPart);
    }

    public BigDecimal realPart() {
        if (this.realPart == null || this.imaginaryPart == null || this.undefined) {
            return null;
        }
        return this.realPart;
    }

    public BigDecimal imaginaryPart() {
        if (this.realPart == null || this.imaginaryPart == null || this.undefined) {
            return null;
        }
        return this.imaginaryPart;
    }

    public Number[] toNumbers() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return new Double[]{Double.NaN, Double.NaN};
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return new Double[]{Double.NaN, Double.NaN};
            }
            return new Double[]{n < 0 ? Double.NEGATIVE_INFINITY : (n > 0 ? Double.POSITIVE_INFINITY : 0.0), n2 < 0 ? Double.NEGATIVE_INFINITY : (n2 > 0 ? Double.POSITIVE_INFINITY : 0.0)};
        }
        return new BigDecimal[]{this.realPart, this.imaginaryPart};
    }

    public BigDecimal[] toBigDecimals() {
        if (this.realPart == null || this.imaginaryPart == null || this.undefined) {
            return null;
        }
        return new BigDecimal[]{this.realPart, this.imaginaryPart};
    }

    public double[] toDoubles() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return new double[]{Double.NaN, Double.NaN};
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return new double[]{Double.NaN, Double.NaN};
            }
            double[] dArray = new double[2];
            double d = n < 0 ? Double.NEGATIVE_INFINITY : (dArray[0] = n > 0 ? Double.POSITIVE_INFINITY : 0.0);
            dArray[1] = n2 < 0 ? Double.NEGATIVE_INFINITY : (n2 > 0 ? Double.POSITIVE_INFINITY : 0.0);
            return dArray;
        }
        return new double[]{this.realPart.doubleValue(), this.imaginaryPart.doubleValue()};
    }

    public XOMNumber[] toXOMNumbers() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return new XOMNumber[]{XOMNumber.NaN, XOMNumber.NaN};
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return new XOMNumber[]{XOMNumber.NaN, XOMNumber.NaN};
            }
            XOMNumber[] xOMNumberArray = new XOMNumber[2];
            XOMNumber xOMNumber = n < 0 ? XOMNumber.NEGATIVE_INFINITY : (xOMNumberArray[0] = n > 0 ? XOMNumber.POSITIVE_INFINITY : XOMNumber.ZERO);
            xOMNumberArray[1] = n2 < 0 ? XOMNumber.NEGATIVE_INFINITY : (n2 > 0 ? XOMNumber.POSITIVE_INFINITY : XOMNumber.ZERO);
            return xOMNumberArray;
        }
        return new XOMNumber[]{new XOMNumber(this.realPart), new XOMNumber(this.imaginaryPart)};
    }

    @Override
    public String toLanguageString() {
        if (this.realPart == null || this.imaginaryPart == null) {
            return "NAN";
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return "NAN";
            }
            return "(" + (n < 0 ? "-INF" : (n > 0 ? "INF" : "0")) + "," + (n2 < 0 ? "-INF" : (n2 > 0 ? "INF" : "0")) + ")";
        }
        return "(" + this.realPart.toString().replaceAll("[Ee][-]([0-9]+)", "''$1").replaceAll("[Ee][+]?([0-9]+)", "'$1") + "," + this.imaginaryPart.toString().replaceAll("[Ee][-]([0-9]+)", "''$1").replaceAll("[Ee][+]?([0-9]+)", "'$1") + ")";
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.realPart == null || this.imaginaryPart == null) {
            return "NAN";
        }
        if (this.undefined) {
            int n = this.realPart.compareTo(BigDecimal.ZERO);
            int n2 = this.imaginaryPart.compareTo(BigDecimal.ZERO);
            if (n == 0 && n2 == 0) {
                return "NAN";
            }
            return (n < 0 ? "-INF" : (n > 0 ? "INF" : "0")) + "," + (n2 < 0 ? "-INF" : (n2 > 0 ? "INF" : "0"));
        }
        return xNContext.getNumberFormat().format(this.realPart) + "," + xNContext.getNumberFormat().format(this.imaginaryPart);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.realPart == null || this.imaginaryPart == null ? 0 : (this.undefined ? this.realPart.signum() * 3 + this.imaginaryPart.signum() : this.realPart.hashCode() ^ this.imaginaryPart.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMComplex) {
            XOMComplex xOMComplex = (XOMComplex)object;
            if (this.isNaN() && xOMComplex.isNaN()) {
                return true;
            }
            if (this.isNaN() || xOMComplex.isNaN()) {
                return false;
            }
            if (this.undefined && xOMComplex.undefined) {
                return this.getQuadrant() == xOMComplex.getQuadrant();
            }
            if (this.undefined || xOMComplex.undefined) {
                return false;
            }
            return this.realPart.compareTo(xOMComplex.realPart) == 0 && this.imaginaryPart.compareTo(xOMComplex.imaginaryPart) == 0;
        }
        return false;
    }
}

