/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMObject;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMDate;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMDateType;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMFile
extends XOMObject {
    private static final long serialVersionUID = 1L;
    private File theFile;

    public XOMFile(String string) {
        this.theFile = new File(string).getAbsoluteFile();
    }

    public XOMFile(File file) {
        this.theFile = file.getAbsoluteFile();
    }

    public boolean isFolder() {
        return this.theFile != null && this.theFile.isDirectory();
    }

    public boolean isFile() {
        return this.theFile != null && !this.theFile.isDirectory();
    }

    public boolean isDisk() {
        return this.theFile != null && this.theFile.isDirectory() && this.theFile.getParentFile() == null;
    }

    public boolean isFork() {
        return this.theFile != null && !this.theFile.isDirectory() && this.theFile.getParentFile() != null && this.theFile.getParentFile().getName().equals("..namedfork");
    }

    public File toFile() {
        return this.theFile;
    }

    @Override
    public boolean canGetParent(XNContext xNContext) {
        return xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetParent") && this.theFile != null && this.theFile.getParentFile() != null;
    }

    @Override
    public XOMVariant getParent(XNContext xNContext) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetParent")) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        if (this.theFile == null || this.theFile.getParentFile() == null) {
            return null;
        }
        return new XOMFile(this.theFile.getParentFile());
    }

    @Override
    public boolean canDelete(XNContext xNContext) {
        return xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Delete");
    }

    @Override
    public void delete(XNContext xNContext) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Delete")) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        if (!this.theFile.delete()) {
            super.delete(xNContext);
        }
    }

    @Override
    public boolean canGetProperty(XNContext xNContext, String string) {
        return xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetProperty", "Property", string) && (string.equalsIgnoreCase("name") || string.equalsIgnoreCase("path") || string.equalsIgnoreCase("modificationDate") || string.equalsIgnoreCase("size") && !this.theFile.isDirectory() || string.equalsIgnoreCase("count") && this.theFile.isDirectory());
    }

    @Override
    public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "GetProperty", "Property", string)) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        if (string.equalsIgnoreCase("name")) {
            return new XOMString(this.theFile.getName());
        }
        if (string.equalsIgnoreCase("path")) {
            return new XOMString(this.theFile.getAbsolutePath());
        }
        if (string.equalsIgnoreCase("modificationDate")) {
            return new XOMDate(new Date(this.theFile.lastModified()));
        }
        if (string.equalsIgnoreCase("size") && !this.theFile.isDirectory()) {
            return new XOMInteger(this.theFile.length());
        }
        if (string.equalsIgnoreCase("count") && this.theFile.isDirectory()) {
            return new XOMInteger(this.theFile.listFiles().length);
        }
        return super.getProperty(xNContext, xNModifier, string);
    }

    @Override
    public boolean canSetProperty(XNContext xNContext, String string) {
        return xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "SetProperty", "Property", string) && (string.equalsIgnoreCase("name") || string.equalsIgnoreCase("path") || string.equalsIgnoreCase("modificationDate"));
    }

    @Override
    public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "SetProperty", "Property", string, "Value", xOMVariant.toTextString(xNContext))) {
            throw new XNScriptError("Security settings do not allow file system access");
        }
        if (string.equalsIgnoreCase("name")) {
            this.theFile.renameTo(new File(this.theFile.getParentFile(), xOMVariant.toTextString(xNContext)));
        } else if (string.equalsIgnoreCase("path")) {
            this.theFile.renameTo(new File(xOMVariant.toTextString(xNContext)));
        } else if (string.equalsIgnoreCase("modificationDate")) {
            this.theFile.setLastModified(((XOMDate)XOMDateType.instance.makeInstanceFrom(xNContext, xOMVariant.asPrimitive(xNContext))).toDate().getTime());
        } else {
            super.setProperty(xNContext, string, xOMVariant);
        }
    }

    @Override
    public String toLanguageString() {
        if (this.theFile.isDirectory()) {
            if (this.theFile.getParentFile() == null) {
                return "disk " + XIONUtil.quote(this.theFile.getAbsolutePath());
            }
            return "folder " + XIONUtil.quote(this.theFile.getAbsolutePath());
        }
        if (this.theFile.getParentFile() != null && this.theFile.getParentFile().getName().equals("..namedfork")) {
            return "fork " + XIONUtil.quote(this.theFile.getAbsolutePath());
        }
        return "file " + XIONUtil.quote(this.theFile.getAbsolutePath());
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.theFile.isDirectory()) {
            if (this.theFile.getParentFile() == null) {
                return "disk " + XIONUtil.quote(this.theFile.getAbsolutePath());
            }
            return "folder " + XIONUtil.quote(this.theFile.getAbsolutePath());
        }
        if (this.theFile.getParentFile() != null && this.theFile.getParentFile().getName().equals("..namedfork")) {
            return "fork " + XIONUtil.quote(this.theFile.getAbsolutePath());
        }
        return "file " + XIONUtil.quote(this.theFile.getAbsolutePath());
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.theFile == null ? 0 : this.theFile.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMFile) {
            XOMFile xOMFile = (XOMFile)object;
            if (this.theFile == null && xOMFile.theFile == null) {
                return true;
            }
            if (this.theFile == null || xOMFile.theFile == null) {
                return false;
            }
            return this.theFile.equals(xOMFile.theFile);
        }
        return false;
    }
}

