/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.xom.inst;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.xom.XOMValue;
import com.kreative.openxion.xom.XOMVariant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOMInteger
extends XOMValue {
    private static final long serialVersionUID = 1L;
    public static final XOMInteger ZERO = new XOMInteger(BigInteger.ZERO);
    public static final XOMInteger ONE = new XOMInteger(BigInteger.ONE);
    public static final XOMInteger TEN = new XOMInteger(BigInteger.TEN);
    public static final XOMInteger POSITIVE_INFINITY = new XOMInteger(false, false);
    public static final XOMInteger NEGATIVE_INFINITY = new XOMInteger(false, true);
    public static final XOMInteger NaN = new XOMInteger(true, false);
    private BigInteger theInteger;
    private boolean undefined;
    public static final int SIGN_NaN = Integer.MIN_VALUE;
    public static final int SIGN_NEGATIVE = -1;
    public static final int SIGN_ZERO = 0;
    public static final int SIGN_POSITIVE = 1;

    public XOMInteger(Number number) {
        if (number == null) {
            this.theInteger = BigInteger.ZERO;
            this.undefined = true;
        } else if (number instanceof BigInteger) {
            this.theInteger = (BigInteger)number;
            this.undefined = false;
        } else if (number instanceof BigDecimal) {
            this.theInteger = ((BigDecimal)number).toBigInteger();
            this.undefined = false;
        } else if (number instanceof Double) {
            double d = number.doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                this.theInteger = Double.isNaN(d) ? BigInteger.ZERO : (d < 0.0 ? BigInteger.ONE.negate() : BigInteger.ONE);
                this.undefined = true;
            } else {
                this.theInteger = BigDecimal.valueOf(d).toBigInteger();
                this.undefined = false;
            }
        } else if (number instanceof Float) {
            float f = number.floatValue();
            if (Float.isNaN(f) || Float.isInfinite(f)) {
                this.theInteger = Float.isNaN(f) ? BigInteger.ZERO : (f < 0.0f ? BigInteger.ONE.negate() : BigInteger.ONE);
                this.undefined = true;
            } else {
                this.theInteger = new BigDecimal(Float.toString(f)).toBigInteger();
                this.undefined = false;
            }
        } else {
            this.theInteger = BigInteger.valueOf(number.longValue());
            this.undefined = false;
        }
    }

    private XOMInteger(boolean bl, boolean bl2) {
        this.theInteger = bl ? BigInteger.ZERO : (bl2 ? BigInteger.ONE.negate() : BigInteger.ONE);
        this.undefined = true;
    }

    public boolean isUndefined() {
        return this.theInteger == null || this.undefined;
    }

    public boolean isNaN() {
        return this.theInteger == null || this.undefined && this.theInteger.equals(BigInteger.ZERO);
    }

    public boolean isInfinite() {
        return this.theInteger != null && this.undefined && !this.theInteger.equals(BigInteger.ZERO);
    }

    public boolean isZero() {
        return this.theInteger != null && !this.undefined && this.theInteger.equals(BigInteger.ZERO);
    }

    public int getSign() {
        if (this.theInteger == null) {
            return Integer.MIN_VALUE;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }
        int n = this.theInteger.compareTo(BigInteger.ZERO);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    public int getOppositeSign() {
        if (this.theInteger == null) {
            return Integer.MIN_VALUE;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return 1;
            }
            if (n > 0) {
                return -1;
            }
            return Integer.MIN_VALUE;
        }
        int n = this.theInteger.compareTo(BigInteger.ZERO);
        if (n < 0) {
            return 1;
        }
        if (n > 0) {
            return -1;
        }
        return 0;
    }

    public XOMInteger abs() {
        if (this.theInteger == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n == 0) {
                return NaN;
            }
            return POSITIVE_INFINITY;
        }
        return new XOMInteger(this.theInteger.abs());
    }

    public XOMInteger negate() {
        if (this.theInteger == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return POSITIVE_INFINITY;
            }
            if (n > 0) {
                return NEGATIVE_INFINITY;
            }
            return NaN;
        }
        return new XOMInteger(this.theInteger.negate());
    }

    public XOMInteger signum() {
        if (this.theInteger == null) {
            return NaN;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n > 0) {
                return ONE;
            }
            if (n < 0) {
                return ONE.negate();
            }
            return NaN;
        }
        int n = this.theInteger.compareTo(BigInteger.ZERO);
        if (n > 0) {
            return ONE;
        }
        if (n < 0) {
            return ONE.negate();
        }
        return ZERO;
    }

    public Number toNumber() {
        if (this.theInteger == null) {
            return Double.NaN;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (n > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return this.theInteger;
    }

    public BigInteger toBigInteger() {
        if (this.theInteger == null || this.undefined) {
            return null;
        }
        return this.theInteger;
    }

    public double toDouble() {
        if (this.theInteger == null) {
            return Double.NaN;
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (n > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return this.theInteger.doubleValue();
    }

    public long toLong() {
        if (this.theInteger == null || this.undefined) {
            return 0L;
        }
        return this.theInteger.longValue();
    }

    public int toInt() {
        if (this.theInteger == null || this.undefined) {
            return 0;
        }
        return this.theInteger.intValue();
    }

    @Override
    public String toLanguageString() {
        if (this.theInteger == null) {
            return "NAN";
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return "-INF";
            }
            if (n > 0) {
                return "INF";
            }
            return "NAN";
        }
        return this.theInteger.toString();
    }

    @Override
    public String toTextString(XNContext xNContext) {
        if (this.theInteger == null) {
            return "NAN";
        }
        if (this.undefined) {
            int n = this.theInteger.compareTo(BigInteger.ZERO);
            if (n < 0) {
                return "-INF";
            }
            if (n > 0) {
                return "INF";
            }
            return "NAN";
        }
        return xNContext.getNumberFormat().format(this.theInteger);
    }

    @Override
    public List<? extends XOMVariant> toVariantList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public List<? extends XOMVariant> toPrimitiveList(XNContext xNContext) {
        return Arrays.asList(this);
    }

    @Override
    public int hashCode() {
        return this.theInteger == null ? 0 : (this.undefined ? this.theInteger.signum() : this.theInteger.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof XOMInteger) {
            XOMInteger xOMInteger = (XOMInteger)object;
            if (this.isNaN() && xOMInteger.isNaN()) {
                return true;
            }
            if (this.isNaN() || xOMInteger.isNaN()) {
                return false;
            }
            if (this.undefined && xOMInteger.undefined) {
                return this.theInteger.compareTo(BigInteger.ZERO) == xOMInteger.theInteger.compareTo(BigInteger.ZERO);
            }
            if (this.undefined || xOMInteger.undefined) {
                return false;
            }
            return this.theInteger.compareTo(xOMInteger.theInteger) == 0;
        }
        return false;
    }
}

